/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcFormHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.EvaluationNatureEnum;
import kd.tmc.tmbrm.common.helper.EvaluationAssistanceHelper;
import org.apache.commons.lang3.StringUtils;

public class EvaluationAssistanceEdit
extends AbstractFormPlugin {
    private static final String ROW_SUFFIX = "row";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"ruletoolbarap", "reftoolbarap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long itemId = (Long)this.getView().getFormShowParameter().getCustomParam("evaluateitem");
        DynamicObject item = TmcDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"tmbrm_evaluationitem");
        IDataModel model = this.getModel();
        model.setValue("item", (Object)item);
        model.setValue("itemmaxscore", (Object)item.getBigDecimal("maxscore"));
        this.refreshRefData();
        this.setRuleEntryStyle(item);
    }

    private void setRuleEntryStyle(DynamicObject item) {
        boolean isHideAmount = EvaluationNatureEnum.QUALITY.getValue().equals(item.getString("nature"));
        CardEntry cardEntry = (CardEntry)this.getView().getControl("ruleentry");
        DynamicObjectCollection entryEntity = item.getDynamicObjectCollection("ruleentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject row;
            if (isHideAmount) {
                cardEntry.setChildVisible(false, i, new String[]{"ruleamountpanel"});
            }
            if (!StringUtils.isBlank((CharSequence)(row = (DynamicObject)entryEntity.get(i)).getString("rulecomment"))) continue;
            cardEntry.setChildVisible(false, i, new String[]{"rulecommentpanel"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.selectRefRow();
    }

    private void selectRefRow() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String row = (String)showParameter.getCustomParam(ROW_SUFFIX);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("refdataentry");
        cardEntry.selectCard(Integer.valueOf(Integer.parseInt(row)));
    }

    private void refreshRefData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String finOrgType = (String)parameter.getCustomParam("finorgtype");
        String finOrgs = (String)parameter.getCustomParam("finorg");
        Long itemId = (Long)parameter.getCustomParam("evaluateitem");
        DynamicObject item = TmcDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"tmbrm_evaluationitem");
        DynamicObjectCollection itemRefList = item.getDynamicObjectCollection("refentry");
        int refSize = itemRefList.size();
        Map<String, Boolean> hideMap = Collections.singletonMap("vi", Boolean.FALSE);
        if (EmptyUtil.isNotBlank((CharSequence)finOrgs) && refSize > 0) {
            Long[] orgIds = (Long[])Arrays.stream(StringUtils.split((String)finOrgs, (String)",")).map(Long::parseLong).toArray(Long[]::new);
            this.loadRefData(finOrgType, itemRefList, orgIds);
        }
        String hideRow = "bd_bankcgsetting".equals(finOrgType) ? "ifinorgrow" : "ibankrow";
        this.getView().updateControlMetadata(hideRow, hideMap);
        IntStream.range(refSize, 20).boxed().map(t -> "item" + t).forEach(t -> this.getView().updateControlMetadata(t, hideMap));
    }

    private void loadRefData(String finOrgType, DynamicObjectCollection itemRefList, Long[] orgIds) {
        int refSize = itemRefList.size();
        Map finOrgMap = TmcDataServiceHelper.loadFromCache((Object[])orgIds, (String)finOrgType);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String finOrgField = "bd_bankcgsetting".equals(finOrgType) ? "ibank" : "ifinorg";
        String finOrgLogField = finOrgField + "logo";
        String entry = "refdataentry";
        model.deleteEntryData(entry);
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(finOrgField, new Object[0]);
        vs.addField(finOrgLogField, new Object[0]);
        for (int i = 0; i < refSize; ++i) {
            vs.addField("title" + i, new Object[0]);
            vs.addField("data" + i, new Object[0]);
        }
        Map itemMap = EvaluationAssistanceHelper.getRefDataMap((Map)this.getView().getFormShowParameter().getCustomParams());
        for (Long org : orgIds) {
            ArrayList<Object> dataList = new ArrayList<Object>(10);
            dataList.add(org);
            dataList.add(TmcAttachmentHelper.getRealPath((String)((DynamicObject)finOrgMap.get(org)).getString("logo")));
            for (DynamicObject ref : itemRefList) {
                DynamicObject refQuota = ref.getDynamicObject("refquota");
                dataList.add(refQuota.getString("name"));
                String refKey = refQuota.getString("number");
                String val = (String)itemMap.get(org + "#" + refKey);
                val = EmptyUtil.isBlank((CharSequence)val) ? "" : val;
                dataList.add(val);
            }
            vs.addRow(dataList.toArray());
        }
        model.batchCreateNewEntryRow(entry, vs);
        model.endInit();
        this.getView().updateView(entry);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        FormShowParameter param = this.getView().getFormShowParameter();
        if ("tb_ruletblview".equals(itemKey)) {
            FormShowParameter showParameter = TmcFormHelper.createFormShowParameter((String)"tmbrm_evaluate_assirule");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParam("evaluateitem", param.getCustomParam("evaluateitem"));
            this.getView().showForm(showParameter);
        } else if ("tb_reftblview".equals(itemKey)) {
            FormShowParameter showParameter = TmcFormHelper.createFormShowParameter((String)"tmbrm_evaluate_refdata");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParams(param.getCustomParams());
            this.getView().showForm(showParameter);
        } else if ("tb_refreresh".equals(itemKey)) {
            this.refreshRefData();
            this.selectRefRow();
        }
    }
}

