/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.evaluation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tmbrm.common.enums.EvalMethodEnum;
import kd.tmc.tmbrm.common.enums.EvalWayEnum;
import kd.tmc.tmbrm.common.enums.EvaluationTaskStatusEnum;
import kd.tmc.tmbrm.common.enums.ScoreWayEnum;
import kd.tmc.tmbrm.common.helper.EvalTaskAutoScoreHelper;
import kd.tmc.tmbrm.common.helper.EvalTaskHelper;
import org.apache.commons.lang3.StringUtils;

public class EvaluationTaskEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener,
CellClickListener {
    private static final Log logger = LogFactory.getLog(EvaluationTaskEdit.class);
    private static final String CACHE_ITEM_SIZE = "itemSize";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid gridControl = (EntryGrid)this.getControl("entryentity");
        gridControl.addCellClickListener((CellClickListener)this);
        BasedataEdit finOrgControl = (BasedataEdit)this.getControl("finorg");
        finOrgControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"fintoolbarap"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("finorg".equals(key)) {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
            List qFilters = parameter.getListFilterParameter().getQFilters();
            qFilters.addAll(this.getFinOrgFilter(null));
            parameter.setMultiSelect(true);
        }
    }

    private List<QFilter> getFinOrgFilter(QFilter accountFilter) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        List hasIds = this.getModel().getEntryEntity("entryentity").stream().filter(t -> Objects.nonNull(t.getDynamicObject("finorg"))).map(t -> t.getDynamicObject("finorg").getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(hasIds)) {
            qFilters.add(new QFilter("id", "not in", hasIds));
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        qFilters.add(enableFilter);
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        String finOrgType = (String)model.getValue("finorgtype");
        DynamicObject schedule = (DynamicObject)model.getValue("schedule");
        DynamicObject fintype = schedule.getDynamicObject("fintype");
        fintype = TmcDataServiceHelper.loadSingleFromCache((Object)fintype.getPkValue(), (String)"bd_finorgtype");
        QFilter bankFilter = new QFilter("finorgtype", "=", (Object)fintype.getString("type"));
        if ("bd_finorginfo".equals(finOrgType)) {
            qFilters.add(new QFilter("finorgtype.id", "=", fintype.getPkValue()));
        }
        QFilter baseDataFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
        String idField = "bd_bankcgsetting".equals(finOrgType) ? "bank.bank_cate.id" : "bank.id";
        ArrayList<QFilter> accountFilters = new ArrayList<QFilter>(Arrays.asList(enableFilter, bankFilter, baseDataFilter));
        if (!EmptyUtil.isEmpty((Object)accountFilter)) {
            accountFilters.add(accountFilter);
        }
        Map bankMap = TmcDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)("id," + idField), (QFilter[])accountFilters.toArray(new QFilter[0]));
        Set orgSet = bankMap.values().stream().map(t -> t.getLong(idField)).collect(Collectors.toSet());
        logger.info("limit account size {}", (Object)orgSet.size());
        qFilters.add(new QFilter("id", "in", orgSet));
        return qFilters;
    }

    public void afterBindData(EventObject e) {
        String finOrgType;
        IDataModel model = this.getModel();
        DynamicObject schedule = (DynamicObject)model.getValue("schedule");
        String string = finOrgType = FinOrgTypeEnum.BANK.getNumber().equals(schedule.getDynamicObject("fintype").get("number")) && EvalWayEnum.HEAD.getValue().equals(schedule.getString("evalway")) ? "bd_bankcgsetting" : "bd_finorginfo";
        if (EmptyUtil.isEmpty((Object)model.getValue("finorgtype"))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"finorgtype", (Object)finOrgType);
        }
        DynamicObject proposal = schedule.getDynamicObject("evalproposal");
        this.refreshOrgList(proposal.getLong("id"));
        this.setFinOrgEntry(schedule, finOrgType);
        this.viewDetailScore(proposal.getLong("id"));
        this.setItemEnable(proposal.getLong("id"));
        this.autoScore(proposal.getLong("id"), true);
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        splitContainer.hidePanel(SplitDirection.right, true);
        if (EmptyUtil.isEmpty((Object)model.getValue("evaluator"))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"evaluator", (Object)RequestContext.get().getCurrUserId());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        if (Objects.nonNull(result) && result.isSuccess() && "autoscore".equals(operateKey)) {
            this.getView().updateView("entryentity");
        }
    }

    private void setFinOrgEntry(DynamicObject schedule, String finOrgType) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        List finOrgs = entryEntity.stream().map(t -> t.getDynamicObject("finorg")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        if (!EmptyUtil.isEmpty(finOrgs) || EvaluationTaskStatusEnum.TERMINATED.getValue().equals(model.getValue("evaluatestatus"))) {
            return;
        }
        if (!schedule.getBoolean("specify") && entryEntity.size() < 1) {
            this.getView().invokeOperation("newentry");
            return;
        }
        String targetField = "bd_bankcgsetting".equals(finOrgType) ? "evaltarget" : "evaltargetfin";
        DynamicObjectCollection targets = schedule.getDynamicObjectCollection(targetField);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)targets)) {
            return;
        }
        for (DynamicObject target : targets) {
            DynamicObject row = entryEntity.addNew();
            row.set("finorg", (Object)target.getDynamicObject("fbasedataid"));
        }
    }

    private void viewDetailScore(Long proposalId) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        boolean hasDetail = false;
        for (DynamicObject row : entryEntity) {
            String detail = row.getString("detailscore_tag");
            if (EmptyUtil.isBlank((CharSequence)detail)) continue;
            hasDetail = true;
            String[] items = detail.split(",");
            for (int i = 0; i < items.length; ++i) {
                row.set("item" + i, (Object)new BigDecimal(items[i]));
            }
        }
        if (hasDetail) {
            logger.info("\u5df2\u7ecf\u6709\u586b\u5199\u6570\u636e");
            this.getModel().setDataChanged(false);
        } else {
            this.autoScore(proposalId, false);
        }
        this.getView().updateView("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name.startsWith("item")) {
            EntryGrid entityControl = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entityControl.getSelectRows();
            int idx = selectRows[0];
            this.calculateScore(idx);
            this.setRowDetailScore(idx);
        } else if ("finorg".equals(name)) {
            DynamicObject schedule = (DynamicObject)this.getModel().getValue("schedule");
            DynamicObject proposal = schedule.getDynamicObject("evalproposal");
            this.autoScore(proposal.getLong("id"), false);
        }
    }

    private void setRowDetailScore(int idx) {
        IDataModel model = this.getModel();
        DynamicObject row = (DynamicObject)model.getEntryEntity("entryentity").get(idx);
        int itemSize = Integer.parseInt(this.getPageCache().get(CACHE_ITEM_SIZE));
        ArrayList<String> scoreList = new ArrayList<String>(itemSize);
        for (int i = 0; i < itemSize; ++i) {
            BigDecimal score = row.getBigDecimal("item" + i);
            scoreList.add(score.toString());
        }
        row.set("detailscore_tag", (Object)StringUtils.join(scoreList, (String)","));
    }

    private void setItemEnable(Long proposalId) {
        DynamicObjectCollection itemList = EvalTaskHelper.getProposalItemEntry((Long)proposalId);
        int len = itemList.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject item = (DynamicObject)itemList.get(i);
            if (!EvalMethodEnum.AUTO.getValue().equals(item.getDynamicObject("item").getString("evamethod"))) continue;
            TextEdit textEdit = (TextEdit)this.getControl("item" + i);
            textEdit.setEnable("", false, -1);
        }
    }

    private void autoScore(Long proposalId, boolean needCheck) {
        DynamicObjectCollection itemList = EvalTaskHelper.getProposalItemEntry((Long)proposalId);
        List autoItemList = itemList.stream().filter(e -> EvalMethodEnum.AUTO.getValue().equals(e.getDynamicObject("item").getString("evamethod"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(autoItemList)) {
            return;
        }
        int len = itemList.size();
        Map itemMap = EvalTaskHelper.getEvalItemsByIds((DynamicObjectCollection)itemList);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (needCheck) {
            this.checkCanAutoScore(entryEntity);
        }
        for (int i = 0; i < len; ++i) {
            DynamicObject item = ((DynamicObject)itemList.get(i)).getDynamicObject("item");
            if (!EvalMethodEnum.AUTO.getValue().equals(item.getString("evamethod"))) continue;
            item = (DynamicObject)itemMap.get(item.getPkValue());
            DynamicObject autoScoreScheme = EvalTaskAutoScoreHelper.getAutoScoreScheme((long)item.getDynamicObject("autoscorescheme").getLong("id"));
            int idx = 0;
            for (DynamicObject entry : entryEntity) {
                BigDecimal score = this.getAutoScore(autoScoreScheme, entry);
                entry.set("item" + i, (Object)score);
                this.calculateScore(idx);
                this.setRowDetailScore(idx);
                ++idx;
            }
        }
        this.getView().updateView("entryentity");
    }

    private void checkCanAutoScore(DynamicObjectCollection entryEntity) {
        for (DynamicObject entry : entryEntity) {
            DynamicObject finOrg = entry.getDynamicObject("finorg");
            if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
                return;
            }
            DynamicObject archiveBill = EvalTaskAutoScoreHelper.getAutoScoreBill((String)"tmbrm_finorg_archives", (long)finOrg.getLong("id"), (String)"id");
            if (!EmptyUtil.isEmpty((DynamicObject)archiveBill)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230%s\u7684\u91d1\u878d\u673a\u6784\u6863\u6848\uff0c\u65e0\u6cd5\u8ba1\u7b97\u5f97\u5206\u3002", (String)"EvaluationTaskEdit_0", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]), finOrg.getString("name")));
        }
    }

    private BigDecimal getAutoScore(DynamicObject autoScoreScheme, DynamicObject entry) {
        DynamicObject finOrg = entry.getDynamicObject("finorg");
        BigDecimal score = new BigDecimal("0.0");
        if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
            return score;
        }
        String scoreWay = autoScoreScheme.getString("scoreway");
        if (ScoreWayEnum.CONDITION.getValue().equals(scoreWay)) {
            DynamicObject valueBill = autoScoreScheme.getDynamicObject("valuebill");
            String entityKey = valueBill.getString("number");
            String prop = autoScoreScheme.getString("valuefield");
            DynamicObject archiveBill = EvalTaskAutoScoreHelper.getAutoScoreBill((String)entityKey, (long)finOrg.getLong("id"), (String)prop);
            if (EmptyUtil.isNoEmpty((DynamicObject)archiveBill)) {
                DynamicObjectCollection conditionEntry = autoScoreScheme.getDynamicObjectCollection("conditionentry");
                score = EvalTaskAutoScoreHelper.getConditionValue((String)entityKey, (String)prop, (DynamicObjectCollection)conditionEntry, (DynamicObject)archiveBill);
            }
        } else {
            String autoScorePlugin = autoScoreScheme.getString("plugin");
            score = EvalTaskAutoScoreHelper.getAutoScoreByPlugin((String)autoScorePlugin, (Long)finOrg.getLong("id"), (Long)((DynamicObject)this.getModel().getValue("org")).getLong("id"), (DynamicObject)((DynamicObject)this.getModel().getValue("schedule")), (String)((String)this.getModel().getValue("finorgtype")));
        }
        return score;
    }

    private void refreshOrgList(Long proposalId) {
        DynamicObjectCollection itemList = EvalTaskHelper.getProposalItemEntry((Long)proposalId);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)itemList)) {
            return;
        }
        this.getPageCache().put(CACHE_ITEM_SIZE, String.valueOf(itemList.size()));
        EntryGrid control = (EntryGrid)this.getControl("entryentity");
        int len = itemList.size();
        Map itemMap = EvalTaskHelper.getEvalItemsByIds((DynamicObjectCollection)itemList);
        boolean hasAddItem = false;
        boolean hasSubItem = false;
        for (int i = 0; i < len; ++i) {
            String key = "item" + i;
            DynamicObject object = ((DynamicObject)itemList.get(i)).getDynamicObject("item");
            object = (DynamicObject)itemMap.get(object.getPkValue());
            this.getPageCache().put(key, object.getPkValue().toString());
            BigDecimal maxScore = object.getBigDecimal("maxscore");
            control.setColumnProperty(key, "header", (Object)new LocaleString(object.getString("name")));
            HashMap<String, Object> editMap = new HashMap<String, Object>(16);
            editMap.put("min", BigDecimal.ZERO);
            editMap.put("minm", "[");
            editMap.put("max", maxScore);
            editMap.put("maxm", "]");
            editMap.put("mi", false);
            editMap.put("nt", "D");
            editMap.put("pc", 23);
            editMap.put("roundMethod", "1");
            editMap.put("sc", 2);
            editMap.put("type", "number");
            editMap.put("vas", "underline");
            editMap.put("zs", true);
            control.setColumnProperty(key, "editor", editMap);
            hasAddItem = "extraadd".equals(object.getString("extraaddorsub")) || hasAddItem;
            hasSubItem = "extrasub".equals(object.getString("extraaddorsub")) || hasSubItem;
        }
        control.setColumnProperty("finorg", "isFixed", (Object)Boolean.TRUE);
        this.getView().setVisible(Boolean.FALSE, (String[])IntStream.range(len, 50).boxed().map(t -> "item" + t).toArray(String[]::new));
        if (!hasAddItem) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"plusinfo"});
        }
        if (!hasSubItem) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"minusinfo"});
        }
    }

    private void calculateScore(int idx) {
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(idx);
        DynamicObject schedule = (DynamicObject)this.getModel().getValue("schedule");
        DynamicObject proposal = TmcDataServiceHelper.loadSingleFromCache((Object)schedule.getDynamicObject("evalproposal").getLong("id"), (String)"tmbrm_evaluateproposal");
        DynamicObjectCollection itemList = proposal.getDynamicObjectCollection("entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)itemList)) {
            return;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (int i = 0; i < itemList.size(); ++i) {
            DynamicObject item = (DynamicObject)itemList.get(i);
            boolean isdeduct = item.getDynamicObject("item").getBoolean("isdeduct");
            BigDecimal sign = isdeduct ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
            total = total.add(sign.multiply(row.getBigDecimal("item" + i)).multiply(item.getBigDecimal("weight")).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        }
        this.getModel().setValue("totalscore", (Object)total, idx);
    }

    public void cellClick(CellClickEvent event) {
        this.processItemClick(event);
    }

    public void cellDoubleClick(CellClickEvent event) {
        this.processItemClick(event);
    }

    private void processItemClick(CellClickEvent event) {
        String pk;
        DynamicObject item;
        String fieldKey = event.getFieldKey();
        if (fieldKey.startsWith("item") && !EmptyUtil.isEmpty((DynamicObject)(item = TmcDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(pk = this.getPageCache().get(fieldKey)), (String)"tmbrm_evaluationitem")))) {
            this.refreshAssistant(item.getLong("id"), event.getRow());
            SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
            splitContainer.hidePanel(SplitDirection.right, false);
        }
    }

    private void refreshAssistant(Long itemId, int row) {
        IDataModel model = this.getModel();
        DynamicObjectCollection finOrgList = model.getEntryEntity("entryentity");
        String finOrgs = finOrgList.stream().map(t -> t.getDynamicObject("finorg")).filter(t -> !EmptyUtil.isEmpty((DynamicObject)t)).map(t -> String.valueOf(t.getLong("id"))).collect(Collectors.joining(","));
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setFormId("tmbrm_evaluate_assistance");
        parameter.getOpenStyle().setTargetKey("assistantpanelap");
        parameter.setCustomParam("org", ((DynamicObject)model.getValue("org")).getPkValue());
        parameter.setCustomParam("schedule", ((DynamicObject)model.getValue("schedule")).getPkValue());
        parameter.setCustomParam("finorgtype", model.getValue("finorgtype"));
        parameter.setCustomParam("finorg", (Object)finOrgs);
        parameter.setCustomParam("evaluateitem", (Object)itemId);
        parameter.setCustomParam("row", (Object)String.valueOf(row));
        this.getView().showForm(parameter);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tb_syncfinorg".equals(itemKey)) {
            this.syncFinOrg();
        }
    }

    private void syncFinOrg() {
        List<QFilter> finOrgFilter = this.getFinOrgFilter(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
        String finOrgType = (String)this.getModel().getValue("finorgtype");
        Map resMap = TmcDataServiceHelper.loadFromCache((String)finOrgType, (QFilter[])finOrgFilter.toArray(new QFilter[0]));
        if (null != resMap && !EmptyUtil.isEmpty(resMap.values())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            DynamicObject lastObj = (DynamicObject)entryEntity.get(entryEntity.size() - 1);
            if (EmptyUtil.isEmpty((DynamicObject)lastObj.getDynamicObject("finorg"))) {
                entryEntity.remove(entryEntity.size() - 1);
            }
            for (DynamicObject finOrg : resMap.values()) {
                DynamicObject row = entryEntity.addNew();
                row.set("finorg", (Object)finOrg);
            }
            this.getView().updateView("entryentity");
        }
    }
}

