/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.model;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.ScoreWayEnum;

public class AutoScoreProposalEdit
extends AbstractFormPlugin {
    private static final String OP_NEWENTRY = "newentry";
    private static final String OP_DELETEENTRY = "deleteentry";
    private static final String CALLBACK_CONDITION_BD = "callback_condition_bd";
    private static final Map<String, String> valueFieldMap = new HashMap<String, String>(16);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setValueField();
        this.registerMustInput();
        this.setConditionEntry(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IFormView view = this.getView();
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "scoreway": {
                String newScoreWay = (String)newValue;
                if (ScoreWayEnum.PLUGIN.getValue().equals(newScoreWay)) {
                    TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)true, (String[])new String[]{"plugin"});
                    TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"valuebill", "valuefield"});
                    this.getModel().deleteEntryData("conditionentry");
                }
                if (!ScoreWayEnum.CONDITION.getValue().equals(newScoreWay)) break;
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"plugin"});
                TmcViewInputHelper.registerVisibleStatus((IFormView)view, (String[])new String[]{OP_NEWENTRY, OP_DELETEENTRY}, (boolean)false);
                TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)true, (String[])new String[]{"valuefield", "valuebill"});
                break;
            }
            case "valuebill": {
                this.setValueField();
                break;
            }
            case "valuefield": {
                this.setConditionEntry(true);
                this.setValueFieldShow((String)newValue);
                break;
            }
            case "plugin": {
                this.checkPlugin((String)newValue);
                break;
            }
        }
    }

    private void setValueFieldShow(String newValue) {
        this.getModel().setValue("valuefield_show", (Object)valueFieldMap.get(newValue));
    }

    private void checkPlugin(String plugin) {
        try {
            Class pluginClass = TypesContainer.getOrRegister((String)plugin.trim());
            pluginClass.newInstance();
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u672a\u90e8\u7f72\u3002", (String)"AutoScoreProposalEdit_2", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setValueField() {
        DynamicObject valueBill = this.getModel().getDataEntity().getDynamicObject("valuebill");
        if (valueBill != null) {
            String entityName = valueBill.getString("number");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            Map allFields = dataEntityType.getAllFields();
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("valuefield");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(allFields.size());
            for (Map.Entry propEntry : allFields.entrySet()) {
                IDataEntityProperty entityProperty = (IDataEntityProperty)propEntry.getValue();
                String fieldKey = (String)propEntry.getKey();
                String localeValue = entityProperty.getDisplayName() + "(" + fieldKey + ")";
                valueFieldMap.put(fieldKey, localeValue);
                ComboItem comboItem = new ComboItem(new LocaleString(localeValue), fieldKey);
                comboItems.add(comboItem);
            }
            comboEdit.setComboItems(comboItems);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"conditionbd"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "conditionbd".equals(((TextEdit)source).getKey())) {
            EntryGrid conditionEntry = (EntryGrid)this.getControl("conditionentry");
            int row = conditionEntry.getSelectRows()[0];
            String valueField = (String)this.getModel().getValue("valuefield");
            DynamicObject valueBill = (DynamicObject)this.getModel().getValue("valuebill");
            String entityKey = valueBill.getString("number");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityKey);
            BasedataProp basedataProp = (BasedataProp)entityType.findProperty(valueField);
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)basedataProp.getBaseEntityId(), (boolean)Boolean.FALSE);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_CONDITION_BD));
            this.getPageCache().put("row", String.valueOf(row));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRowCollection;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (CALLBACK_CONDITION_BD.equals(actionId) && EmptyUtil.isNoEmpty((Object)(selectedRowCollection = (ListSelectedRowCollection)event.getReturnData()))) {
            ListSelectedRow listSelectedRow = selectedRowCollection.get(0);
            int row = Integer.parseInt(this.getPageCache().get("row"));
            this.getModel().setValue("conditionbd", (Object)listSelectedRow.getName(), row);
            this.getModel().setValue("conditionbdid", listSelectedRow.getPrimaryKeyValue(), row);
        }
    }

    private void registerMustInput() {
        String scoreWay = (String)this.getModel().getValue("scoreway");
        boolean isCondition = ScoreWayEnum.CONDITION.getValue().equals(scoreWay);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isCondition, (String[])new String[]{"valuefield", "valuebill"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!isCondition ? 1 : 0) != 0, (String[])new String[]{"plugin"});
    }

    private void setConditionEntry(boolean propChanged) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        IFormView view = this.getView();
        DynamicObject bill = model.getDataEntity().getDynamicObject("valuebill");
        String fieldKey = (String)model.getValue("valuefield");
        if (bill != null && EmptyUtil.isNoEmpty((String)fieldKey)) {
            String entityKey = bill.getString("number");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityKey);
            IDataEntityProperty property = entityType.findProperty(fieldKey);
            EntryGrid conditionEntry = (EntryGrid)this.getControl("conditionentry");
            conditionEntry.setColumnProperty("conditiontext", "header", (Object)property.getDisplayName());
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            TextEdit textEdit = (TextEdit)this.getControl("conditiontext");
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                TmcViewInputHelper.registerShowingStatus((IFormView)view, (String[])new String[]{"conditiontext"});
                if (propChanged) {
                    model.deleteEntryData("conditionentry");
                    List items = comboProp.getComboItems();
                    int rowIndex = 0;
                    for (ValueMapItem item : items) {
                        tvs.set("conditionvalue", (Object)item.getValue(), rowIndex);
                        tvs.set("conditiontext", (Object)item.getName(), rowIndex);
                        ++rowIndex;
                    }
                    model.batchCreateNewEntryRow("conditionentry", tvs);
                }
                TmcViewInputHelper.registerVisibleStatus((IFormView)view, (String[])new String[]{"conditionbd", OP_NEWENTRY, OP_DELETEENTRY}, (boolean)false);
                textEdit.setEnable("", false, -1);
            } else if (property instanceof BooleanProp) {
                view.setVisible(Boolean.valueOf(true), new String[]{"conditiontext"});
                if (propChanged) {
                    model.deleteEntryData("conditionentry");
                    tvs.set("conditionvalue", (Object)"1", 0);
                    tvs.set("conditionvalue", (Object)"0", 1);
                    tvs.set("conditiontext", (Object)new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"AutoScoreProposalEdit_0", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0])), 0);
                    tvs.set("conditiontext", (Object)new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"AutoScoreProposalEdit_1", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0])), 1);
                    model.batchCreateNewEntryRow("conditionentry", tvs);
                }
                TmcViewInputHelper.registerVisibleStatus((IFormView)view, (String[])new String[]{"conditionbd", OP_NEWENTRY, OP_DELETEENTRY}, (boolean)false);
                textEdit.setEnable("", false, -1);
            } else if (property instanceof BasedataProp) {
                if (propChanged) {
                    model.deleteEntryData("conditionentry");
                }
                conditionEntry.setColumnProperty("conditionbd", "header", (Object)property.getDisplayName());
                TmcViewInputHelper.registerShowingStatus((IFormView)view, (String[])new String[]{"conditionbd", OP_NEWENTRY, OP_DELETEENTRY});
                TmcViewInputHelper.registerVisibleStatus((IFormView)view, (String[])new String[]{"conditiontext"}, (boolean)false);
            } else {
                if (propChanged) {
                    model.deleteEntryData("conditionentry");
                }
                textEdit.setEnable("", true, -1);
                TmcViewInputHelper.registerVisibleStatus((IFormView)view, (String[])new String[]{"conditionbd"}, (boolean)false);
                TmcViewInputHelper.registerShowingStatus((IFormView)view, (String[])new String[]{"conditiontext", OP_NEWENTRY, OP_DELETEENTRY});
            }
        }
    }
}

