/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.model;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.EvaluationNatureEnum;
import kd.tmc.tmbrm.common.util.BigDecimalUtils;

public class EvaluationItemEdit
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        String itemClassifyId;
        super.afterCreateNewData(e);
        if (null != this.getView().getParentView() && EmptyUtil.isNoEmpty((String)(itemClassifyId = this.getView().getParentView().getPageCache().get("itemclassify")))) {
            Long classifyId = Long.valueOf(itemClassifyId);
            this.getModel().setValue("itemclassify", (Object)classifyId);
            DynamicObject itemClassify = BusinessDataServiceHelper.loadSingleFromCache((Object)classifyId, (String)"tmbrm_evaluationitemclass");
            this.setParentClassifyValue(itemClassify);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        int rowIndex;
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("ruleentry".equals(entryName) && (rowIndex = (rowDataEntities = e.getRowDataEntities())[0].getRowIndex()) > 0) {
            this.setScoreToValue(rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (proName) {
            case "itemclassify": {
                DynamicObject itemClassify = (DynamicObject)changeData.getNewValue();
                this.setParentClassifyValue(itemClassify);
                break;
            }
            case "scorefrom": {
                int rowIndex = changeData.getRowIndex();
                this.setScoreToValue(rowIndex + 1);
                break;
            }
            case "score": {
                this.setMaxScoreValue();
                break;
            }
            case "nature": {
                String nature = (String)changeData.getNewValue();
                this.clearScoreFromAndToValues(nature);
                break;
            }
            case "evamethod": {
                String evaMethod = (String)changeData.getNewValue();
                this.setMustInputAutoScoreScheme(evaMethod);
                break;
            }
        }
    }

    private void setMustInputAutoScoreScheme(String evaMethod) {
        if ("auto".equals(evaMethod)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"autoscorescheme"});
        } else {
            this.getModel().setValue("autoscorescheme", null);
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"autoscorescheme"});
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int rowIndex = e.getRowIndex();
        Object value = e.getValue();
        switch (key) {
            case "scorefrom": {
                if (this.checkScoreValue(rowIndex, value, false)) break;
                e.setCancel(true);
                this.getView().updateView(key, rowIndex);
                break;
            }
            case "scoreto": {
                if (this.checkScoreValue(rowIndex, value, true)) break;
                e.setCancel(true);
                this.getView().updateView(key, rowIndex);
                break;
            }
        }
    }

    private boolean checkScoreValue(int rowIndex, Object value, boolean fromProp) {
        boolean compareRes;
        BigDecimal changeValue;
        BigDecimal propValue = (BigDecimal)this.getModel().getValue(fromProp ? "scorefrom" : "scoreto", rowIndex);
        BigDecimal bigDecimal = changeValue = null == value ? Constants.ZERO : new BigDecimal(value.toString());
        if (changeValue.compareTo(Constants.ZERO) < 0) {
            this.getView().showErrorNotification(fromProp ? ResManager.loadKDString((String)"\u201d\u6570\u503c\u81f3\uff08\u5c0f\u4e8e\uff09\u201c\u5e94\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"EvaluationItemEdit_03", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u6570\u503c\u4ece\uff08\u5927\u4e8e\u7b49\u4e8e\uff09\u201d\u5e94\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"EvaluationItemEdit_02", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean bl = fromProp ? changeValue.compareTo(propValue) < 0 : (compareRes = propValue.compareTo(changeValue) < 0);
        if (compareRes) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u8bc4\u5206\u7ec6\u5219\u4e2d\uff0c\u201c\u6570\u503c\u4ece\uff08\u5927\u4e8e\u7b49\u4e8e\uff09\u201d\u5e94\u8be5 \u2264 \u201c\u6570\u503c\u81f3\uff08\u5c0f\u4e8e\uff09\u201d\u3002", (String)"EvaluationItemEdit_00", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void clearScoreFromAndToValues(String nature) {
        Object[] dataEntitys;
        if (EvaluationNatureEnum.QUALITY.getValue().equals(nature) && EmptyUtil.isNoEmpty((Object[])(dataEntitys = this.getEntryDataEntity()))) {
            for (int i = 0; i < dataEntitys.length; ++i) {
                this.getModel().setValue("scorefrom", null);
                this.getModel().setValue("scoreto", null);
            }
        }
    }

    private void setMaxScoreValue() {
        DynamicObject[] dataEntitys = this.getEntryDataEntity();
        BigDecimal maxScore = this.getMaxScore(dataEntitys);
        this.getModel().setValue("maxscore", (Object)maxScore);
    }

    private BigDecimal getMaxScore(DynamicObject[] dataEntitys) {
        List scores = Arrays.stream(dataEntitys).map(o -> o.getBigDecimal("score")).collect(Collectors.toList());
        return BigDecimalUtils.max(scores);
    }

    private void setScoreToValue(int rowIndex) {
        BigDecimal lastScoreFrom = (BigDecimal)this.getModel().getValue("scorefrom", rowIndex - 1);
        EntryData ruleData = this.getEntryData();
        int endIndex = ruleData.getEndIndex();
        if (endIndex > rowIndex) {
            this.getModel().setValue("scoreto", (Object)lastScoreFrom, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"scoreto"});
        }
    }

    private void setParentClassifyValue(DynamicObject itemClassify) {
        if (EmptyUtil.isEmpty((DynamicObject)itemClassify)) {
            this.getModel().setValue("parentclassify", null);
        } else {
            DynamicObject parentClassify = itemClassify.getDynamicObject("parent");
            this.getModel().setValue("parentclassify", (Object)parentClassify.getString("name"));
        }
    }

    private DynamicObject[] getEntryDataEntity() {
        EntryData entryData = this.getEntryData();
        return entryData.getDataEntitys();
    }

    private EntryData getEntryData() {
        EntryGrid entry = (EntryGrid)this.getControl("ruleentry");
        return entry.getEntryData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("newentry_ref".equals(operateKey) && 20 <= (entryEntity = this.getModel().getEntryEntity("refentry")).size()) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u53c2\u8003\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u3002", (String)"EvaluationItemEdit_01", (String)"tmc-tmbrm-formplugin", (Object[])new Object[]{20}));
        }
    }
}

