/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.property.TmcTreeNodeProp;
import kd.tmc.fbp.common.property.TmcTreeNodeRefProp;
import kd.tmc.fbp.common.property.TmcTreeNodeTypeProp;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.tree.AbstractTmcTreeList;

public class EvaluationItemTreeList
extends AbstractTmcTreeList {
    protected static final TmcTreeNodeTypeProp NODE_ROOT = new TmcTreeNodeTypeProp("name", TmcTreeNodeTypeProp.ROOT, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    protected static final TmcTreeNodeTypeProp NODE_CHILD = new TmcTreeNodeTypeProp("child", NODE_ROOT, TmcTreeNodeTypeProp.LeafMode.LEAF);

    protected List<TmcTreeNodeTypeProp> getTreeNodeTypeList() {
        return Arrays.asList(NODE_ROOT, NODE_CHILD);
    }

    protected List<TmcTreeNodeRefProp> loadTreeNodeList(TmcTreeNodeProp currNode) {
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        List<TmcTreeNodeRefProp> nodeList = null;
        if (nodeType.equals((Object)TmcTreeNodeTypeProp.ROOT)) {
            nodeList = this.loadNodeList(1, NODE_ROOT, 0L);
        } else if (nodeType.equals((Object)NODE_ROOT)) {
            Object nodeId = currNode.getRefEntityPkValue();
            nodeList = this.loadNodeList(2, NODE_CHILD, Long.valueOf(nodeId.toString()));
        }
        return nodeList;
    }

    protected QFilter getBillListFilter(TmcTreeNodeProp currNode) {
        QFilter filter;
        Object refId = currNode.getRefEntityPkValue();
        if (EmptyUtil.isNoEmpty((Object)refId)) {
            filter = new QFilter("itemclassify.id", "=", (Object)Long.valueOf(refId.toString()));
        } else {
            DynamicObjectCollection classifys = QueryServiceHelper.query((String)"tmbrm_evaluationitemclass", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)classifys)) {
                return new QFilter("itemclassify.id", "=", (Object)9999999);
            }
            List classifyIds = classifys.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            filter = new QFilter("itemclassify.id", "in", classifyIds);
        }
        return filter;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        TreeNode currNode = this.getNodeById(e.getNodeId());
        TmcTreeNodeProp treeNodeProp = new TmcTreeNodeProp(currNode, this.getTreeModel().getRoot(), this.getTreeNodeTypeList());
        TmcTreeNodeTypeProp nodeType = treeNodeProp.getNodeType();
        if (nodeType.equals((Object)NODE_CHILD)) {
            Object refId = treeNodeProp.getRefEntityPkValue();
            this.getPageCache().put("itemclassify", refId.toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String oprateKey = op.getOperateKey();
        if ("new".equals(oprateKey) && !this.checkNodeSelected()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "itemclassify": {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setBillFormId("tmbrm_evaluationitemclass");
                parameter.setFormId("bos_templatetreelist");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "refresh": {
                TreeNode root = this.getNodeById(this.getTreeModel().getRoot().getId());
                root.setChildren(null);
                this.getTreeModel().setCurrentNodeId((Object)root.getId());
                this.getTreeListView().refresh();
                break;
            }
        }
    }

    private boolean checkNodeSelected() {
        TmcTreeNodeProp currNode = this.getCurrentNodeModel();
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        if (!nodeType.equals((Object)NODE_CHILD)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e8c\u7ea7\u8bc4\u4ef7\u9879\u76ee\u5206\u7c7b\uff0c\u518d\u65b0\u589e\u8bc4\u4ef7\u9879\u76ee\u3002", (String)"EvaluationItemTreeList_00", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<TmcTreeNodeRefProp> loadNodeList(int level, TmcTreeNodeTypeProp nodeType, Long parentNodeId) {
        Map itemClassifys = TmcDataServiceHelper.loadFromCache((String)"tmbrm_evaluationitemclass", (String)"id,number,name,level", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("level", "=", (Object)level), new QFilter("parent.id", "=", (Object)parentNodeId)});
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(itemClassifys.size());
        for (DynamicObject itemClassify : itemClassifys.values()) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            node.setNodeName(itemClassify.getString("name"));
            node.setNodeType(nodeType);
            node.setRefEntityPkValue((Object)itemClassify.getString("id"));
            nodeList.add(node);
        }
        return nodeList;
    }
}

