/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import org.apache.commons.lang3.StringUtils;

public class EvaluationProposalEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit item = (BasedataEdit)this.getControl("item");
        item.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"weight", "item"})) {
            this.calculateTotalScore();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("newentry".equals(operateKey) && 50 <= (entryEntity = this.getModel().getEntryEntity("entryentity")).size()) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u4ef7\u9879\u76ee\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u3002", (String)"EvaluationProposalEdit_0", (String)"tmc-tmbrm-formplugin", (Object[])new Object[]{50}));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        if (Objects.nonNull(args.getOperationResult()) && args.getOperationResult().isSuccess() && "deleteentry".equals(key = args.getOperateKey())) {
            this.calculateTotalScore();
        }
    }

    private void calculateTotalScore() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
            entryEntity.stream().filter(t -> EmptyUtil.isNoEmpty((DynamicObject)t.getDynamicObject("item")) && EmptyUtil.isNoEmpty((BigDecimal)t.getBigDecimal("weight"))).map(t -> t.getDynamicObject("item").getBigDecimal("maxscore").multiply(t.getBigDecimal("weight")).multiply(t.getDynamicObject("item").getBoolean("isdeduct") ? BigDecimal.valueOf(-1L) : BigDecimal.ONE).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP)).reduce(BigDecimal::add).ifPresent(t -> this.getModel().setValue("totalscore", t));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("item".equals(key)) {
            this.evaluationItemF7(evt);
        }
    }

    private void evaluationItemF7(BeforeF7SelectEvent evt) {
        ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
        List hasIds = this.getModel().getEntryEntity("entryentity").stream().filter(t -> Objects.nonNull(t.getDynamicObject("item"))).map(t -> t.getDynamicObject("item").getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(hasIds)) {
            parameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", hasIds));
        }
        parameter.setMultiSelect(true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "itemF7Callback"));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if ("itemF7Callback".equals(event.getActionId())) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
            if (EmptyUtil.isEmpty((Collection)returnData)) {
                return;
            }
            List keys = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
            int entrySize = entryList.size();
            if (entrySize + keys.size() - 1 > 50) {
                keys = keys.subList(0, Math.min(50 - entrySize + 1, 50));
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u4ef7\u9879\u76ee\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u3002", (String)"EvaluationProposalEdit_0", (String)"tmc-tmbrm-formplugin", (Object[])new Object[]{50}));
            }
            Map itemMap = TmcDataServiceHelper.loadFromCache((Object[])keys.toArray(), (String)"tmbrm_evaluationitem");
            IDataModel model = this.getModel();
            int currentRowIndex = model.getEntryCurrentRowIndex("entryentity");
            model.setValue("item", itemMap.get(keys.get(0)), currentRowIndex);
            if (keys.size() > 1) {
                model.batchCreateNewEntryRow("entryentity", keys.size() - 1);
                for (int i = 1; i < keys.size(); ++i) {
                    model.setValue("item", itemMap.get(keys.get(i)), entrySize);
                    ++entrySize;
                }
            }
        }
    }
}

