/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.action;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tmbrm.common.enums.QueryDateEnum;

public abstract class AbstractAnalysisQueryDataAction {
    protected List<Long> allOrgIds;
    protected String finOrgType;
    protected String finTypeNum;
    protected String dataRange;
    protected List<Long> finOrgIds;
    protected Date queryDate;
    protected Date queryDateStart;
    protected Date queryDateEnd;
    protected Map<String, Object> paramMap;
    protected String statDim;
    protected boolean onlyFinOrg;
    public String[] groupFieldsArr = new String[]{"finorgname", "bankid", "orgid", "orgname"};
    public String[] finOrgGroupFields = new String[]{"finorgname", "bankid"};

    public AbstractAnalysisQueryDataAction(Map<String, Object> paramMap, List<Long> orgIds) {
        this.paramMap = paramMap;
        this.allOrgIds = orgIds;
        this.finOrgType = (String)paramMap.get("filter_finorgtype");
        this.finTypeNum = ((DynamicObject)paramMap.get("filter_fintype")).getString("number");
        this.dataRange = (String)paramMap.get("filter_datarange");
        this.finOrgIds = (List)paramMap.get("filter_finorgid");
        this.statDim = (String)paramMap.get("filter_statdim");
        this.onlyFinOrg = "finorg".equals(this.statDim);
        this.initQueryDate(paramMap);
    }

    protected String[] getGroupFields() {
        if (!this.onlyFinOrg) {
            return this.groupFieldsArr;
        }
        return this.finOrgGroupFields;
    }

    private void initQueryDate(Map<String, Object> paramMap) {
        String queryDateType = (String)paramMap.get("filter_querydate");
        QueryDateEnum queryDateEnum = QueryDateEnum.getEnumByValue((String)queryDateType);
        Date currDate = new Date();
        switch (queryDateEnum) {
            case CURRYEAR: {
                this.queryDate = currDate;
                this.queryDateStart = DateUtils.getDataFormat((Date)DateUtils.getFirstDayOfCurYear(), (boolean)true);
                this.queryDateEnd = DateUtils.getDataFormat((Date)DateUtils.getLastDayOfCurYear(), (boolean)false);
                break;
            }
            case LASTYEAR: {
                this.queryDate = DateUtils.getDataFormat((Date)DateUtils.getLastYearDate((Date)DateUtils.getLastYear((Date)currDate, (int)1)), (boolean)false);
                this.queryDateStart = DateUtils.getDataFormat((Date)DateUtils.getFirstYearDate((Date)DateUtils.getLastYear((Date)currDate, (int)1)), (boolean)true);
                this.queryDateEnd = this.queryDate;
                break;
            }
            case CUSTOM: {
                Date filter_queryDateEnd = DateUtils.getDataFormat((Date)((Date)paramMap.get("filter_querydateend")), (boolean)false);
                this.queryDate = filter_queryDateEnd.compareTo(currDate) > 0 ? currDate : filter_queryDateEnd;
                this.queryDateStart = DateUtils.getDataFormat((Date)((Date)paramMap.get("filter_querydatestart")), (boolean)true);
                this.queryDateEnd = filter_queryDateEnd;
            }
        }
    }

    protected abstract QFilter getQFilter();

    public abstract DataSet queryData();
}

