/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.action;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tmbrm.report.action.AbstractAnalysisQueryDataAction;

public class BankAcctQueryDataAction
extends AbstractAnalysisQueryDataAction {
    public static final String ACTION_KEY = "bankacct";
    public static final String BANKACCOUNTCNT = "bankaccountcnt";
    public static final String BANKINTERFACECNT = "bankinterfacecnt";
    private final DataSet orginalDs = this.queryData();

    public BankAcctQueryDataAction(Map<String, Object> paramMap, List<Long> orgIds) {
        super(paramMap, orgIds);
    }

    @Override
    protected QFilter getQFilter() {
        QFilter qFilter = new QFilter("openorg.id", "in", (Object)this.allOrgIds);
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            qFilter.and("bank.bank_cate.id", "in", (Object)this.finOrgIds);
        } else {
            qFilter.and("bank.id", "in", (Object)this.finOrgIds);
        }
        qFilter.and("opendate", "<=", (Object)DateUtils.getDataFormat((Date)this.queryDate, (boolean)false));
        qFilter.and("isvirtual", "=", (Object)"0");
        return qFilter;
    }

    @Override
    public final DataSet queryData() {
        String selectFields = "id, openorg.id orgid, openorg.name as orgname,case when issetbankinterface = '1' then 'bi_true'  else 'bi_false' end as bankinterface, case when bank.country.twocountrycode = 'CN' OR bank.country.threecountrycode = 'CHN' OR bank.country = 0 OR ((bank.country.twocountrycode = NULL OR TRIM(bank.country.twocountrycode) = '') AND (bank.country.threecountrycode = NULL OR TRIM(bank.country.threecountrycode) = '')) then 'domestic' else 'overseas' end as areas,case when finorgtype = '0' then 'bank' else 'fincom' end as finorgtype,case when finorgtype = '0' then bank.bank_cate.id else bank.id end as bankid,case when finorgtype = '0' then bank.bank_cate.name else bank.name end as finorgname";
        return this.queryDataByFields(selectFields);
    }

    private DataSet queryDataByFields(String selectFields) {
        QFilter closeDateFilter = QFilter.isNull((String)"closedate").or("closedate", ">", (Object)DateUtils.getDataFormat((Date)this.queryDate, (boolean)true));
        DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.tmc.tmbrm.report.handle.BankAcctQueryDataHandle.queryData", (String)"bd_accountbanks", (String)selectFields, (QFilter[])new QFilter[]{this.getQFilter(), closeDateFilter}, null);
        if (!"all".equals(this.dataRange)) {
            ds = ds.filter("areas='" + this.dataRange + "'");
        }
        return ds;
    }

    public DataSet queryBankCntDs(DataSet source) {
        DataSet bankCntDs = this.orginalDs.copy().groupBy(this.getGroupFields()).count(BANKACCOUNTCNT).finish();
        if (null != source) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            bankCntDs = this.onlyFinOrg ? source.copy().leftJoin(bankCntDs).on("bankid", "bankid").select(fieldNames, new String[]{BANKACCOUNTCNT}).finish() : source.copy().leftJoin(bankCntDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{BANKACCOUNTCNT}).finish();
        }
        return bankCntDs;
    }

    public DataSet queryBankInterfaceCntDs(DataSet source) {
        DataSet bankInterfaceCntDs = this.orginalDs.filter("bankinterface='bi_true'").select(this.getGroupFields()).groupBy(this.getGroupFields()).count(BANKINTERFACECNT).finish();
        if (null != source) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            bankInterfaceCntDs = this.onlyFinOrg ? source.copy().leftJoin(bankInterfaceCntDs).on("bankid", "bankid").select(fieldNames, new String[]{BANKINTERFACECNT}).finish() : source.copy().leftJoin(bankInterfaceCntDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{BANKINTERFACECNT}).finish();
        }
        return bankInterfaceCntDs;
    }
}

