/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tmbrm.common.helper.DecisionCommonHelper;
import kd.tmc.tmbrm.common.helper.TmbrmAmountHelper;
import kd.tmc.tmbrm.report.action.AbstractAnalysisQueryDataAction;

public class BondQueryDataAction
extends AbstractAnalysisQueryDataAction {
    public static final String ACTION_KEY = "bond";
    public static final String INVESTAMOUNT = "investamount";
    public static final String UNDERWRITEAMOUNT = "underwriteamount";
    private DataSet orginalDs = this.queryData();

    public BondQueryDataAction(Map<String, Object> paramMap, List<Long> orgIds) {
        super(paramMap, orgIds);
    }

    @Override
    protected QFilter getQFilter() {
        QFilter qFilter = new QFilter("org.id", "in", (Object)this.allOrgIds);
        if (!"all".equals(this.dataRange)) {
            if ("domestic".equals(this.dataRange)) {
                qFilter.and("region", "=", (Object)"R1");
            } else {
                qFilter.and("region", "in", Arrays.asList("R2", "R3"));
            }
        }
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)this.queryDateStart, (boolean)true));
        qFilter.and("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)this.queryDateEnd, (boolean)false));
        return qFilter;
    }

    @Override
    public final DataSet queryData() {
        QFilter finOrgFilter = new QFilter("investor_entry.e_investortype", "in", Arrays.asList("bank", "finorg"));
        DataSet finOrgInfos = null;
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            QFilter qFilter = new QFilter("bank_cate.id", "in", (Object)this.finOrgIds);
            finOrgInfos = QueryServiceHelper.queryDataSet((String)"BondQueryDataAction.getfinorginfo", (String)"bd_finorginfo", (String)"id,bank_cate.id as bankcateid,bank_cate.name as bankcatename", (QFilter[])qFilter.toArray(), null);
            Set ids = DecisionCommonHelper.getFieldValues((DataSet)finOrgInfos.copy(), (String)"id", Long.class);
            finOrgFilter.and("investor_entry.e_investorid", "in", (Object)ids);
        } else {
            finOrgFilter.and("investor_entry.e_investorid", "in", (Object)this.finOrgIds);
        }
        String selectFields = "id,org.id as orgid,org.name as orgname,currency, investor_entry.e_investorname as finorgname, investor_entry.e_investorid as bankid, investor_entry.e_investamount as investamount";
        DataSet result = this.queryDataByFilter(selectFields, finOrgFilter);
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            result = result.leftJoin(finOrgInfos).on("bankid", "id").select(new String[]{"id", "orgid", "orgname", "currency", "bankcatename as finorgname", "bankcateid as bankid", INVESTAMOUNT}).finish();
        }
        return result;
    }

    private DataSet queryDataByFilter(String selectFields, QFilter finOrgFilter) {
        return QueryServiceHelper.queryDataSet((String)"kd.tmc.tmbrm.report.action.BondQueryDataAction.queryData", (String)"cfm_loanbill_bond", (String)selectFields, (QFilter[])new QFilter[]{this.getQFilter(), finOrgFilter}, null);
    }

    public DataSet queryInvestData(DataSet source) {
        this.orginalDs = TmbrmAmountHelper.dealAmountConvert((DataSet)this.orginalDs, (Map)this.paramMap, Collections.singletonList(INVESTAMOUNT), (String)"currency", (Date)new Date());
        DataSet investAmtDs = this.orginalDs.copy().groupBy(this.getGroupFields()).sum(INVESTAMOUNT).finish();
        if (source != null) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            investAmtDs = this.onlyFinOrg ? source.copy().leftJoin(investAmtDs).on("bankid", "bankid").select(fieldNames, new String[]{INVESTAMOUNT}).finish() : source.copy().leftJoin(investAmtDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{INVESTAMOUNT}).finish();
        }
        return investAmtDs;
    }

    public DataSet queryUnderWriteData(DataSet source) {
        QFilter finOrgFilter = null;
        finOrgFilter = FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum) ? new QFilter("underwriter_entry.e_underwriter.underwritername.bank_cate.id", "in", (Object)this.finOrgIds) : new QFilter("underwriter_entry.e_underwriter.underwritername.id", "in", (Object)this.finOrgIds);
        String selectFields = "id,org.id as orgid,org.name as orgname,currency, case when underwriter_entry.e_underwriter.underwritername.finorgtype.number = 'FI-014' then underwriter_entry.e_underwriter.underwritername.bank_cate.id else underwriter_entry.e_underwriter.underwritername.id end as bankid,case when underwriter_entry.e_underwriter.underwritername.finorgtype.number = 'FI-014' then underwriter_entry.e_underwriter.underwritername.bank_cate.name else underwriter_entry.e_underwriter.underwritername.name end as finorgname, underwriter_entry.e_underwriteamount as underwriteamount";
        DataSet underWriteOriginalDs = this.queryDataByFilter(selectFields, finOrgFilter);
        underWriteOriginalDs = TmbrmAmountHelper.dealAmountConvert((DataSet)underWriteOriginalDs, (Map)this.paramMap, Collections.singletonList(UNDERWRITEAMOUNT), (String)"currency", (Date)new Date());
        DataSet underWriteAmtDs = underWriteOriginalDs.copy().groupBy(this.getGroupFields()).sum(UNDERWRITEAMOUNT).finish();
        if (source != null) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            underWriteAmtDs = this.onlyFinOrg ? source.copy().leftJoin(underWriteAmtDs).on("bankid", "bankid").select(fieldNames, new String[]{UNDERWRITEAMOUNT}).finish() : source.copy().leftJoin(underWriteAmtDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{UNDERWRITEAMOUNT}).finish();
        }
        return underWriteAmtDs;
    }
}

