/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.action;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tmbrm.common.helper.DecisionCommonHelper;
import kd.tmc.tmbrm.common.helper.TmbrmAmountHelper;
import kd.tmc.tmbrm.report.action.AbstractAnalysisQueryDataAction;

public class CreditQueryDataAction
extends AbstractAnalysisQueryDataAction {
    public static final String ACTION_KEY = "credit";
    public static final String CREDITAMOUNT = "creditamount";
    public static final String USEAMOUNT = "useamount";
    private DataSet orginalDs = this.queryData();

    public CreditQueryDataAction(Map<String, Object> paramMap, List<Long> orgIds) {
        super(paramMap, orgIds);
    }

    @Override
    protected QFilter getQFilter() {
        QFilter qFilter = new QFilter("org.id", "in", (Object)this.allOrgIds);
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            qFilter.and("bank.bank_cate.id", "in", (Object)this.finOrgIds);
        } else {
            qFilter.and("bank.id", "in", (Object)this.finOrgIds);
        }
        qFilter.and("banktype", "=", (Object)"bd_finorginfo");
        qFilter.and("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        return qFilter;
    }

    @Override
    public final DataSet queryData() {
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)DateUtils.getDataFormat((Date)this.queryDate, (boolean)false));
        QFilter closeDateFilter = QFilter.isNull((String)"closedate").or("closedate", ">", (Object)DateUtils.getDataFormat((Date)this.queryDate, (boolean)true));
        dateFilter.and(closeDateFilter);
        String selectFields = "id, org.id orgid, org.name as orgname,case when bank.country.twocountrycode = 'CN' OR bank.country.threecountrycode = 'CHN' OR bank.country = 0 OR ((bank.country.twocountrycode = NULL OR TRIM(bank.country.twocountrycode) = '') AND (bank.country.threecountrycode = NULL OR TRIM(bank.country.threecountrycode) = '')) then 'domestic' else 'overseas' end as areas,totalamt,currency as currency,case when bank.finorgtype.number = 'FI-014' then bank.bank_cate.id else bank.id end as bankid,case when bank.finorgtype.number = 'FI-014' then bank.bank_cate.name else bank.name end as finorgname";
        DataSet ds = this.queryDataSetByParam(selectFields, dateFilter);
        if (!"all".equals(this.dataRange)) {
            ds = ds.filter("areas='" + this.dataRange + "'");
        }
        return ds;
    }

    private DataSet queryDataSetByParam(String selectFields, QFilter dateFilter) {
        return QueryServiceHelper.queryDataSet((String)"", (String)"cfm_creditlimit", (String)selectFields, (QFilter[])new QFilter[]{this.getQFilter(), dateFilter}, null);
    }

    public DataSet queryCreditLimit(DataSet source) {
        this.orginalDs = TmbrmAmountHelper.dealAmountConvert((DataSet)this.orginalDs, (Map)this.paramMap, Collections.singletonList("totalamt"), (String)"currency", (Date)new Date());
        DataSet creditAmtDs = this.orginalDs.groupBy(this.getGroupFields()).sum("totalamt", CREDITAMOUNT).finish();
        if (source != null) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            creditAmtDs = this.onlyFinOrg ? source.copy().leftJoin(creditAmtDs).on("bankid", "bankid").select(fieldNames, new String[]{CREDITAMOUNT}).finish() : source.copy().leftJoin(creditAmtDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{CREDITAMOUNT}).finish();
        }
        return creditAmtDs;
    }

    public DataSet queryCreditLimitUse(DataSet source) {
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)DateUtils.getDataFormat((Date)this.queryDateEnd, (boolean)false));
        dateFilter.and("startdate", ">=", (Object)DateUtils.getDataFormat((Date)this.queryDateStart, (boolean)true));
        Set ids = DecisionCommonHelper.getFieldValues((DataSet)this.orginalDs.copy(), (String)"id", Long.class);
        QFilter creditUseFilter = new QFilter("creditlimit", "in", (Object)ids).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        creditUseFilter.and(dateFilter);
        String selectFields = "id,creditlimit.id as creditlimitid,currency,amount as useamount";
        DataSet useDs = QueryServiceHelper.queryDataSet((String)"", (String)"cfm_credituse", (String)selectFields, (QFilter[])new QFilter[]{creditUseFilter}, null);
        useDs = TmbrmAmountHelper.dealAmountConvert((DataSet)useDs, (Map)this.paramMap, Collections.singletonList(USEAMOUNT), (String)"currency", (Date)new Date());
        useDs = this.orginalDs.leftJoin(useDs).on("id", "creditlimitid").select(this.getGroupFields(), new String[]{"currency", USEAMOUNT}).finish();
        DataSet useAmtDs = useDs.groupBy(this.getGroupFields()).sum(USEAMOUNT).finish();
        if (source != null) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            useAmtDs = this.onlyFinOrg ? source.copy().leftJoin(useAmtDs).on("bankid", "bankid").select(fieldNames, new String[]{USEAMOUNT}).finish() : source.copy().leftJoin(useAmtDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{USEAMOUNT}).finish();
        }
        return useAmtDs;
    }
}

