/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.InvestCommonHelper;
import kd.tmc.fbp.common.model.tda.invest.InvestRequest;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tmbrm.common.helper.DecisionCommonHelper;
import kd.tmc.tmbrm.common.helper.TmbrmAmountHelper;
import kd.tmc.tmbrm.report.action.AbstractAnalysisQueryDataAction;

public class DepositQueryDataAction
extends AbstractAnalysisQueryDataAction {
    public static final String ACTION_KEY = "deposit";
    public static final String DEMANDAMT = "demandamt";
    public static final String DEMANDAVGBALANCE = "demandavgbalance";
    public static final String NOTICE_AVGPRINCIPLE = "notice_avgprinciple";
    public static final String NOTICE_AVGEXPECTRATE = "t_notice_avgexpectrate";
    public static final String FIXED_AVGPRINCIPLE = "fixed_avgprinciple";
    public static final String FIXED_AVGEXPECTRATE = "t_fixed_avgexpectrate";
    public static final String STRUCTURE_AVGPRINCIPLE = "structure_avgprinciple";
    public static final String STRUCTURE_AVGEXPECTRATE = "t_structure_avgexpectrate";
    public static final String HUGE_AVGPRINCIPLE = "huge_avgprinciple";
    public static final String HUGE_AVGEXPECTRATE = "t_huge_avgexpectrate";
    public static final String FINANCE_AVGPRINCIPLE = "finance_avgprinciple";
    public static final String FINANCE_AVGEXPECTRATE = "t_finance_avgexpectrate";
    public static final String TOTAL_AVGPRINCIPLE = "total_avgprinciple";
    public static final String DEPOSITAVGRATE = "t_depositavgrate";
    private static final int MONTH_INTERVAL = 1;
    private static final List<String> INVESTTYPELIST = Arrays.asList(InvestTypeEnum.notice.getValue(), InvestTypeEnum.fixed.getValue(), InvestTypeEnum.structure.getValue(), InvestTypeEnum.huge.getValue());

    public DepositQueryDataAction(Map<String, Object> paramMap, List<Long> orgIds) {
        super(paramMap, orgIds);
    }

    @Override
    protected QFilter getQFilter() {
        QFilter qFilter = new QFilter("company.id", "in", (Object)this.allOrgIds);
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            qFilter.and("bank.bank_cate", "in", (Object)this.finOrgIds);
        } else {
            qFilter.and("bank.id", "in", (Object)this.finOrgIds);
        }
        return qFilter;
    }

    @Override
    public final DataSet queryData() {
        return null;
    }

    public DataSet queryDemandDepositData(DataSet source) {
        QFilter dateFilter = new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)this.queryDate, (boolean)false));
        dateFilter.and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)DateUtils.getLastMonth((Date)this.queryDate, (int)1), (boolean)true));
        String selectFields = "id,company.id orgid, company.name as orgname,case when bank.country.twocountrycode = 'CN' OR bank.country.threecountrycode = 'CHN' OR bank.country = 0 OR ((bank.country.twocountrycode = NULL OR TRIM(bank.country.twocountrycode) = '') AND (bank.country.threecountrycode = NULL OR TRIM(bank.country.threecountrycode) = '')) then 'domestic' else 'overseas' end as areas,case when bank.finorgtype.number = 'FI-014' then bank.bank_cate.id else bank.id end as bankid,case when bank.finorgtype.number = 'FI-014' then bank.bank_cate.name else bank.name end as finorgname,accountbank.id as accountbankid,amount,currency,bizdate";
        DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.tmc.tmbrm.report.handle.DepositQueryDataHandle.queryDemandDepositData", (String)"bei_bankbalance", (String)selectFields, (QFilter[])new QFilter[]{this.getQFilter(), dateFilter}, null);
        if (!"all".equals(this.dataRange)) {
            ds = ds.filter("areas='" + this.dataRange + "'");
        }
        String maxBizDateFields = "accountbank.id accountbankid,currency, bizdate";
        Set accountIds = DecisionCommonHelper.getFieldValues((DataSet)ds.copy(), (String)"accountbankid", Long.class);
        dateFilter.and(new QFilter("accountbank.id", "in", (Object)accountIds));
        DataSet maxBizDateDs = QueryServiceHelper.queryDataSet((String)"kd.tmc.tmbrm.report.handle.DepositQueryDataHandle.queryDemandDepositData2", (String)"bei_bankbalance", (String)maxBizDateFields, (QFilter[])new QFilter[]{this.getQFilter(), dateFilter}, null);
        maxBizDateDs = maxBizDateDs.groupBy(new String[]{"accountbankid", "currency"}).max("bizdate").finish();
        String[] fieldName = ds.getRowMeta().getFieldNames();
        DataSet demandDs = ds.join(maxBizDateDs).on("accountbankid", "accountbankid").on("currency", "currency").on("bizdate", "bizdate").select(fieldName).finish();
        demandDs = TmbrmAmountHelper.dealAmountConvert((DataSet)demandDs, (Map)this.paramMap, Collections.singletonList("amount"), (String)"currency", (Date)new Date());
        demandDs = demandDs.groupBy(this.getGroupFields()).sum("amount", DEMANDAMT).finish();
        if (source != null) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            demandDs = this.onlyFinOrg ? source.copy().leftJoin(demandDs).on("bankid", "bankid").select(fieldNames, new String[]{DEMANDAMT}).finish() : source.copy().leftJoin(demandDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{DEMANDAMT}).finish();
        }
        return demandDs;
    }

    private DataSet queryAvgDemandDepositBalance() {
        QFilter dateFilter = this.getDateRangeFilter();
        String selectFields = "id,company.id orgid, company.name as orgname,case when bank.country.twocountrycode = 'CN' OR bank.country.threecountrycode = 'CHN' OR bank.country = 0 OR ((bank.country.twocountrycode = NULL OR TRIM(bank.country.twocountrycode) = '') AND (bank.country.threecountrycode = NULL OR TRIM(bank.country.threecountrycode) = '')) then 'domestic' else 'overseas' end as areas,case when bank.finorgtype.number = 'FI-014' then bank.bank_cate.id else bank.id end as bankid,case when bank.finorgtype.number = 'FI-014' then bank.bank_cate.name else bank.name end as finorgname,accountbank.id accountbank,amount,currency";
        DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.tmc.tmbrm.report.handle.DepositQueryDataHandle.queryAvgDemandDepositBalance", (String)"bei_bankbalance", (String)selectFields, (QFilter[])new QFilter[]{this.getQFilter(), dateFilter}, null);
        if (!"all".equals(this.dataRange)) {
            ds = ds.filter("areas='" + this.dataRange + "'");
        }
        ds = TmbrmAmountHelper.dealAmountConvert((DataSet)ds, (Map)this.paramMap, Collections.singletonList("amount"), (String)"currency", (Date)new Date());
        return ds.groupBy(this.getGroupFields()).avg("amount", DEMANDAVGBALANCE).finish();
    }

    public DataSet queryInvestData(DataSet source) {
        DataSet avgDepositDs;
        DataSet investDs;
        InvestRequest request = new InvestRequest(DepositQueryDataAction.class.getName(), this.queryDate, Long.valueOf(0L), Long.valueOf(0L), this.getDateList(), this.getFinSubscribeFilter(), this.getDepositFilter());
        DataSet investDataSet = InvestCommonHelper.getAllViewData((InvestRequest)request).select(new String[]{"company as orgid", "companyname as orgname", "case when finorgtype='0' then bankcateid else bank end as bankid", "case when finorgtype='0' then bankcatename else bankname end as finorgname", "investtype", "currency", "isdomestic", "avgprinciple", "expectrate"});
        investDataSet = TmbrmAmountHelper.dealAmountConvert((DataSet)investDataSet, (Map)this.paramMap, Collections.singletonList("avgprinciple"), (String)"currency", (Date)new Date());
        investDataSet = investDataSet.addField("avgprinciple*expectrate", "avgrate");
        if (!"all".equals(this.dataRange)) {
            investDataSet = "domestic".equals(this.dataRange) ? investDataSet.filter("isdomestic='1'") : investDataSet.filter("isdomestic='0'");
        }
        if (this.onlyFinOrg) {
            investDs = investDataSet.groupBy(new String[]{"bankid", "finorgname", "investtype"}).sum("avgprinciple", "sumavgprinciple").sum("avgrate", "sumavgrate").finish();
            avgDepositDs = investDataSet.groupBy(new String[]{"bankid", "finorgname"}).sum("avgprinciple", "sumavgprinciple").sum("avgrate", "sumavgrate").finish();
        } else {
            investDs = investDataSet.groupBy(new String[]{"orgid", "orgname", "bankid", "finorgname", "investtype"}).sum("avgprinciple", "sumavgprinciple").sum("avgrate", "sumavgrate").finish();
            avgDepositDs = investDataSet.groupBy(new String[]{"orgid", "orgname", "bankid", "finorgname"}).sum("avgprinciple", "sumavgprinciple").sum("avgrate", "sumavgrate").finish();
        }
        investDs = investDs.addField("sumavgrate/sumavgprinciple", "avgexpectrate");
        DataSet[] depositSets = investDs.splitByFilter(new String[]{"investtype='notice'", "investtype='fixed'", "investtype='structure'", "investtype='huge'", "investtype='finance'"}, false);
        DataSet noticeDs = this.joinDepositDs(depositSets[0], source, new String[]{"sumavgprinciple", "sumavgprinciple as notice_avgprinciple", "avgexpectrate as t_notice_avgexpectrate"});
        DataSet fixedDs = this.joinDepositDs(depositSets[1], noticeDs, new String[]{"sumavgprinciple as fixed_avgprinciple", "avgexpectrate as t_fixed_avgexpectrate"});
        DataSet structureDs = this.joinDepositDs(depositSets[2], fixedDs, new String[]{"sumavgprinciple as structure_avgprinciple", "avgexpectrate as t_structure_avgexpectrate"});
        DataSet hugeDs = this.joinDepositDs(depositSets[3], structureDs, new String[]{"sumavgprinciple as huge_avgprinciple", "avgexpectrate as t_huge_avgexpectrate"});
        DataSet finaceDs = this.joinDepositDs(depositSets[4], hugeDs, new String[]{"sumavgprinciple as finance_avgprinciple", "avgexpectrate as t_finance_avgexpectrate"});
        DataSet avgDemandDs = this.queryAvgDemandDepositBalance();
        DataSet allDs = this.joinDepositDs(avgDemandDs, finaceDs, new String[]{DEMANDAVGBALANCE});
        allDs = allDs.addField("demandavgbalance+notice_avgprinciple+fixed_avgprinciple+structure_avgprinciple+huge_avgprinciple+finance_avgprinciple", TOTAL_AVGPRINCIPLE);
        avgDepositDs = avgDepositDs.addField("sumavgrate/sumavgprinciple", DEPOSITAVGRATE);
        allDs = this.joinDepositDs(avgDepositDs, allDs, new String[]{DEPOSITAVGRATE});
        allDs = allDs.removeFields(new String[]{"sumavgprinciple"});
        return allDs;
    }

    private DataSet joinDepositDs(DataSet depositSet, DataSet source, String[] otherFeilds) {
        String[] fieldNames = source.getRowMeta().getFieldNames();
        if (this.onlyFinOrg) {
            return source.copy().leftJoin(depositSet).on("bankid", "bankid").select(fieldNames, otherFeilds).finish();
        }
        return source.copy().leftJoin(depositSet).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, otherFeilds).finish();
    }

    private List<Object[]> getDateList() {
        ArrayList<Object[]> resList = new ArrayList<Object[]>(10);
        resList.add(new Object[]{this.queryDateStart, this.queryDateEnd, "Y"});
        return resList;
    }

    private QFilter getFinSubscribeFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("finservicestatus", "!=", (Object)"subscribe_ing");
        this.appendTradechannelFilter(filter);
        filter.and(this.getDateFilter(this.queryDateStart, this.queryDateEnd, "valuedate"));
        filter.and("org.id", "in", (Object)this.allOrgIds);
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            filter.and("finorginfo.bank_cate.id", "in", (Object)this.finOrgIds);
        } else {
            filter.and("finorginfo.id", "in", (Object)this.finOrgIds);
        }
        return filter;
    }

    private QFilter getDepositFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("investvarieties.investtype", "in", INVESTTYPELIST);
        filter.and("bizstatus", "!=", (Object)"subscribe_ing");
        this.appendTradechannelFilter(filter);
        filter.and(this.getDateFilter(this.queryDateStart, this.queryDateEnd, "intdate"));
        filter.and("org", "in", (Object)this.allOrgIds);
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            filter.and("finorginfo.bank_cate.id", "in", (Object)this.finOrgIds);
        } else {
            filter.and("finorginfo.id", "in", (Object)this.finOrgIds);
        }
        return filter;
    }

    private QFilter getDateFilter(Date queryStartDate, Date queryEndDate, String intdateName) {
        QFilter dateFilter = new QFilter(intdateName, "<=", (Object)queryEndDate);
        QFilter clearDateFilter = QFilter.isNull((String)"cleardate").or(new QFilter("cleardate", ">", (Object)queryStartDate));
        return dateFilter.and(clearDateFilter);
    }

    private void appendTradechannelFilter(QFilter qFilter) {
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ?)", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        qFilter.and(channelFilter);
    }

    private QFilter getDateRangeFilter() {
        QFilter dateFilter = new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)this.queryDateStart, (boolean)true));
        dateFilter.and("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)this.queryDateEnd, (boolean)false));
        return dateFilter;
    }
}

