/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.action;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.FinanceCostCommonHelper;
import kd.tmc.fbp.common.model.tda.finance.FinCostRequest;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tmbrm.common.enums.FinanceCostTermEnum;
import kd.tmc.tmbrm.common.helper.DecisionCommonHelper;
import kd.tmc.tmbrm.common.helper.TmbrmAmountHelper;
import kd.tmc.tmbrm.report.action.AbstractAnalysisQueryDataAction;

public class LoanQueryDataAction
extends AbstractAnalysisQueryDataAction {
    public static final String ACTION_KEY = "loan";
    public static final String LOANAMOUNT_SHORT = "shortloanamount";
    public static final String LOANAMOUNT_LONG = "longloanamount";
    public static final String AVGBALANCE_SHORT = "shortavgbalance";
    public static final String AVGBALANCE_LONG = "longavgbalance";
    public static final String SHORTINTEREST = "t_shortinterest";
    public static final String LONGINTEREST = "t_longinterest";
    private static final String[] AVG_SELECTFEILDS = new String[]{"orgid", "companyname as orgname", "case when creditortype='bank' then bankcate else creditor end as bankid", "case when creditortype='bank' then bankcatename else textcreditor end as finorgname", "currency", "drawamount as loanamount", "principle", "dayweight", "intrate", "term"};
    private static final BigDecimal ONE_YEAR = new BigDecimal("365");
    private final DataSet orginalDs = this.queryData();
    private DataSet avgBalanceDs;

    public LoanQueryDataAction(Map<String, Object> paramMap, List<Long> orgIds) {
        super(paramMap, orgIds);
    }

    @Override
    protected QFilter getQFilter() {
        QFilter filter = new QFilter("org.id", "in", (Object)this.allOrgIds);
        if (!"all".equals(this.dataRange)) {
            if ("domestic".equals(this.dataRange)) {
                filter.and("region", "=", (Object)"R1");
            } else {
                filter.and("region", "in", Arrays.asList("R2", "R3"));
            }
        }
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        return filter;
    }

    @Override
    public final DataSet queryData() {
        QFilter filter = new QFilter("loantype", "=", (Object)ACTION_KEY);
        DataSet finOrgInfos = null;
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            QFilter qFilter = new QFilter("bank_cate.id", "in", (Object)this.finOrgIds);
            finOrgInfos = QueryServiceHelper.queryDataSet((String)"LoanQueryDataAction.getfinorginfo", (String)"bd_finorginfo", (String)"id,bank_cate.id as bankcateid,bank_cate.name as bankcatename", (QFilter[])qFilter.toArray(), null);
            Set ids = DecisionCommonHelper.getFieldValues((DataSet)finOrgInfos.copy(), (String)"id", Long.class);
            filter.and("creditor", "in", (Object)ids);
        } else {
            filter.and("creditor", "in", (Object)this.finOrgIds);
        }
        filter.and(this.getDateFilter());
        String selectFeilds = "id,org.id as orgid,org.name as orgname,currency,textcreditor as finorgname, creditor as bankid,drawamount as loanamount,case when renewalexpiredate is not null then renewalexpiredate else expiredate end as expiredate,startintdate";
        DataSet loanDs = this.queryDataByFilter(selectFeilds, filter);
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            loanDs = loanDs.leftJoin(finOrgInfos).on("bankid", "id").select(new String[]{"id", "orgid", "orgname", "currency", "bankcatename as finorgname", "bankcateid as bankid", "loanamount", "expiredate", "startintdate"}).finish();
        }
        filter = new QFilter("loantype", "=", (Object)"sl");
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            filter.and("banksyndicate_entry.e_bank.bank_cate.id", "in", (Object)this.finOrgIds);
        } else {
            filter.and("banksyndicate_entry.e_bank.id", "in", (Object)this.finOrgIds);
        }
        filter.and(this.getDateFilter());
        selectFeilds = "id,org.id as orgid,org.name as orgname,currency,case when banksyndicate_entry.e_bank.finorgtype.number = 'FI-014' then banksyndicate_entry.e_bank.bank_cate.name else banksyndicate_entry.e_bank.name end as finorgname,case when banksyndicate_entry.e_bank.finorgtype.number = 'FI-014' then banksyndicate_entry.e_bank.bank_cate.id else banksyndicate_entry.e_bank.id end as bankid,banksyndicate_entry.e_shareamount as loanamount,case when renewalexpiredate is not null then renewalexpiredate else expiredate end as expiredate,startintdate";
        DataSet lsDs = this.queryDataByFilter(selectFeilds, filter);
        DataSet unionDs = loanDs.union(lsDs);
        unionDs = TmbrmAmountHelper.dealAmountConvert((DataSet)unionDs, (Map)this.paramMap, Collections.singletonList("loanamount"), (String)"currency", (Date)new Date());
        unionDs = unionDs.addField("0", "yeardiff");
        final RowMeta rowMetas = unionDs.getRowMeta();
        unionDs = unionDs.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if ("yeardiff".equals(fieldName)) {
                        Date startIntDate = row.getDate("startintdate");
                        Date expireDate = row.getDate("expiredate");
                        int diffdays = DateUtils.getDiffDays((Date)startIntDate, (Date)expireDate);
                        BigDecimal diffYears = new BigDecimal(String.valueOf(diffdays)).divide(ONE_YEAR, RoundingMode.HALF_UP);
                        rowInfo.add(diffYears);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }
        });
        return unionDs;
    }

    private QFilter getDateFilter() {
        QFilter filter = new QFilter("startintdate", ">=", (Object)this.queryDateStart);
        filter.and("startintdate", "<=", (Object)this.queryDateEnd);
        return filter;
    }

    private DataSet queryDataByFilter(String selectFields, QFilter filter) {
        return QueryServiceHelper.queryDataSet((String)"kd.tmc.tmbrm.report.action.LoanQueryDataAction.queryData", (String)"cfm_loanbill", (String)selectFields, (QFilter[])new QFilter[]{this.getQFilter(), filter}, null);
    }

    public void queryAvgBalance() {
        FinCostRequest request = new FinCostRequest(LoanQueryDataAction.class.getName(), this.queryDate, Long.valueOf(0L), Long.valueOf(0L), this.getDateList(), this.getLoanQFilter());
        DataSet loanDs = FinanceCostCommonHelper.getAllViewData((FinCostRequest)request).select(AVG_SELECTFEILDS);
        FinCostRequest slRequest = new FinCostRequest(LoanQueryDataAction.class.getName(), this.queryDate, Long.valueOf(0L), Long.valueOf(0L), this.getDateList(), this.getSlQFilter());
        DataSet lsDs = FinanceCostCommonHelper.getAllViewData((FinCostRequest)slRequest).select(AVG_SELECTFEILDS);
        DataSet unionDs = loanDs.union(lsDs);
        unionDs = TmbrmAmountHelper.dealAmountConvert((DataSet)unionDs, (Map)this.paramMap, Arrays.asList("loanamount", "principle"), (String)"currency", (Date)new Date());
        unionDs = unionDs.addFields(new String[]{"principle * dayweight", "principle * dayweight * intrate", "0"}, new String[]{"avgbalance", "interest", "yeardiff"});
        final RowMeta rowMetas = unionDs.getRowMeta();
        this.avgBalanceDs = unionDs = unionDs.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if ("yeardiff".equals(fieldName)) {
                        String term = row.getString("term");
                        int diffYears = 1;
                        FinanceCostTermEnum financeCostTermEnum = FinanceCostTermEnum.matchExp((String)term);
                        if (1 != financeCostTermEnum.getIndex() && 2 != financeCostTermEnum.getIndex()) {
                            diffYears = 2;
                        }
                        rowInfo.add(diffYears);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }
        });
    }

    private QFilter getLoanQFilter() {
        QFilter filter = new QFilter("loantype", "=", (Object)ACTION_KEY);
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            QFilter qFilter = new QFilter("bank_cate.id", "in", (Object)this.finOrgIds);
            DataSet finOrgInfos = QueryServiceHelper.queryDataSet((String)"LoanQueryDataAction.getfinorginfo", (String)"bd_finorginfo", (String)"id,bank_cate.id as bankcateid,bank_cate.name as bankcatename", (QFilter[])qFilter.toArray(), null);
            Set ids = DecisionCommonHelper.getFieldValues((DataSet)finOrgInfos.copy(), (String)"id", Long.class);
            filter.and("creditor", "in", (Object)ids);
        } else {
            filter.and("creditor", "in", (Object)this.finOrgIds);
        }
        return filter.and(this.getQFilter()).and(this.getDateFilter());
    }

    private QFilter getSlQFilter() {
        QFilter filter = new QFilter("loantype", "=", (Object)"sl");
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            filter.and("banksyndicate_entry.e_bank.bank_cate.id", "in", (Object)this.finOrgIds);
        } else {
            filter.and("banksyndicate_entry.e_bank.id", "in", (Object)this.finOrgIds);
        }
        return filter.and(this.getQFilter()).and(this.getDateFilter());
    }

    private List<Object[]> getDateList() {
        ArrayList<Object[]> resList = new ArrayList<Object[]>(10);
        resList.add(new Object[]{this.queryDateStart, this.queryDateEnd, "Y"});
        return resList;
    }

    public DataSet queryShortTermLoanAmt(DataSet source) {
        DataSet shortTermDs = this.orginalDs.copy().filter("yeardiff<=1");
        DataSet shortTermAmtDs = shortTermDs.groupBy(this.getGroupFields()).sum("loanamount", LOANAMOUNT_SHORT).finish();
        if (source != null) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            shortTermAmtDs = this.onlyFinOrg ? source.copy().leftJoin(shortTermAmtDs).on("bankid", "bankid").select(fieldNames, new String[]{LOANAMOUNT_SHORT}).finish() : source.copy().leftJoin(shortTermAmtDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{LOANAMOUNT_SHORT}).finish();
        }
        return shortTermAmtDs;
    }

    public DataSet queryLongTermLoanAmt(DataSet source) {
        DataSet longTermDs = this.orginalDs.copy().filter("yeardiff>1");
        DataSet longTermAmtDs = longTermDs.groupBy(this.getGroupFields()).sum("loanamount", LOANAMOUNT_LONG).finish();
        if (source != null) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            longTermAmtDs = this.onlyFinOrg ? source.copy().leftJoin(longTermAmtDs).on("bankid", "bankid").select(fieldNames, new String[]{LOANAMOUNT_LONG}).finish() : source.copy().leftJoin(longTermAmtDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{LOANAMOUNT_LONG}).finish();
        }
        return longTermAmtDs;
    }

    public DataSet queryShortInterest(DataSet source) {
        DataSet shortTermDs = this.avgBalanceDs.copy().filter("yeardiff<=1");
        DataSet shortTermAmtDs = shortTermDs.groupBy(this.getGroupFields()).sum("interest", "shortrest").finish();
        String[] fieldNames = source.getRowMeta().getFieldNames();
        shortTermAmtDs = this.onlyFinOrg ? source.copy().leftJoin(shortTermAmtDs).on("bankid", "bankid").select(fieldNames, new String[]{"shortrest"}).finish() : source.copy().leftJoin(shortTermAmtDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{"shortrest"}).finish();
        shortTermAmtDs = shortTermAmtDs.addField("shortrest/shortavgbalance", SHORTINTEREST);
        shortTermAmtDs = shortTermAmtDs.removeFields(new String[]{"shortrest"});
        return shortTermAmtDs;
    }

    public DataSet queryLongInterest(DataSet source) {
        DataSet longTermDs = this.avgBalanceDs.copy().filter("yeardiff>1");
        DataSet longTermAmtDs = longTermDs.groupBy(this.getGroupFields()).sum("interest", "longrest").finish();
        String[] fieldNames = source.getRowMeta().getFieldNames();
        longTermAmtDs = this.onlyFinOrg ? source.copy().leftJoin(longTermAmtDs).on("bankid", "bankid").select(fieldNames, new String[]{"longrest"}).finish() : source.copy().leftJoin(longTermAmtDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{"longrest"}).finish();
        longTermAmtDs = longTermAmtDs.addField("longrest/longavgbalance", LONGINTEREST);
        longTermAmtDs = longTermAmtDs.removeFields(new String[]{"longrest"});
        return longTermAmtDs;
    }

    public DataSet queryShortAvgBalance(DataSet source) {
        DataSet shortTermDs = this.avgBalanceDs.copy().filter("yeardiff<=1");
        DataSet shortTermAmtDs = shortTermDs.groupBy(this.getGroupFields()).sum("avgbalance", AVGBALANCE_SHORT).finish();
        if (source != null) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            shortTermAmtDs = this.onlyFinOrg ? source.copy().leftJoin(shortTermAmtDs).on("bankid", "bankid").select(fieldNames, new String[]{AVGBALANCE_SHORT}).finish() : source.copy().leftJoin(shortTermAmtDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{AVGBALANCE_SHORT}).finish();
        }
        return shortTermAmtDs;
    }

    public DataSet queryLongAvgBalance(DataSet source) {
        DataSet longTermDs = this.avgBalanceDs.copy().filter("yeardiff>1");
        DataSet longTermAmtDs = longTermDs.groupBy(this.getGroupFields()).sum("avgbalance", AVGBALANCE_LONG).finish();
        if (source != null) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            longTermAmtDs = this.onlyFinOrg ? source.copy().leftJoin(longTermAmtDs).on("bankid", "bankid").select(fieldNames, new String[]{AVGBALANCE_LONG}).finish() : source.copy().leftJoin(longTermAmtDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{AVGBALANCE_LONG}).finish();
        }
        return longTermAmtDs;
    }
}

