/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.action;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tmbrm.common.helper.TmbrmAmountHelper;
import kd.tmc.tmbrm.report.action.AbstractAnalysisQueryDataAction;

public class SettleQueryDataAction
extends AbstractAnalysisQueryDataAction {
    public static final String ACTION_KEY = "settle";
    public static final String SETTLEAMOUNT = "settleamount";
    public static final String SETTLECNT = "settlecnt";
    private DataSet orginalDs = this.queryData();

    public SettleQueryDataAction(Map<String, Object> paramMap, List<Long> orgIds) {
        super(paramMap, orgIds);
    }

    @Override
    protected QFilter getQFilter() {
        QFilter qFilter = new QFilter("company.id", "in", (Object)this.allOrgIds);
        if (FinOrgTypeEnum.BANK.getNumber().equals(this.finTypeNum)) {
            qFilter.and("bank.bank_cate.id", "in", (Object)this.finOrgIds);
        } else {
            qFilter.and("bank.id", "in", (Object)this.finOrgIds);
        }
        qFilter.and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)this.queryDateStart, (boolean)true));
        qFilter.and("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)this.queryDateEnd, (boolean)false));
        return qFilter;
    }

    @Override
    public final DataSet queryData() {
        String selectFields = "id, company.id orgid, company.name as orgname,case when bank.country.twocountrycode = 'CN' OR bank.country.threecountrycode = 'CHN' OR bank.country = 0 OR ((bank.country.twocountrycode = NULL OR TRIM(bank.country.twocountrycode) = '') AND (bank.country.threecountrycode = NULL OR TRIM(bank.country.threecountrycode) = '')) then 'domestic' else 'overseas' end as areas,debitamount , creditamount, currency,case when bank.finorgtype.number = 'FI-014' then bank.bank_cate.id else bank.id end as bankid,case when bank.finorgtype.number = 'FI-014' then bank.bank_cate.name else bank.name end as finorgname";
        DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.tmc.tmbrm.report.handle.SettleQueryDataHandle.queryData", (String)"bei_transdetail", (String)selectFields, (QFilter[])this.getQFilter().toArray(), null);
        if (!"all".equals(this.dataRange)) {
            ds = ds.filter("areas='" + this.dataRange + "'");
        }
        return ds;
    }

    public DataSet querySettleCntDs(DataSet source) {
        DataSet settleCntDs = this.orginalDs.copy().groupBy(this.getGroupFields()).count(SETTLECNT).finish();
        if (source != null) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            settleCntDs = this.onlyFinOrg ? source.copy().leftJoin(settleCntDs).on("bankid", "bankid").select(fieldNames, new String[]{SETTLECNT}).finish() : source.copy().leftJoin(settleCntDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{SETTLECNT}).finish();
        }
        return settleCntDs;
    }

    public DataSet querySettleAmtDs(DataSet source) {
        this.orginalDs = TmbrmAmountHelper.dealAmountConvert((DataSet)this.orginalDs, (Map)this.paramMap, Arrays.asList("debitamount", "creditamount"), (String)"currency", (Date)new Date());
        DataSet amountDs = this.orginalDs.groupBy(this.getGroupFields()).sum("debitamount").sum("creditamount").finish();
        amountDs = amountDs.addField("0.0", SETTLEAMOUNT);
        final RowMeta rowMetas = amountDs.getRowMeta();
        amountDs = amountDs.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if (SettleQueryDataAction.SETTLEAMOUNT.equals(fieldName)) {
                        BigDecimal amount = row.getBigDecimal("debitamount").add(row.getBigDecimal("creditamount"));
                        rowInfo.add(amount);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }
        });
        if (source != null) {
            String[] fieldNames = source.getRowMeta().getFieldNames();
            amountDs = this.onlyFinOrg ? source.copy().leftJoin(amountDs).on("bankid", "bankid").select(fieldNames, new String[]{SETTLEAMOUNT}).finish() : source.copy().leftJoin(amountDs).on("bankid", "bankid").on("orgid", "orgid").select(fieldNames, new String[]{SETTLEAMOUNT}).finish();
        }
        return amountDs;
    }
}

