/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.tmbrm.common.enums.ArchivesAnalysisGroupEnum;
import kd.tmc.tmbrm.common.enums.ArchivesAnalysisIndexEnum;
import kd.tmc.tmbrm.common.helper.DecisionCommonHelper;
import kd.tmc.tmbrm.report.action.BankAcctQueryDataAction;
import kd.tmc.tmbrm.report.action.BondQueryDataAction;
import kd.tmc.tmbrm.report.action.CreditQueryDataAction;
import kd.tmc.tmbrm.report.action.DepositQueryDataAction;
import kd.tmc.tmbrm.report.action.LoanQueryDataAction;
import kd.tmc.tmbrm.report.action.SettleQueryDataAction;
import kd.tmc.tmbrm.report.factory.CoDataCommonFieldsFactory;
import org.apache.commons.lang3.tuple.Pair;

public class CoDataAnalysisListDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Log logger = LogFactory.getLog(CoDataAnalysisListDataPlugin.class);
    private Set<String> analysisIndex;
    private String statDim;
    private boolean showTile;
    private CoDataCommonFieldsFactory factory;
    private List<String> amountFields = new ArrayList<String>(10);
    private List<String> allFields = new ArrayList<String>(10);

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        List orgIds = this.getQueryOrgIds(queryParam);
        logger.info("\u67e5\u8be2\u5408\u4f5c\u6570\u636e\u7efc\u5408\u5206\u6790\uff0corg size:" + orgIds.size());
        Map paramMap = this.transQueryParam(queryParam);
        this.analysisIndex = (Set)paramMap.get("filter_analysisindex");
        this.statDim = (String)paramMap.get("filter_statdim");
        this.showTile = "tile".equals(paramMap.get("filter_showttype"));
        this.factory = new CoDataCommonFieldsFactory(paramMap, orgIds);
        DataSet resultDs = this.factory.getCommonFields();
        if (ArchivesAnalysisIndexEnum.containsAcct(this.analysisIndex)) {
            resultDs = this.addAcctDs(resultDs);
        }
        if (ArchivesAnalysisIndexEnum.containsSettle(this.analysisIndex)) {
            resultDs = this.addSettleDs(resultDs);
        }
        if (ArchivesAnalysisIndexEnum.containsCredit(this.analysisIndex)) {
            resultDs = this.addCreditDs(resultDs);
        }
        if (ArchivesAnalysisIndexEnum.containsBond(this.analysisIndex)) {
            resultDs = this.addBondDs(resultDs);
        }
        if (ArchivesAnalysisIndexEnum.containsLoan(this.analysisIndex)) {
            resultDs = this.addLoanDs(resultDs);
        }
        if (ArchivesAnalysisIndexEnum.containsDeposit(this.analysisIndex)) {
            resultDs = this.addDepositDs(resultDs);
        }
        this.allFields.addAll(this.amountFields);
        resultDs = DecisionCommonHelper.removeNoDataTreeDs((DataSet)resultDs, this.allFields);
        return resultDs;
    }

    private DataSet addDepositDs(DataSet resultDs) {
        long start = System.currentTimeMillis();
        DepositQueryDataAction depositAction = (DepositQueryDataAction)this.factory.getAction("deposit");
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.HQCK.getValue())) {
            this.amountFields.add("demandamt");
            resultDs = depositAction.queryDemandDepositData(resultDs);
        }
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.PJCKYE.getValue())) {
            this.amountFields.add("demandavgbalance");
            this.amountFields.add("notice_avgprinciple");
            this.amountFields.add("fixed_avgprinciple");
            this.amountFields.add("structure_avgprinciple");
            this.amountFields.add("huge_avgprinciple");
            this.amountFields.add("finance_avgprinciple");
            this.amountFields.add("total_avgprinciple");
            this.allFields.add("t_notice_avgexpectrate");
            this.allFields.add("t_fixed_avgexpectrate");
            this.allFields.add("t_structure_avgexpectrate");
            this.allFields.add("t_huge_avgexpectrate");
            this.allFields.add("t_finance_avgexpectrate");
            this.allFields.add("t_depositavgrate");
            resultDs = depositAction.queryInvestData(resultDs);
        }
        logger.info("\u52a0\u8f7d\u3010\u5b58\u6b3e\u3011\u76f8\u5173\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return resultDs;
    }

    private DataSet addLoanDs(DataSet resultDs) {
        long start = System.currentTimeMillis();
        LoanQueryDataAction longAction = (LoanQueryDataAction)this.factory.getAction("loan");
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.LJDKYE.getValue())) {
            this.amountFields.add("longloanamount");
            this.amountFields.add("shortloanamount");
            resultDs = longAction.queryShortTermLoanAmt(resultDs);
            resultDs = longAction.queryLongTermLoanAmt(resultDs);
        }
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.PJDKYE.getValue())) {
            longAction.queryAvgBalance();
            this.amountFields.add("shortavgbalance");
            this.amountFields.add("longavgbalance");
            this.allFields.add("t_shortinterest");
            this.allFields.add("t_longinterest");
            resultDs = longAction.queryShortAvgBalance(resultDs);
            resultDs = longAction.queryLongAvgBalance(resultDs);
            resultDs = longAction.queryShortInterest(resultDs);
            resultDs = longAction.queryLongInterest(resultDs);
        }
        logger.info("\u52a0\u8f7d\u3010\u8d37\u6b3e\u3011\u76f8\u5173\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return resultDs;
    }

    private DataSet addBondDs(DataSet resultDs) {
        long start = System.currentTimeMillis();
        BondQueryDataAction bondAction = (BondQueryDataAction)this.factory.getAction("bond");
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.LJZQTZJE.getValue())) {
            this.amountFields.add("investamount");
            resultDs = bondAction.queryInvestData(resultDs);
        }
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.LJZQCXJE.getValue())) {
            this.amountFields.add("underwriteamount");
            resultDs = bondAction.queryUnderWriteData(resultDs);
        }
        logger.info("\u52a0\u8f7d\u3010\u503a\u5238\u3011\u76f8\u5173\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return resultDs;
    }

    private DataSet addCreditDs(DataSet resultDs) {
        long start = System.currentTimeMillis();
        CreditQueryDataAction creditAction = (CreditQueryDataAction)this.factory.getAction("credit");
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.SXED.getValue())) {
            this.amountFields.add("creditamount");
            resultDs = creditAction.queryCreditLimit(resultDs);
        }
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.LJYXED.getValue())) {
            this.amountFields.add("useamount");
            resultDs = creditAction.queryCreditLimitUse(resultDs);
        }
        logger.info("\u52a0\u8f7d\u3010\u6388\u4fe1\u3011\u76f8\u5173\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return resultDs;
    }

    private DataSet addSettleDs(DataSet resultDs) {
        long start = System.currentTimeMillis();
        SettleQueryDataAction settleAction = (SettleQueryDataAction)this.factory.getAction("settle");
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.JSJE.getValue())) {
            this.amountFields.add("settleamount");
            resultDs = settleAction.querySettleAmtDs(resultDs);
        }
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.JSBS.getValue())) {
            this.allFields.add("settlecnt");
            resultDs = settleAction.querySettleCntDs(resultDs);
        }
        logger.info("\u52a0\u8f7d\u3010\u7ed3\u7b97\u3011\u76f8\u5173\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return resultDs;
    }

    private DataSet addAcctDs(DataSet resultDs) {
        long start = System.currentTimeMillis();
        BankAcctQueryDataAction bankAcctAction = (BankAcctQueryDataAction)this.factory.getAction("bankacct");
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.YHZH.getValue())) {
            this.allFields.add("bankaccountcnt");
            resultDs = bankAcctAction.queryBankCntDs(resultDs);
        }
        if (this.analysisIndex.contains(ArchivesAnalysisIndexEnum.KTZLZH.getValue())) {
            this.allFields.add("bankinterfacecnt");
            resultDs = bankAcctAction.queryBankInterfaceCntDs(resultDs);
        }
        logger.info("\u52a0\u8f7d\u3010\u8d26\u6237\u3011\u76f8\u5173\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return resultDs;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (null == dataSet || dataSet.isEmpty()) {
            return dataSet;
        }
        if ("finorgorg".equals(this.statDim)) {
            queryParam.setTreeReportList(true);
            DataSet totalRowDs = dataSet.copy().filter("sumlevel=2").addField("'0'", "isgroupnode");
            dataSet = dataSet.filter("sumlevel=0");
            dataSet = dataSet.updateField("pid", "'0'");
            Long statCurrency = ((DynamicObject)queryParam.getFilter().getFilterItem("filter_statcurrency").getValue()).getLong("id");
            dataSet = dataSet.addField("'0'", "isgroupnode");
            dataSet = dataSet.copy().updateFields(new String[]{"rowid", "pid", "level"}, new String[]{"concat(orgid,bankid)", "level+'_'+bankid", "2"});
            GroupbyDataSet groupDataSet = dataSet.groupBy(new String[]{"bankid", "finorgname"});
            for (String sumField : this.allFields) {
                groupDataSet.sum(sumField);
            }
            DataSet groupDs = groupDataSet.finish().addFields(new String[]{"0", "''", String.valueOf(statCurrency), "0", "'1_'+bankid", "'0'", "1", "'1'"}, new String[]{"orgid", "orgname", "statcurrency", "sumlevel", "rowid", "pid", "level", "isgroupnode"});
            String[] fieldNames = dataSet.copy().getRowMeta().getFieldNames();
            groupDs = groupDs.select(fieldNames);
            dataSet = groupDs.union(dataSet);
            DataSet level2Ds = dataSet.filter("level=2").updateField("rowid", "level+'_'+bankid+'_'+orgid");
            dataSet = dataSet.filter("level=1").union(level2Ds);
            return dataSet.union(totalRowDs);
        }
        return dataSet;
    }

    private List<String> removeFields() {
        ArrayList<String> fields = new ArrayList<String>(this.allFields);
        fields.remove("t_shortinterest");
        fields.remove("t_longinterest");
        fields.remove("t_notice_avgexpectrate");
        fields.remove("t_fixed_avgexpectrate");
        fields.remove("t_structure_avgexpectrate");
        fields.remove("t_huge_avgexpectrate");
        fields.remove("t_finance_avgexpectrate");
        fields.remove("t_depositavgrate");
        return fields;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        if ("orgfinorg".equals(this.statDim)) {
            columns.add((AbstractReportColumn)this.createReportColumn("orgname", ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7", (String)"CoDataAnalysisListDataPlugin_1", (String)"tmc-tmbrm-report", (Object[])new Object[0]), "text"));
            columns.add((AbstractReportColumn)this.createReportColumn("finorgname", ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784", (String)"CoDataAnalysisListDataPlugin_0", (String)"tmc-tmbrm-report", (Object[])new Object[0]), "text"));
        } else {
            columns.add((AbstractReportColumn)this.createReportColumn("finorgname", ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784", (String)"CoDataAnalysisListDataPlugin_0", (String)"tmc-tmbrm-report", (Object[])new Object[0]), "text"));
            if ("finorgorg".equals(this.statDim)) {
                columns.add((AbstractReportColumn)this.createReportColumn("orgname", ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7", (String)"CoDataAnalysisListDataPlugin_1", (String)"tmc-tmbrm-report", (Object[])new Object[0]), "text"));
            }
        }
        for (ArchivesAnalysisIndexEnum enumValue : ArchivesAnalysisIndexEnum.values()) {
            if (!this.analysisIndex.contains(enumValue.getValue())) continue;
            if (enumValue.isGroup()) {
                columns.add((AbstractReportColumn)this.createReportColumnGroup(enumValue.getFieldKey(), enumValue.getEnumBridge()));
                continue;
            }
            columns.add((AbstractReportColumn)this.createReportColumn(enumValue.getFieldKey(), enumValue.getEnumBridge(), enumValue.getFieldType()));
        }
        return columns;
    }

    private ReportColumnGroup createReportColumnGroup(String fieldKey, String caption) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setFieldKey(fieldKey);
        group.setCaption(new LocaleString(caption));
        List childs = ArchivesAnalysisGroupEnum.getEnumsByParent((String)fieldKey);
        for (ArchivesAnalysisGroupEnum groupEnum : childs) {
            group.getChildren().add(this.createReportColumn(groupEnum.getFieldKey(), groupEnum.getEnumBridge(), groupEnum.getFieldType()));
        }
        return group;
    }

    private ReportColumn createReportColumn(String fieldKey, String caption, String fieldType) {
        ReportColumn column = new ReportColumn();
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        column.setZeroShow(true);
        column.setCaption(new LocaleString(caption));
        if ("amount".equals(fieldType)) {
            column.setCurrencyField("statcurrency");
        }
        return column;
    }

    protected boolean isNeedOrgTree() {
        return "orgfinorg".equals(this.statDim);
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        if ("orgfinorg".equals(this.statDim) && this.showTile) {
            bizDs = bizDs.updateField("rowid", "sumlevel+'_'+bankid+'_'+orgid");
            return super.addSubRowDataSet(bizDs, paramMap);
        }
        return bizDs;
    }

    public List<String> groupFields() {
        ArrayList<String> groupFilds = new ArrayList<String>(2);
        if ("finorg".equals(this.statDim)) {
            groupFilds.add("bankid");
            return groupFilds;
        }
        groupFilds.add("orgid");
        if (this.showTile) {
            return groupFilds;
        }
        groupFilds.add("bankid");
        return groupFilds;
    }

    public Pair<String, String> treeGroupField() {
        return Pair.of((Object)"bankid", (Object)"finorgname");
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"orgid", (Object)"orgname");
    }

    public List<String> amountFields() {
        return this.removeFields();
    }

    protected List<String> orinalAmountField() {
        return this.amountFields;
    }

    protected boolean isNeedCurrencyUnit() {
        return true;
    }

    public String sumNameField() {
        if ("orgfinorg".equals(this.statDim)) {
            return "orgname";
        }
        return "finorgname";
    }

    public List<String> sumAmountFields() {
        return this.removeFields();
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }
}

