/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.data;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class EvalResultQueryListDataPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(EvalResultQueryListDataPlugin.class);
    private static final String ENTRY_ID = "entryid";
    private static final String NODE_ID = "nodeId";
    private static final String SELECT_FIELDS = "resultentry entryid, resultentry.resultevalpoint evalscore, billno";

    public DataSet query(ReportQueryParam param, Object o) {
        DynamicObjectCollection resultEntries;
        QFilter qFilter = new QFilter("billno", "=", o);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"tmbrm_eval_report", (String)SELECT_FIELDS, (QFilter[])qFilter.toArray(), (String)"");
        dataSet = dataSet.filter("evalscore != null");
        param.getCustomParam().put(NODE_ID, o);
        DynamicObject evalReport = BusinessDataServiceHelper.loadSingle((String)"tmbrm_eval_report", (String)"resultentry, resultentry.result_finorg, resultentry.detailscore_tag", (QFilter[])qFilter.toArray());
        ArrayList<String> fieldNames = new ArrayList<String>(10);
        fieldNames.add(ENTRY_ID);
        fieldNames.add("finorginfo");
        ArrayList<Object> dataTypes = new ArrayList<Object>(10);
        dataTypes.add(DataType.LongType);
        dataTypes.add(DataType.StringType);
        ArrayList<Object[]> rows = new ArrayList<Object[]>(10);
        if (evalReport != null && EmptyUtil.isNoEmpty((DynamicObjectCollection)(resultEntries = evalReport.getDynamicObjectCollection("resultentry")))) {
            Map<Long, BigDecimal> scoreMap = this.deSerialScores(((DynamicObject)resultEntries.get(0)).getString("detailscore_tag"));
            for (Map.Entry<Long, BigDecimal> scoreEntry : scoreMap.entrySet()) {
                fieldNames.add("item" + scoreEntry.getKey());
                dataTypes.add(DataType.BigDecimalType);
            }
            for (DynamicObject resultEntry : resultEntries) {
                ArrayList<Object> row = new ArrayList<Object>(10);
                row.add(resultEntry.getLong("id"));
                row.add(resultEntry.getDynamicObject("result_finorg").getString("name"));
                Map<Long, BigDecimal> scores = this.deSerialScores(resultEntry.getString("detailscore_tag"));
                scores.forEach((key, value) -> row.add(value));
                rows.add(row.toArray());
            }
        }
        DataSet scoreDataSet = this.createRow(((Object)((Object)this)).getClass().getName(), fieldNames.toArray(new String[0]), dataTypes.toArray(new DataType[0]), rows);
        List<String> selectFields = Arrays.stream(scoreDataSet.getRowMeta().getFieldNames()).collect(Collectors.toList());
        selectFields.add("evalscore");
        selectFields.add("billno");
        return dataSet.leftJoin(scoreDataSet).on(ENTRY_ID, ENTRY_ID).select(selectFields.toArray(new String[0])).finish();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List columnList = super.getColumns(columns);
        ReportQueryParam queryParam = this.getQueryParam();
        QFilter qFilter = new QFilter("billno", "=", queryParam.getCustomParam().get(NODE_ID));
        DynamicObjectCollection evalProposals = QueryServiceHelper.query((String)"tmbrm_eval_report", (String)"evalschedule.evalproposal.entryentity.item id, evalschedule.evalproposal.entryentity.item.name name", (QFilter[])qFilter.toArray());
        for (DynamicObject evalProposal : evalProposals) {
            ReportColumn column = this.createColumn("item" + evalProposal.getLong("id"), evalProposal.getString("name"));
            columnList.add(column);
        }
        return columnList;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("decimal");
        reportColumn.setScale(2);
        reportColumn.setZeroShow(true);
        reportColumn.setCaption(new LocaleString(caption));
        ColumnStyle style = new ColumnStyle();
        style.setTextAlign("center");
        reportColumn.setStyle(style);
        return reportColumn;
    }

    private Map<Long, BigDecimal> deSerialScores(String detailScore) {
        String detail = null;
        try {
            detail = GzipUtils.uncompress((String)detailScore, (String)"UTF-8");
        }
        catch (IOException ex) {
            logger.error("\u89e3\u6790\u5206\u6570\u660e\u7ec6\u9519\u8bef\uff1a", (Throwable)ex);
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)detail);
    }

    private DataSet createRow(String className, String[] fieldNames, DataType[] dataTypes, Collection<Object[]> values) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        CollectionInput inputs = new CollectionInput(rowMeta, values);
        return Algo.create((String)className).createDataSet(new Input[]{inputs});
    }
}

