/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportTreeDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.EvalReportStatusEnum;
import kd.tmc.tmbrm.common.enums.EvaluationDateEnum;

public class EvalResultQueryTreeDataPlugin
extends AbstractReportTreeDataPlugin {
    private static final String ROOT_NODE_ID = "root-node";
    private static final String EVAL_DATE = "evalschedule.evaldate";

    public List<TreeNode> query(ReportQueryParam queryParam, String nodeId) {
        String evalTypes;
        Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)queryParam);
        QFilter qFilter = new QFilter("reportstatus", "=", (Object)EvalReportStatusEnum.CHECKED.getValue());
        String evalReportNos = (String)queryParam.getCustomParam().get("filter_evalreportbillno");
        if (EmptyUtil.isNoEmpty((String)evalReportNos)) {
            qFilter.and("billno", "in", Arrays.asList(evalReportNos.split(",")));
        }
        String evalDate = (String)paramMap.get("filter_evaldate");
        Date currentDate = DateUtils.getCurrentDate();
        if (EvaluationDateEnum.CUSTOM.getValue().equals(evalDate)) {
            Date startDate = (Date)paramMap.get("filter_daterange_startdate");
            Date endDate = (Date)paramMap.get("filter_daterange_enddate");
            qFilter.and(EVAL_DATE, ">=", (Object)startDate);
            qFilter.and(EVAL_DATE, "<=", (Object)endDate);
        } else if (EvaluationDateEnum.THIS.getValue().equals(evalDate)) {
            Date firstDayOfCurYear = DateUtils.getFirstDayOfCurYear();
            qFilter.and(EVAL_DATE, ">=", (Object)firstDayOfCurYear);
            qFilter.and(EVAL_DATE, "<=", (Object)currentDate);
        } else if (EvaluationDateEnum.LAST.getValue().equals(evalDate)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currentDate);
            int lastYear = calendar.get(1) - 1;
            Date firstDay = DateUtils.getYearFirst((int)lastYear);
            Date lastDay = DateUtils.getYearLast((int)lastYear);
            qFilter.and(EVAL_DATE, ">=", (Object)firstDay);
            qFilter.and(EVAL_DATE, "<=", (Object)lastDay);
        }
        String evalPeriods = (String)paramMap.get("filter_evalperiod");
        if (EmptyUtil.isNoEmpty((String)evalPeriods)) {
            qFilter.and("evalschedule.evalperiod", "in", this.transParamValue(evalPeriods));
        }
        if (EmptyUtil.isNoEmpty((String)(evalTypes = (String)paramMap.get("filter_evaltype")))) {
            qFilter.and("evalschedule.evaltype.number", "in", this.transParamValue(evalTypes));
        }
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.TMBRM.getValue(), (String)"tmbrm_evalresult_query", (String)"47150e89000000ac");
        qFilter.and("org", "in", (Object)orgIdList);
        DynamicObjectCollection evalReports = QueryServiceHelper.query((String)"tmbrm_eval_report", (String)"evalschedule.name,billno", (QFilter[])qFilter.toArray(), (String)"checktime desc");
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        TreeNode rootNode = new TreeNode("", ROOT_NODE_ID, ResManager.loadKDString((String)"\u5408\u4f5c\u91d1\u878d\u673a\u6784\u8bc4\u4ef7", (String)"EvalResultQueryTreeDataPlugin_0", (String)"tmc-tmbrm-report", (Object[])new Object[0]));
        rootNode.setIsOpened(true);
        treeNodes.add(rootNode);
        for (DynamicObject evalReport : evalReports) {
            TreeNode treeNode = new TreeNode();
            treeNode.setId(evalReport.getString("billno"));
            treeNode.setText(evalReport.getString("evalschedule.name"));
            treeNode.setParentid(ROOT_NODE_ID);
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    private List<String> transParamValue(String paramValue) {
        return Arrays.asList(paramValue.replaceFirst(",", "").split(","));
    }
}

