/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.factory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.tmbrm.report.action.AbstractAnalysisQueryDataAction;
import kd.tmc.tmbrm.report.action.BankAcctQueryDataAction;
import kd.tmc.tmbrm.report.action.BondQueryDataAction;
import kd.tmc.tmbrm.report.action.CreditQueryDataAction;
import kd.tmc.tmbrm.report.action.DepositQueryDataAction;
import kd.tmc.tmbrm.report.action.LoanQueryDataAction;
import kd.tmc.tmbrm.report.action.SettleQueryDataAction;

public class CoDataCommonFieldsFactory {
    private Map<String, Object> paramMap;
    private List<Long> orgIds;
    private Map<String, AbstractAnalysisQueryDataAction> actionsMap = new HashMap<String, AbstractAnalysisQueryDataAction>(16);

    public CoDataCommonFieldsFactory(Map<String, Object> paramMap, List<Long> orgIds) {
        this.paramMap = paramMap;
        this.orgIds = orgIds;
    }

    public DataSet getCommonFields() {
        List finOrgIds = (List)this.paramMap.get("filter_finorgid");
        String finTypeNumber = ((DynamicObject)this.paramMap.get("filter_fintype")).getString("number");
        String statDim = (String)this.paramMap.get("filter_statdim");
        DataSet finOrgDs = this.getFinOrgIds(finOrgIds, finTypeNumber);
        if ("finorg".equals(statDim)) {
            return finOrgDs.select("bankid,finorgname").distinct();
        }
        DataSet orgDs = this.getOrgDs(this.orgIds);
        return orgDs.leftJoin(finOrgDs).on("joinid", "joinid").select(new String[]{"bankid", "finorgname", "orgid", "orgname"}).finish().distinct();
    }

    private DataSet getFinOrgIds(List<Long> finOrgIds, String finTypeNumber) {
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (FinOrgTypeEnum.BANK.getNumber().equals(finTypeNumber)) {
            qFilter.and("bank_cate.id", "in", finOrgIds);
        } else {
            qFilter.and("id", "in", finOrgIds);
        }
        return QueryServiceHelper.queryDataSet((String)"kd.tmc.tmbrm.report.factory.CoDataCommonFieldsFactory#getFinOrgIds", (String)"bd_finorginfo", (String)"case when finorgtype.number = 'FI-014' then bank_cate.id else id end as bankid,case when finorgtype.number = 'FI-014' then bank_cate.name else name end as finorgname, 0 as joinid", (QFilter[])qFilter.toArray(), null);
    }

    private DataSet getOrgDs(List<Long> orgIds) {
        return QueryServiceHelper.queryDataSet((String)"kd.tmc.tmbrm.report.factory.CoDataCommonFieldsFactory#getOrgDs", (String)"bos_org", (String)"id as orgid, name as orgname, 0 as joinid", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)}, null);
    }

    public AbstractAnalysisQueryDataAction getAction(String key) {
        AbstractAnalysisQueryDataAction action = this.actionsMap.get(key);
        if (null != action) {
            return action;
        }
        switch (key) {
            case "bankacct": {
                action = new BankAcctQueryDataAction(this.paramMap, this.orgIds);
                break;
            }
            case "settle": {
                action = new SettleQueryDataAction(this.paramMap, this.orgIds);
                break;
            }
            case "bond": {
                action = new BondQueryDataAction(this.paramMap, this.orgIds);
                break;
            }
            case "credit": {
                action = new CreditQueryDataAction(this.paramMap, this.orgIds);
                break;
            }
            case "deposit": {
                action = new DepositQueryDataAction(this.paramMap, this.orgIds);
                break;
            }
            case "loan": {
                action = new LoanQueryDataAction(this.paramMap, this.orgIds);
                break;
            }
        }
        this.actionsMap.put(key, action);
        return action;
    }
}

