/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.QueryDateEnum;

public class CoDataAnalysisFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String RATE_FIELDS_PREFIX = "t_";
    private List<String> ratePropList = new ArrayList<String>(Arrays.asList("t_shortinterest", "t_longinterest", "t_notice_avgexpectrate", "t_fixed_avgexpectrate", "t_structure_avgexpectrate", "t_huge_avgexpectrate", "t_finance_avgexpectrate", "t_depositavgrate"));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit finOrg = (BasedataEdit)this.getView().getControl("filter_finorg2");
        finOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeQuery(ReportQueryParam param) {
        DynamicObjectCollection analysisIndex;
        super.beforeQuery(param);
        param.getFilter().addFilterItem("filter_statdim", this.getModel().getValue("filter_statdim"));
        DynamicObject finType = (DynamicObject)this.getModel().getValue("filter_fintype");
        String number = EmptyUtil.isNoEmpty((DynamicObject)finType) ? finType.getString("number") : "";
        boolean isBank = FinOrgTypeEnum.BANK.getNumber().equals(number);
        DynamicObjectCollection finOrgs = (DynamicObjectCollection)this.getModel().getValue(isBank ? "filter_finorg" : "filter_finorg2");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)finOrgs)) {
            List finOrgIds = finOrgs.stream().map(v -> (Long)v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            param.getFilter().addFilterItem("filter_finorgid", finOrgIds);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(analysisIndex = (DynamicObjectCollection)this.getModel().getValue("filter_analysisindex")))) {
            Set analysisIndexNums = analysisIndex.stream().map(v -> v.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toSet());
            param.getFilter().addFilterItem("filter_analysisindex", analysisIndexNums);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        QFilter qFilter = new QFilter("group.number", "=", (Object)"DAFXZB");
        DynamicObjectCollection assistants = QueryServiceHelper.query((String)"bos_assistantdata_detail", (String)"number,name,id", (QFilter[])qFilter.toArray());
        this.getModel().setValue("filter_analysisindex", (Object)assistants.stream().map(o -> o.getLong("id")).toArray());
        this.getView().updateView("filter_analysisindex");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "filter_fintype": {
                this.getModel().setValue("filter_finorg", null);
                this.getModel().setValue("filter_finorg2", null);
                break;
            }
            case "filter_statdim": {
                this.search();
                break;
            }
            case "filter_querydate": {
                ChangeData[] changeSet = e.getChangeSet();
                Object newValue = changeSet[0].getNewValue();
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)QueryDateEnum.CUSTOM.getValue().equals(newValue), (String[])new String[]{"filter_custdaterange"});
                break;
            }
        }
    }

    private void search() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        rptFilter.search();
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject finType = (DynamicObject)this.getModel().getValue("filter_fintype");
        if (EmptyUtil.isEmpty((DynamicObject)finType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91d1\u878d\u673a\u6784\u7c7b\u522b\u3002", (String)"CoDataAnalysisFormPlugin_0", (String)"tmc-tmbrm-report", (Object[])new Object[0]));
            return false;
        }
        String number = finType.getString("number");
        boolean isBank = FinOrgTypeEnum.BANK.getNumber().equals(number);
        DynamicObjectCollection finOrgs = (DynamicObjectCollection)this.getModel().getValue(isBank ? "filter_finorg" : "filter_finorg2");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)finOrgs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91d1\u878d\u673a\u6784\u3002", (String)"CoDataAnalysisFormPlugin_2", (String)"tmc-tmbrm-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection analysisIndex = (DynamicObjectCollection)this.getModel().getValue("filter_analysisindex");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)analysisIndex)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6307\u6807\u3002", (String)"CoDataAnalysisFormPlugin_4", (String)"tmc-tmbrm-report", (Object[])new Object[0]));
            return false;
        }
        String queryDateType = (String)this.getModel().getValue("filter_querydate");
        if (EmptyUtil.isEmpty((String)queryDateType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u65e5\u671f\u3002", (String)"CoDataAnalysisFormPlugin_3", (String)"tmc-tmbrm-report", (Object[])new Object[0]));
            return false;
        }
        if (QueryDateEnum.CUSTOM.getValue().equals(queryDateType) && !TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"filter_querydatestart", "filter_querydateend"})) {
            return false;
        }
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"filter_datarange", "filter_statcurrency", "filter_statdim", "filter_currencyunit"});
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject row : rowData) {
            boolean groupNode = row.getBoolean("isgroupnode");
            int sumLevel = row.getInt("sumlevel");
            if (sumLevel != 0 || groupNode) {
                this.setRatePropNullValue(row);
                continue;
            }
            row.getDataEntityType().getProperties().stream().filter(iDataEntityProperty -> iDataEntityProperty.getName().startsWith(RATE_FIELDS_PREFIX)).forEach(iDataEntityProperty -> {
                String propertyName = iDataEntityProperty.getName();
                String rateStr = row.getString(propertyName);
                BigDecimal percent = StringUtils.isEmpty((String)rateStr) ? BigDecimal.ZERO : row.getBigDecimal(propertyName);
                row.set(propertyName, (Object)(percent.setScale(2, RoundingMode.HALF_UP) + " %"));
            });
        }
    }

    private void setRatePropNullValue(DynamicObject row) {
        for (String rateProp : this.ratePropList) {
            if (!row.containsProperty(rateProp)) continue;
            row.set(rateProp, null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject finType;
        String name = evt.getProperty().getName();
        ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        if ("filter_finorg2".equals(name) && EmptyUtil.isNoEmpty((DynamicObject)(finType = (DynamicObject)this.getModel().getValue("filter_fintype")))) {
            QFilter qFilter = new QFilter("finorgtype.number", "=", (Object)finType.getString("number"));
            listFilterParameter.setFilter(qFilter);
        }
    }
}

