/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.report.form;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportTree;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.EvalReportStatusEnum;
import kd.tmc.tmbrm.common.enums.EvaluationDateEnum;

public class EvalResultQueryFormPlugin
extends AbstractReportFormPlugin
implements TreeNodeClickListener {
    public static final String EVAL_SCHEDULE_NAME = "evalschedule.name";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"filter_evalnametext"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("filter_evalnametext".equals(key)) {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"tmbrm_eval_report", (boolean)true);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            lsp.setCloseCallBack(closeCallBack);
            ListFilterParameter filterParameter = lsp.getListFilterParameter();
            QFilter qFilter = new QFilter("reportstatus", "=", (Object)EvalReportStatusEnum.CHECKED.getValue());
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.TMBRM.getValue(), (String)"tmbrm_evalresult_query", (String)"47150e89000000ac");
            qFilter.and("org", "in", (Object)orgIdList);
            filterParameter.setFilter(qFilter);
            String ids = this.getPageCache().get("filter_evalreportid");
            if (EmptyUtil.isNoEmpty((String)ids)) {
                lsp.setSelectedRows(SerializationUtils.fromJsonStringToList((String)ids, Long.class).toArray());
            }
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if ("filter_evalnametext".equals(event.getActionId())) {
            ListSelectedRowCollection selectedRowCol = (ListSelectedRowCollection)event.getReturnData();
            if (EmptyUtil.isEmpty((Collection)selectedRowCol)) {
                return;
            }
            List idList = selectedRowCol.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            DynamicObjectCollection evalReports = QueryServiceHelper.query((String)"tmbrm_eval_report", (String)EVAL_SCHEDULE_NAME, (QFilter[])new QFilter("id", "in", idList).toArray());
            String evalNames = evalReports.stream().map(e -> e.getString(EVAL_SCHEDULE_NAME)).collect(Collectors.joining(","));
            String billNos = selectedRowCol.stream().map(ListSelectedRow::getBillNo).collect(Collectors.joining(","));
            this.getModel().setValue("filter_evalnametext", (Object)evalNames);
            this.getPageCache().put("filter_evalreportbillno", billNos);
            this.getPageCache().put("filter_evalreportid", SerializationUtils.toJsonString(idList));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getCustomParam().put("filter_evalreportbillno", this.getPageCache().get("filter_evalreportbillno"));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String evalDate = (String)this.getModel().getValue("filter_evaldate");
        if (EvaluationDateEnum.CUSTOM.getValue().equals(evalDate)) {
            Date startDate = (Date)this.getModel().getValue("filter_daterange_startdate");
            Date endDate = (Date)this.getModel().getValue("filter_daterange_enddate");
            if (EmptyUtil.isEmpty((Object)startDate) || EmptyUtil.isEmpty((Object)endDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u65e5\u671f\u8303\u56f4\u3002", (String)"EvalResultQueryFormPlugin_1", (String)"tmc-tmbrm-report", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void initialize() {
        ReportTree reportTree = (ReportTree)this.getControl("reporttreeap");
        reportTree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        List columns = event.getColumns();
        ReportColumn reportColumn = (ReportColumn)columns.get(2);
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setForeColor("orange");
        reportColumn.setStyle(columnStyle);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        Object nodeId = evt.getNodeId();
        QFilter qFilter = new QFilter("billno", "=", nodeId);
        DynamicObject evalReport = QueryServiceHelper.queryOne((String)"tmbrm_eval_report", (String)"org.name org, evalschedule.evalproposal.name evalproposal,evalschedule.evaldate evaldate, evalschedule.fromdate evalformdate,evalschedule.todate evaltodate", (QFilter[])qFilter.toArray());
        Label label = (Label)this.getControl("labelap");
        if (evalReport != null) {
            String orgName = evalReport.getString("org");
            String proposalName = evalReport.getString("evalproposal");
            String evalDate = DateUtils.formatString((Date)evalReport.getDate("evaldate"), (String)"yyyy-MM-dd");
            String evalFromDate = DateUtils.formatString((Date)evalReport.getDate("evalformdate"), (String)"yyyy-MM-dd");
            String evalToDate = DateUtils.formatString((Date)evalReport.getDate("evaltodate"), (String)"yyyy-MM-dd");
            label.setText(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s | \u8bc4\u4ef7\u65b9\u6848\uff1a%2$s | \u8bc4\u4ef7\u65e5\u671f\uff1a%3$s | \u8bc4\u4ef7\u671f\u95f4\u4ece\uff1a%4$s | \u8bc4\u4ef7\u671f\u95f4\u81f3\uff1a%5$s", (String)"EvalResultQueryFormPlugin_0", (String)"tmc-tmbrm-report", (Object[])new Object[0]), orgName, proposalName, evalDate, evalFromDate, evalToDate));
        } else {
            ReportTree reportTree = (ReportTree)this.getControl("reporttreeap");
            TreeNode rootNode = reportTree.getTreeNode(String.valueOf(nodeId));
            if (EmptyUtil.isEmpty((Collection)rootNode.getChildren())) {
                label.setText(null);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("filter_evalnametext".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            if (EmptyUtil.isNoEmpty((Object)oldValue) && EmptyUtil.isEmpty((Object)newValue)) {
                this.getPageCache().remove("filter_evalreportbillno");
                this.getPageCache().remove("filter_evalreportid");
            }
        }
    }
}

