/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class AttachmentHelper {
    private static final Log logger = LogFactory.getLog(AttachmentHelper.class);
    private static final String ATTA_ENTITY = "bos_attachment";

    public static void copyAttachmentByAttNumber(String sourceBillName, long sourceBillId, String sourceAttachPanel, String targetBillName, long targetBillId, String targetAttachPanel, List<String> attNumbers) {
        QFilter numberFilter = new QFilter("fnumber", "in", attNumbers);
        List<QFilter> filters = AttachmentHelper.getFilters(sourceBillName, sourceBillId, sourceAttachPanel);
        filters.add(numberFilter);
        AttachmentHelper.copyAttachmentByFilters(targetBillName, targetBillId, targetAttachPanel, filters);
    }

    public static DynamicObjectCollection getAttachements(String billName, long billId, String attachPanel, String selelctField) {
        return QueryServiceHelper.query((String)ATTA_ENTITY, (String)selelctField, (QFilter[])AttachmentHelper.getFilters(billName, billId, attachPanel).toArray(new QFilter[0]));
    }

    public static void deleteAttachements(String billName, long billId, String attachPanel) {
        DeleteServiceHelper.delete((String)ATTA_ENTITY, (QFilter[])AttachmentHelper.getFilters(billName, billId, attachPanel).toArray(new QFilter[0]));
    }

    public static void copyAttachment(String sourceBillName, long sourceBillId, String sourceAttachPanel, String targetBillName, long targetBillId, String targetAttachPanel) {
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("FInterID", "=", (Object)String.valueOf(sourceBillId)), new QFilter("FBillType", "=", (Object)sourceBillName), new QFilter("fattachmentpanel", "=", (Object)sourceAttachPanel)};
        String selectFileds = "fattachmentname,fnumber,fextname,fattachmentsize,fdescription,FFileId";
        DynamicObjectCollection attachments = QueryServiceHelper.query((String)ATTA_ENTITY, (String)selectFileds, (QFilter[])filters);
        int fInterIDIdx = 0;
        int fBillTypeIdx = 1;
        int fattachmentpanelIdx = 2;
        logger.info("@@copyAttachment\u8fc7\u6ee4\u6761\u4ef6:" + filters[fInterIDIdx] + "&" + filters[fBillTypeIdx] + "&" + filters[fattachmentpanelIdx] + "\u67e5\u8be2\u5230\u9644\u4ef6" + attachments.size() + "\u4e2a");
        ArrayList<DynamicObject> attchList = new ArrayList<DynamicObject>(attachments.size());
        long[] ids = orm.genLongIds(ATTA_ENTITY, attachments.size());
        int index = 0;
        for (DynamicObject attach : attachments) {
            String name = (String)attach.get("fattachmentname");
            DynamicObject dynamicObject = TmcDataServiceHelper.newDynamicObject((String)ATTA_ENTITY);
            dynamicObject.set("id", (Object)ids[index++]);
            dynamicObject.set("FNUMBER", attach.get("fnumber"));
            dynamicObject.set("FBillType", (Object)targetBillName);
            dynamicObject.set("FInterID", (Object)String.valueOf(targetBillId));
            Date today = new Date();
            dynamicObject.set("FModifyTime", (Object)today);
            dynamicObject.set("fcreatetime", (Object)today);
            dynamicObject.set("FaliasFileName", (Object)name);
            logger.info("@@\u9644\u4ef6\u540d\u79f0:" + name);
            dynamicObject.set("FAttachmentName", (Object)name);
            dynamicObject.set("FExtName", attach.get("fextname"));
            dynamicObject.set("FATTACHMENTSIZE", attach.get("fattachmentsize"));
            dynamicObject.set("FCREATEMEN", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("fattachmentpanel", (Object)targetAttachPanel);
            dynamicObject.set("fdescription", attach.get("fdescription"));
            dynamicObject.set("FFileId", attach.get("FFileId"));
            attchList.add(dynamicObject);
        }
        if (attchList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])attchList.toArray(new DynamicObject[0]));
        }
    }

    public static List<QFilter> getFilters(String sourceBillName, long sourceBillId, String sourceAttachPanel) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("FInterID", "=", (Object)String.valueOf(sourceBillId)));
        qFilters.add(new QFilter("FBillType", "=", (Object)sourceBillName));
        qFilters.add(new QFilter("fattachmentpanel", "=", (Object)sourceAttachPanel));
        return qFilters;
    }

    public static void copyAttachmentByFilters(String targetBillName, long targetBillId, String targetAttachPanel, List<QFilter> filters) {
        logger.info("@@copyAttachmentByFilters:" + filters);
        ORM orm = ORM.create();
        String selectFileds = "fattachmentname,fnumber,fextname,fattachmentsize,fdescription,FFileId";
        DynamicObjectCollection attachments = QueryServiceHelper.query((String)ATTA_ENTITY, (String)selectFileds, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<DynamicObject> attchList = new ArrayList<DynamicObject>(attachments.size());
        long[] ids = orm.genLongIds(ATTA_ENTITY, attachments.size());
        int index = 0;
        for (DynamicObject attach : attachments) {
            String name = (String)attach.get("fattachmentname");
            DynamicObject dynamicObject = TmcDataServiceHelper.newDynamicObject((String)ATTA_ENTITY);
            dynamicObject.set("id", (Object)ids[index++]);
            dynamicObject.set("FNUMBER", attach.get("fnumber"));
            dynamicObject.set("FBillType", (Object)targetBillName);
            dynamicObject.set("FInterID", (Object)String.valueOf(targetBillId));
            Date today = new Date();
            dynamicObject.set("FModifyTime", (Object)today);
            dynamicObject.set("fcreatetime", (Object)today);
            dynamicObject.set("FaliasFileName", (Object)name);
            dynamicObject.set("FAttachmentName", (Object)name);
            logger.info("@@\u9644\u4ef6\u540d\u79f0:" + name);
            dynamicObject.set("FExtName", attach.get("fextname"));
            dynamicObject.set("FATTACHMENTSIZE", attach.get("fattachmentsize"));
            dynamicObject.set("FCREATEMEN", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("fattachmentpanel", (Object)targetAttachPanel);
            dynamicObject.set("fdescription", attach.get("fdescription"));
            dynamicObject.set("FFileId", attach.get("FFileId"));
            attchList.add(dynamicObject);
        }
        if (attchList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])attchList.toArray(new DynamicObject[0]));
        }
    }
}

