/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.common.helper;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.tmbrm.common.enums.BankEvalWayEnum;
import kd.tmc.tmbrm.common.enums.EvalReportStatusEnum;
import kd.tmc.tmbrm.common.model.EvalInfoModel;

public class EvalInfoHelper {
    public static List<EvalInfoModel> getEvalInfos(Long finOrgId, String finOrgType) {
        QFilter qFilter = new QFilter("resultentry.result_finorg", "=", (Object)finOrgId);
        if ("bd_bankcgsetting".equals(finOrgType)) {
            qFilter.and("evalschedule.evalway", "=", (Object)BankEvalWayEnum.HEAD.getValue());
        }
        qFilter.and("reportstatus", "=", (Object)EvalReportStatusEnum.CHECKED.getValue());
        DynamicObjectCollection evalReports = QueryServiceHelper.query((String)"tmbrm_eval_report", (String)"id,org,org.name orgname,billno,actualdate,checktime,evalschedule.fromdate fromdate,evalschedule.todate todate,evalschedule.evaldate evaldate,evalschedule.name evalname,evalschedule.evalperiod evalperiod,resultentry.result_finorg evalfinorg,resultentry.resultevalpoint evalscore, evalschedule.evalproposal evalproposal, evalschedule.evaltype.name evaltype", (QFilter[])qFilter.toArray(), (String)"checktime desc");
        ArrayList<EvalInfoModel> evalInfoList = new ArrayList<EvalInfoModel>(10);
        for (DynamicObject evalReport : evalReports) {
            EvalInfoModel evalInfoModel = EvalInfoHelper.transReport(evalReport);
            evalInfoList.add(evalInfoModel);
        }
        QFilter accessFilter = new QFilter("banksetting", "=", (Object)finOrgId);
        accessFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        accessFilter.and("accesstype.access", "=", (Object)"1");
        if ("bd_bankcgsetting".equals(finOrgType)) {
            accessFilter.and("bankevalway", "=", (Object)"B");
        }
        DynamicObjectCollection accessApplys = QueryServiceHelper.query((String)"tmbrm_access_apply", (String)"id,billno,evaluateorg,evaluateorg.name orgname,evalproposal,evaluatedate,auditdate,evalscore", (QFilter[])accessFilter.toArray());
        for (DynamicObject accessApply : accessApplys) {
            EvalInfoModel evalInfoModel = EvalInfoHelper.transAccesApply(accessApply);
            evalInfoList.add(evalInfoModel);
        }
        return evalInfoList.stream().sorted(Comparator.comparing(EvalInfoModel::getCheckTime, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
    }

    public static void batchFillEntry(String entryName, IDataModel model, List<EvalInfoModel> evalInfoList) {
        for (EvalInfoModel evalInfo : evalInfoList) {
            int row = model.createNewEntryRow(entryName);
            model.setValue("evalname", (Object)evalInfo.getEvalName(), row);
            model.setValue("evalscore", (Object)evalInfo.getEvalSocre(), row);
            model.setValue("reportbillno", (Object)evalInfo.getBillNo(), row);
            model.setValue("evalorg", (Object)evalInfo.getOrgId(), row);
            model.setValue("reportid", (Object)evalInfo.getBillId(), row);
            model.setValue("actualdate", (Object)evalInfo.getActualDate(), row);
            model.setValue("checktime", (Object)evalInfo.getCheckTime(), row);
            model.setValue("evalfromdate", (Object)evalInfo.getEvalFromDate(), row);
            model.setValue("evaltodate", (Object)evalInfo.getEvalToDate(), row);
            model.setValue("evaldate", (Object)evalInfo.getEvalDate(), row);
            model.setValue("evalproposal", (Object)evalInfo.getProposalId(), row);
            model.setValue("evaltype", (Object)evalInfo.getEvalType(), row);
            model.setValue("evalperiod", (Object)evalInfo.getEvalPeriod(), row);
            model.setValue("evalbilltype", (Object)evalInfo.getBillType(), row);
        }
    }

    private static EvalInfoModel transReport(DynamicObject evalReport) {
        EvalInfoModel evalInfoModel = new EvalInfoModel();
        evalInfoModel.setEvalName(evalReport.getString("evalname"));
        evalInfoModel.setEvalSocre(evalReport.getBigDecimal("evalscore"));
        evalInfoModel.setOrgName(evalReport.getString("orgname"));
        evalInfoModel.setBillNo(evalReport.getString("billno"));
        evalInfoModel.setOrgId(evalReport.getLong("org"));
        evalInfoModel.setBillId(String.valueOf(evalReport.getLong("id")));
        evalInfoModel.setEvalDate(evalReport.getDate("evaldate"));
        evalInfoModel.setEvalFromDate(evalReport.getDate("fromdate"));
        evalInfoModel.setEvalToDate(evalReport.getDate("todate"));
        evalInfoModel.setCheckTime(evalReport.getDate("checktime"));
        evalInfoModel.setActualDate(evalReport.getDate("actualdate"));
        evalInfoModel.setEvalPeriod(evalReport.getString("evalperiod"));
        evalInfoModel.setEvalType(evalReport.getString("evaltype"));
        evalInfoModel.setProposalId(evalReport.getLong("evalproposal"));
        evalInfoModel.setBillType("tmbrm_eval_report");
        return evalInfoModel;
    }

    private static EvalInfoModel transAccesApply(DynamicObject accessApply) {
        EvalInfoModel evalInfoModel = new EvalInfoModel();
        String localeStr = ResManager.loadKDString((String)"\u51c6\u5165\u8bc4\u4ef7", (String)"EvalInfoHelper_0", (String)"tmc-tmbrm-common", (Object[])new Object[0]);
        evalInfoModel.setEvalName(localeStr);
        evalInfoModel.setEvalType(localeStr);
        evalInfoModel.setOrgName(accessApply.getString("orgname"));
        evalInfoModel.setEvalSocre(accessApply.getBigDecimal("evalscore"));
        evalInfoModel.setBillNo(accessApply.getString("billno"));
        evalInfoModel.setOrgId(accessApply.getLong("evaluateorg"));
        evalInfoModel.setBillId(String.valueOf(accessApply.getLong("id")));
        evalInfoModel.setProposalId(accessApply.getLong("evalproposal"));
        evalInfoModel.setActualDate(accessApply.getDate("evaluatedate"));
        evalInfoModel.setCheckTime(accessApply.getDate("auditdate"));
        evalInfoModel.setEvalDate(accessApply.getDate("evaluatedate"));
        evalInfoModel.setBillType("tmbrm_access_apply");
        return evalInfoModel;
    }
}

