/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.sdk.tmc.tmbrm.extpoint.IEvaluationAutoScoreService;
import kd.sdk.tmc.tmbrm.extpoint.bean.AutoScoreReq;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.EvalMethodEnum;
import kd.tmc.tmbrm.common.enums.ScoreWayEnum;
import kd.tmc.tmbrm.common.helper.EvalTaskHelper;
import org.apache.commons.lang3.StringUtils;

public class EvalTaskAutoScoreHelper {
    private static final Log logger = LogFactory.getLog(EvalTaskAutoScoreHelper.class);
    private static final BigDecimal DEFAULT_SCORE = new BigDecimal("0.0");

    public static void autoScore(DynamicObject taskBill) {
        DynamicObject schedule = taskBill.getDynamicObject("schedule");
        DynamicObject proposal = schedule.getDynamicObject("evalproposal");
        DynamicObjectCollection itemList = EvalTaskHelper.getProposalItemEntry(proposal.getLong("id"));
        Map<Object, DynamicObject> itemMap = EvalTaskHelper.getEvalItemsByIds(itemList);
        int len = itemList.size();
        DynamicObjectCollection entryEntity = taskBill.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < len; ++i) {
            DynamicObject item = ((DynamicObject)itemList.get(i)).getDynamicObject("item");
            item = itemMap.get(item.getPkValue());
            String evaMethod = item.getString("evamethod");
            if (!EvalMethodEnum.AUTO.getValue().equals(evaMethod)) continue;
            DynamicObject autoScoreScheme = EvalTaskAutoScoreHelper.getAutoScoreScheme(item.getDynamicObject("autoscorescheme").getLong("id"));
            int idx = 0;
            for (DynamicObject entry : entryEntity) {
                DynamicObject finOrg = entry.getDynamicObject("finorg");
                String scoreWay = autoScoreScheme.getString("scoreway");
                BigDecimal score = new BigDecimal("0.0");
                if (EmptyUtil.isNoEmpty((DynamicObject)finOrg)) {
                    if (ScoreWayEnum.CONDITION.getValue().equals(scoreWay)) {
                        DynamicObject valueBill = autoScoreScheme.getDynamicObject("valuebill");
                        String entityKey = valueBill.getString("number");
                        String prop = autoScoreScheme.getString("valuefield");
                        DynamicObject archivesBill = EvalTaskAutoScoreHelper.getAutoScoreBill(entityKey, finOrg.getLong("id"), prop);
                        if (EmptyUtil.isNoEmpty((DynamicObject)archivesBill)) {
                            DynamicObjectCollection conditionEntry = autoScoreScheme.getDynamicObjectCollection("conditionentry");
                            score = EvalTaskAutoScoreHelper.getConditionValue(entityKey, prop, conditionEntry, archivesBill);
                        }
                    } else {
                        String autoScorePlugin = autoScoreScheme.getString("plugin");
                        score = EvalTaskAutoScoreHelper.getAutoScoreByPlugin(autoScorePlugin, finOrg.getLong("id"), taskBill.getDynamicObject("org").getLong("id"), schedule, taskBill.getString("finorgtype"));
                    }
                }
                entry.set("item" + i, (Object)score);
                EvalTaskAutoScoreHelper.calculateScore(taskBill, idx, itemList);
                EvalTaskAutoScoreHelper.setRowDetailScore(taskBill, idx, itemList);
                ++idx;
            }
        }
    }

    public static BigDecimal getAutoScoreByPlugin(String plugin, Long finOrgId, Long orgId, DynamicObject schedule, String finOrgType) {
        Class pluginClass = TypesContainer.getOrRegister((String)plugin.trim());
        try {
            IEvaluationAutoScoreService autoScoreService = (IEvaluationAutoScoreService)pluginClass.newInstance();
            AutoScoreReq req = EvalTaskAutoScoreHelper.createAutoScoreReq(finOrgId, orgId, schedule, finOrgType);
            return autoScoreService.autoScore(req);
        }
        catch (Exception e) {
            logger.error("\u81ea\u52a8\u8bc4\u5206\u63d2\u4ef6\u53d6\u503c\u9519\u8bef\uff1a", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static void calculateScore(DynamicObject taskBill, int idx, DynamicObjectCollection itemList) {
        DynamicObject row = (DynamicObject)taskBill.getDynamicObjectCollection("entryentity").get(idx);
        BigDecimal total = BigDecimal.ZERO;
        for (int i = 0; i < itemList.size(); ++i) {
            DynamicObject item = (DynamicObject)itemList.get(i);
            boolean isdeduct = item.getDynamicObject("item").getBoolean("isdeduct");
            BigDecimal sign = isdeduct ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
            total = total.add(sign.multiply(row.getBigDecimal("item" + i)).multiply(item.getBigDecimal("weight")).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        }
        row.set("totalscore", (Object)total);
    }

    private static void setRowDetailScore(DynamicObject taskBill, int idx, DynamicObjectCollection itemList) {
        DynamicObject row = (DynamicObject)taskBill.getDynamicObjectCollection("entryentity").get(idx);
        int itemSize = itemList.size();
        ArrayList<String> scoreList = new ArrayList<String>(itemSize);
        for (int i = 0; i < itemSize; ++i) {
            BigDecimal score = row.getBigDecimal("item" + i);
            scoreList.add(score.toString());
        }
        row.set("detailscore_tag", (Object)StringUtils.join(scoreList, (String)","));
    }

    public static DynamicObject getAutoScoreScheme(long autoSchemeId) {
        return TmcDataServiceHelper.loadSingleFromCache((Object)autoSchemeId, (String)"tmbrm_autoscore_proposal");
    }

    public static DynamicObject getAutoScoreBill(String entity, long archiveId, String prop) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("finorg", "=", (Object)archiveId);
        return TmcDataServiceHelper.loadSingle((String)entity, (String)prop, (QFilter[])filter.toArray());
    }

    public static BigDecimal getConditionValue(String entityKey, String prop, DynamicObjectCollection conditionEntry, DynamicObject archiveBill) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        IDataEntityProperty property = entityType.findProperty(prop);
        if (property instanceof ComboProp) {
            String srcBillPropValue = archiveBill.getString(prop);
            return EvalTaskAutoScoreHelper.getConditionStringValue(conditionEntry, srcBillPropValue);
        }
        if (property instanceof BooleanProp) {
            boolean booleanValue = archiveBill.getBoolean(prop);
            String srcBillPropValue = booleanValue ? "1" : "0";
            return EvalTaskAutoScoreHelper.getConditionStringValue(conditionEntry, srcBillPropValue);
        }
        if (property instanceof BasedataProp) {
            DynamicObject baseDataValue = archiveBill.getDynamicObject(prop);
            return EvalTaskAutoScoreHelper.getConditionBaseDataValue(conditionEntry, baseDataValue.getLong("id"));
        }
        return DEFAULT_SCORE;
    }

    private static BigDecimal getConditionStringValue(DynamicObjectCollection conditionEntry, String srcBillPropValue) {
        for (DynamicObject entry : conditionEntry) {
            String entryValue = entry.getString("conditionvalue");
            if (!entryValue.equals(srcBillPropValue)) continue;
            return entry.getBigDecimal("score");
        }
        return DEFAULT_SCORE;
    }

    private static BigDecimal getConditionBaseDataValue(DynamicObjectCollection conditionEntry, Long baseDataId) {
        for (DynamicObject entry : conditionEntry) {
            String entryValue = entry.getString("conditionbdid");
            if (!entryValue.equals(String.valueOf(baseDataId))) continue;
            return entry.getBigDecimal("score");
        }
        return DEFAULT_SCORE;
    }

    public static AutoScoreReq createAutoScoreReq(Long finOrgId, Long orgId, DynamicObject schdule, String finOrgType) {
        AutoScoreReq req = new AutoScoreReq();
        req.setOrgId(orgId);
        req.setFinOrgId(finOrgId);
        req.setFinOrgType(finOrgType);
        req.setFromDate(schdule.getDate("fromdate"));
        req.setToDate(schdule.getDate("todate"));
        return req;
    }
}

