/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.common.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.tmc.tmbrm.extpoint.IEvaluationRefData;
import kd.sdk.tmc.tmbrm.extpoint.bean.RefDataRequest;
import kd.tmc.fbp.common.helper.EvalRefDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class EvaluationAssistanceHelper {
    private static final Log logger = LogFactory.getLog(EvaluationAssistanceHelper.class);

    public static Map<String, String> getRefDataMap(Map<String, Object> customParam) {
        String finOrgType = (String)customParam.get("finorgtype");
        String finOrgs = (String)customParam.get("finorg");
        Long scheduleId = Long.parseLong(customParam.get("schedule").toString());
        Long orgId = Long.parseLong(customParam.get("org").toString());
        Long itemId = Long.parseLong(customParam.get("evaluateitem").toString());
        DynamicObject schedule = TmcDataServiceHelper.loadSingleFromCache((Object)scheduleId, (String)"tmbrm_eval_schedule");
        DynamicObject item = TmcDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"tmbrm_evaluationitem");
        DynamicObjectCollection itemRefList = item.getDynamicObjectCollection("refentry");
        int refSize = itemRefList.size();
        HashMap<String, String> itemMap = new HashMap<String, String>(16);
        if (EmptyUtil.isNotBlank((CharSequence)finOrgs) && refSize > 0) {
            Long[] orgIds = (Long[])Arrays.stream(StringUtils.split((String)finOrgs, (String)",")).map(Long::parseLong).toArray(Long[]::new);
            List allOrgIds = EvalRefDataHelper.getAllSubOrgIds((Long)orgId);
            boolean isBank = "bd_bankcgsetting".equals(finOrgType);
            Map finOrgIdMap = EvalRefDataHelper.getAllFinOrgIds(Arrays.asList(orgIds), (boolean)isBank);
            HashMap<String, Object> extMap = new HashMap<String, Object>(16);
            extMap.put("allOrgIds", allOrgIds);
            extMap.put("finOrgIdMap", finOrgIdMap);
            for (DynamicObject itemRef : itemRefList) {
                RefDataRequest request = new RefDataRequest();
                request.setOrgId(orgId);
                request.setFinOrgType(finOrgType);
                request.setFinOrgIds(Arrays.asList(orgIds));
                DynamicObject refIndex = itemRef.getDynamicObject("refquota");
                request.setKey(refIndex.getString("number"));
                request.setFromDate(schedule.getDate("fromdate"));
                request.setToDate(schedule.getDate("todate"));
                request.setExtMap(extMap);
                try {
                    String refPlugin = refIndex.getString("refplugin").trim();
                    Class pluginClass = TypesContainer.getOrRegister((String)refPlugin);
                    IEvaluationRefData evaluationRefData = (IEvaluationRefData)pluginClass.newInstance();
                    List itemResults = evaluationRefData.getDataItemValue(request);
                    if (EmptyUtil.isEmpty((Collection)itemResults)) continue;
                    itemResults.forEach(e -> itemMap.put(e.getFinOrg() + "#" + e.getKey(), e.getData()));
                }
                catch (Exception e2) {
                    logger.error("\u53c2\u8003\u6307\u6807\u63d2\u4ef6\u53d6\u503c\u9519\u8bef\uff1a", (Throwable)e2);
                    throw new KDBizException(e2.getMessage());
                }
            }
        }
        return itemMap;
    }
}

