/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.DynamicObjectUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.FinOrgDateScopeEnum;
import kd.tmc.tmbrm.common.model.FinOrgDataItem;
import org.apache.commons.collections4.CollectionUtils;

public class FinOrgCoDataHelper {
    public static FinOrgDataItem initFinOrgData(DynamicObject finOrg, Long chinaId, Long viewId) {
        String finOrgType = finOrg.getDataEntityType().getName();
        DynamicObject coData = TmcDataServiceHelper.loadSingle((String)"tmbrm_finorg_codata", (QFilter[])new QFilter[]{new QFilter("finorgtype", "=", (Object)finOrgType), new QFilter("finorg", "=", finOrg.getPkValue())});
        if (EmptyUtil.isEmpty((DynamicObject)coData)) {
            coData = FinOrgCoDataHelper.newCoData(finOrg);
        } else {
            FinOrgCoDataHelper.cleanCOData(coData);
        }
        coData.set("orgview", (Object)viewId);
        boolean isBank = "bd_bankcgsetting".equals(finOrgType);
        Collection<Object> finOrgList = new ArrayList<Object>(10);
        if (isBank) {
            DynamicObject bank = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorgtype", (String)"id", (QFilter[])new QFilter("number", "=", (Object)FinOrgTypeEnum.BANK.getNumber()).toArray());
            finOrgList = TmcDataServiceHelper.loadFromCache((String)"bd_finorginfo", (String)"id,country", (QFilter[])new QFilter[]{new QFilter("finorgtype.id", "=", bank.getPkValue()), new QFilter("bank_cate.id", "=", finOrg.getPkValue())}).values();
        } else {
            finOrg = TmcDataServiceHelper.loadSingleFromCache((Object)finOrg.getPkValue(), (String)"bd_finorginfo", (String)"id,country");
            finOrgList.add(finOrg);
            Set<Object> orgIds = Collections.singleton(finOrg.getPkValue());
            while (!orgIds.isEmpty()) {
                Map objectMap = TmcDataServiceHelper.loadFromCache((String)"bd_finorginfo", (String)"id,country", (QFilter[])new QFilter("parent", "in", orgIds).toArray());
                orgIds = objectMap.keySet();
                finOrgList.addAll(objectMap.values());
            }
        }
        List<Long> domesticIds = finOrgList.stream().filter(t -> Objects.isNull(t.getDynamicObject("country")) || chinaId.equals(t.getDynamicObject("country").getLong("id"))).map(t -> t.getLong("id")).collect(Collectors.toList());
        List<Long> overseaIds = finOrgList.stream().filter(t -> Objects.nonNull(t.getDynamicObject("country")) && !chinaId.equals(t.getDynamicObject("country").getLong("id"))).map(t -> t.getLong("id")).collect(Collectors.toList());
        FinOrgDataItem dataItem = new FinOrgDataItem();
        dataItem.setCoData(coData);
        dataItem.setBank(isBank);
        dataItem.setFinOrg(finOrg);
        dataItem.setDomesticIds(domesticIds);
        dataItem.setOverseaIds(overseaIds);
        dataItem.setOrgViewId(viewId);
        return dataItem;
    }

    private static DynamicObject newCoData(DynamicObject finOrg) {
        DynamicObject coData = TmcDataServiceHelper.newDynamicObject((String)"tmbrm_finorg_codata");
        coData.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        coData.set("finorgtype", (Object)finOrg.getDataEntityType().getName());
        coData.set("finorg", finOrg.getPkValue());
        coData.set("datatime", (Object)new Date());
        coData.set("billno", (Object)CodeRuleHelper.generateNumber((String)"tmbrm_finorg_codata", (DynamicObject)coData, null, null));
        return coData;
    }

    private static void cleanCOData(DynamicObject coData) {
        coData.set("datatime", (Object)new Date());
        coData.set("totalaccount", (Object)0L);
        coData.set("domesticaccount", (Object)0L);
        coData.set("overseaaccount", (Object)0L);
        coData.set("dicrectaccount", (Object)0L);
        coData.getDynamicObjectCollection("depositentry").clear();
        coData.getDynamicObjectCollection("loanentry").clear();
        coData.getDynamicObjectCollection("creditentry").clear();
        coData.getDynamicObjectCollection("bondentry").clear();
        coData.getDynamicObjectCollection("settleentry").clear();
    }

    public static Long getChinaId() {
        String china = ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"FinOrgCoDataHelper_0", (String)"tmc-tmbrm-common", (Object[])new Object[0]);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)"001").or("name", "in", (Object)new String[]{"China", china})};
        return TmcDataServiceHelper.loadSingleFromCache((String)"bd_country", (String)"id", (QFilter[])filters).getLong("id");
    }

    public static boolean isChina(DynamicObject country) {
        return country != null && ("001".equals(country.getString("number")) || "China".equals(country.getString("name")) || ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"FinOrgCoDataHelper_0", (String)"tmc-tmbrm-common", (Object[])new Object[0]).equals(country.getString("name")));
    }

    public static Collection<Long> getAllBank(List<FinOrgDataItem> dataItems) {
        List domesticList = dataItems.stream().flatMap(t -> t.getDomesticIds().stream()).collect(Collectors.toList());
        List overSeaList = dataItems.stream().flatMap(t -> t.getOverseaIds().stream()).collect(Collectors.toList());
        return CollectionUtils.union(domesticList, overSeaList);
    }

    private static QFilter getDateBetween(String field, Date startTime, Date endTime) {
        QFilter filter = null;
        if (Objects.nonNull(startTime)) {
            filter = new QFilter(field, ">=", (Object)startTime);
        }
        if (Objects.nonNull(endTime)) {
            if (filter != null) {
                filter.and(field, "<", (Object)endTime);
            } else {
                filter = new QFilter(field, "<", (Object)endTime);
            }
        }
        return filter;
    }

    public static QFilter getDateFilter(String field, FinOrgDateScopeEnum dateScopeEnum, Date dataTime) {
        Date yearFirst = DateUtils.getYearFirst((int)DateUtils.getYear((Date)dataTime));
        Date lastYear = DateUtils.getLastYear((Date)yearFirst, (int)1);
        switch (dateScopeEnum) {
            case YEAR: {
                return FinOrgCoDataHelper.getDateBetween(field, yearFirst, dataTime);
            }
            case LAST_YEAR: {
                return FinOrgCoDataHelper.getDateBetween(field, lastYear, yearFirst);
            }
            case YEAR_BEFORE_LAST: {
                return FinOrgCoDataHelper.getDateBetween(field, null, lastYear);
            }
        }
        return QFilter.isNotNull((String)field);
    }

    public static List<Object[]> getTdaDateListParam(Date date, FinOrgDateScopeEnum ... dateScopeEnums) {
        int year = DateUtils.getYear((Date)date);
        int lastYear = year - 1;
        ArrayList<Object[]> resList = new ArrayList<Object[]>(dateScopeEnums.length * 2);
        block6: for (FinOrgDateScopeEnum scopeEnum : dateScopeEnums) {
            switch (scopeEnum) {
                case YEAR: {
                    resList.add(new Object[]{DateUtils.getYearFirst((int)year), date, scopeEnum.getValue()});
                    continue block6;
                }
                case LAST_YEAR: {
                    resList.add(new Object[]{DateUtils.getYearFirst((int)lastYear), DateUtils.getYearLast((int)lastYear), scopeEnum.getValue()});
                    continue block6;
                }
                case YEAR_BEFORE_LAST: {
                    FinOrgCoDataHelper.addYearBegin(2, DateUtils.getLastYear((Date)date, (int)2), resList, scopeEnum.getValue());
                    continue block6;
                }
                case CURRENT: {
                    resList.add(new Object[]{DateUtils.getYearFirst((int)year), date, scopeEnum.getValue()});
                    FinOrgCoDataHelper.addYearBegin(1, DateUtils.getLastYear((Date)date, (int)1), resList, scopeEnum.getValue());
                    continue block6;
                }
            }
        }
        return resList;
    }

    private static void addYearBegin(int fromYear, Date cur, List<Object[]> resList, String type) {
        for (int i = fromYear; i < 10; ++i) {
            int year = DateUtils.getYear((Date)cur);
            resList.add(new Object[]{DateUtils.getYearFirst((int)year), DateUtils.getYearLast((int)year), type});
            cur = DateUtils.getLastYear((Date)cur, (int)1);
        }
    }

    public static Object[] mergeArr(Object[] p, Object[] q, int startIndex) {
        int len = p.length;
        Object[] res = new Object[len];
        for (int i = 0; i < len; ++i) {
            res[i] = i < startIndex ? p[i] : FinOrgCoDataHelper.add(p[i], q[i]);
        }
        return res;
    }

    public static DynamicObject mergeList(List<DynamicObject> list, String ... keys) {
        DynamicObject res = null;
        for (DynamicObject cur : list) {
            if (null == res) {
                res = new DynamicObject(cur.getDynamicObjectType());
                DynamicObjectUtil.copy((DynamicObject)cur, (DynamicObject)res, (String[])new String[0]);
                continue;
            }
            for (String key : keys) {
                res.set(key, FinOrgCoDataHelper.add(res.get(key), cur.get(key)));
            }
        }
        return res;
    }

    public static Object mergeColumn(DynamicObject object, String ... keys) {
        Object res = null;
        for (String key : keys) {
            res = null == res ? object.get(key) : FinOrgCoDataHelper.add(res, object.get(key));
        }
        return res;
    }

    public static <T> T add(T a, T b) {
        if (a instanceof BigDecimal) {
            return (T)((BigDecimal)a).add((BigDecimal)b);
        }
        if (a instanceof Long) {
            return (T)Long.valueOf((Long)a + (Long)b);
        }
        if (a instanceof Integer) {
            return (T)Integer.valueOf((Integer)a + (Integer)b);
        }
        return a;
    }

    public static <T> T addMulti(T ... a) {
        Object p = null;
        for (T q : a) {
            p = null == p ? q : FinOrgCoDataHelper.add(p, q);
        }
        return p;
    }

    public static String rateToString(BigDecimal amount, BigDecimal div) {
        if (BigDecimal.ZERO.compareTo(div) == 0) {
            return "0%";
        }
        return BigDecimal.valueOf(100L).multiply(amount).divide(div, 2, RoundingMode.HALF_UP) + "%";
    }

    public static String[] calcFieldExpress(String[] fields) {
        return (String[])Arrays.stream(fields).map(t -> t + "/" + "100000000").toArray(String[]::new);
    }
}

