/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmbrmAmountHelper {
    public static DataSet dealAmountConvert(DataSet ds, Map<String, Object> paramMap, List<String> amountFields, String currencyField, Date queryDate) {
        DataSet exchangeRateSet = TmbrmAmountHelper.getExChangeRateDs(ds, paramMap, currencyField, queryDate);
        String[] selectFields = TmbrmAmountHelper.initSelectFields(ds, amountFields);
        return ds.leftJoin(exchangeRateSet).on(currencyField, "tarcurrency").select(selectFields).finish();
    }

    private static DataSet getExChangeRateDs(DataSet dataSet, Map<String, Object> paramMap, String currencyField, Date queryDate) {
        Long tarCurrencyId = (Long)((DynamicObject)paramMap.get("filter_statcurrency")).getPkValue();
        DataSet currencySet = dataSet.copy().groupBy(new String[]{currencyField}).finish();
        ArrayList currencyIdList = new ArrayList(10);
        currencySet.iterator().forEachRemaining(v -> currencyIdList.add(v.getLong(currencyField)));
        long orgId = 0L;
        String queryWay = (String)paramMap.get("filter_queryway");
        boolean orgQueryWay = ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay);
        if (orgQueryWay) {
            orgId = RequestContext.get().getOrgId();
        } else {
            DynamicObject orgView = (DynamicObject)paramMap.get("filter_orgview");
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgId = Long.parseLong(Objects.requireNonNull(TmcOrgDataHelper.getOrgRootId((Long)orgView.getLong("id"))));
            }
        }
        if (orgId != 0L) {
            return TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)tarCurrencyId, (long)orgId, (Date)queryDate, (boolean)orgQueryWay);
        }
        String[] fieldNames = new String[]{"tarcurrency", "rate"};
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.BigDecimalType};
        return TmbrmAmountHelper.createEmptyDataSet(fieldNames, dataTypes);
    }

    private static String[] initSelectFields(DataSet bizDataSet, List<String> amountFields) {
        String[] oralfields = bizDataSet.getRowMeta().getFieldNames();
        ArrayList<String> fieldList = new ArrayList<String>(oralfields.length);
        for (String field : oralfields) {
            if (fieldList.contains(field) || amountFields.contains(field)) continue;
            fieldList.add(field);
        }
        for (String field : amountFields) {
            fieldList.add(field + " * rate " + field);
        }
        fieldList.add("tarcurrency");
        fieldList.add("rate");
        return fieldList.toArray(new String[0]);
    }

    public static DataSet createEmptyDataSet(String[] fieldNames, DataType[] dataTypes) {
        RowMeta rowMeta = new RowMeta(fieldNames, dataTypes);
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
    }
}

