/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.common.constants.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class QueryObject {
    private int count;
    private List<Map<String, Object>> headers;
    private List<Object> rows;

    public void setCount(int count) {
        this.count = count;
    }

    public void setHeaders(List<Map<String, Object>> headers) {
        this.headers = headers;
    }

    public void setRows(List<Object> rows) {
        this.rows = rows;
    }

    public int getCount() {
        return this.count;
    }

    public List<Map<String, Object>> getHeaders() {
        return this.headers;
    }

    public List<Object> getRows() {
        return this.rows;
    }

    public void setHeaders(RowMeta rowMeta) {
        ArrayList headers = Lists.newArrayListWithCapacity((int)rowMeta.getFieldCount());
        for (Field field : rowMeta.getFields()) {
            LinkedHashMap fieldMap = Maps.newLinkedHashMapWithExpectedSize((int)3);
            fieldMap.put("name", field.getName());
            fieldMap.put("type", field.getDataType().getSql());
            headers.add(fieldMap);
        }
        this.setHeaders(headers);
    }

    public void setRows(DataSet dataSet, int size) {
        ArrayList rows = Lists.newArrayListWithCapacity((int)Math.max(size, 0));
        Field[] fields = dataSet.getRowMeta().getFields();
        for (Row row : dataSet) {
            LinkedHashMap rowMap = Maps.newLinkedHashMapWithExpectedSize((int)fields.length);
            for (Field field : fields) {
                rowMap.put(field.getName(), row.get(field.getName()));
            }
            rows.add(rowMap);
        }
        this.setRows(rows);
    }

    public Map<String, Object> toMap() {
        HashMap queryRetMap = Maps.newHashMapWithExpectedSize((int)3);
        queryRetMap.put("count", this.count);
        if (this.headers != null) {
            queryRetMap.put("headers", this.headers);
        }
        queryRetMap.put("rows", this.rows);
        return queryRetMap;
    }
}

