/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.common.entity.intv.calendar;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import org.apache.commons.collections.CollectionUtils;

public class IntvCalendar
implements Serializable {
    private static final long serialVersionUID = 2958780227438648013L;
    private long startTimeLong;
    private String taskId;
    private long endTimeLong;
    private String formAbstract;
    private String intvTitle;
    private String intvStartHourAndMinute;
    private String interviewMethodName;
    private Long interviewMethodId;
    private String intvAddress;
    private String intvRoom;
    private String candidateName;
    private List<String> candidates;
    private String intvTaskStatus;

    public IntvCalendar() {
    }

    public IntvCalendar(DynamicObject intvTask) {
        DynamicObject firstAppfile;
        DynamicObjectCollection groupCandates;
        this.taskId = String.valueOf(intvTask.getLong("id"));
        this.intvTitle = this.ofNullable(intvTask, "argintv", "interviewtitle");
        Date interviewDate = (Date)this.ofNullableOther(intvTask, "intvgroup", "intvdate");
        long interviewTime = ((Integer)this.ofNullableOther(intvTask, "intvgroup", "intvstarttime")).intValue();
        long interviewEndTime = ((Integer)this.ofNullableOther(intvTask, "intvgroup", "intvendtime")).intValue();
        Date intvDateTime = IntvDateUtil.getIntvDateTime(interviewDate, interviewTime);
        Date intvDateEndTime = IntvDateUtil.getIntvDateTime(interviewDate, interviewEndTime);
        this.startTimeLong = intvDateTime.getTime();
        this.endTimeLong = intvDateEndTime.getTime();
        this.intvStartHourAndMinute = IntvDateUtil.getIntvDate(intvDateTime, "HH:mm");
        DynamicObject intvMethod = (DynamicObject)this.ofNullableOther(intvTask, "round", "interviewmethod");
        long methodId = intvMethod.getLong("id");
        this.interviewMethodId = methodId;
        this.interviewMethodName = intvMethod.getString("name");
        if (1010L == methodId) {
            HRBaseServiceHelper intvgrouptplHelper = new HRBaseServiceHelper("tsirm_intvgrouptpl");
            DynamicObject intvGroupObj = intvgrouptplHelper.queryOne((Object)intvTask.getLong("intvgroup.id"));
            DynamicObject addressDetail = intvGroupObj.getDynamicObject("addressdetail");
            if (!Objects.isNull(addressDetail)) {
                this.intvAddress = addressDetail.getString("name");
            }
            this.intvRoom = this.ofNullable(intvTask, "intvgroup", "interviewroom");
        }
        if (1040L == methodId) {
            this.intvAddress = this.ofNullable(intvTask, "intvgroup", "intvervedioaddress");
        }
        if (CollectionUtils.isNotEmpty((Collection)(groupCandates = intvTask.getDynamicObject("intvgroup").getDynamicObjectCollection("groupcandate"))) && !Objects.isNull((firstAppfile = (DynamicObject)groupCandates.get(0)).getDynamicObject("fbasedataid"))) {
            String groupCandate = firstAppfile.getDynamicObject("fbasedataid").getString("name");
            ArrayList candateLists = Lists.newArrayListWithCapacity((int)groupCandates.size());
            for (DynamicObject candate : groupCandates) {
                candateLists.add(candate.getDynamicObject("fbasedataid").getString("name"));
            }
            this.candidates = candateLists;
            this.candidateName = groupCandates.size() == 1 ? groupCandate : ResManager.loadKDString((String)"{0}\u7b49{1}\u4f4d", (String)"IntvCalendar_0", (String)"tsc-tsirm-common", (Object[])new Object[]{groupCandate, groupCandates.size()});
        }
        this.intvTaskStatus = this.ofNullable(intvTask, "taskstatus");
    }

    private String ofNullable(DynamicObject intvTask, String property) {
        if (HRObjectUtils.isEmpty((Object)intvTask) || HRStringUtils.isEmpty((String)intvTask.getString(property))) {
            return "";
        }
        return intvTask.getString(property);
    }

    private String ofNullable(DynamicObject intvTask, String type, String property) {
        if (HRObjectUtils.isEmpty((Object)intvTask) || HRObjectUtils.isEmpty((Object)intvTask.getDynamicObject(type)) || Objects.isNull(intvTask.getDynamicObject(type).get(property))) {
            return "";
        }
        return intvTask.getDynamicObject(type).getString(property);
    }

    private Object ofNullableOther(DynamicObject intvTask, String type, String property) {
        if (HRObjectUtils.isEmpty((Object)intvTask) || HRObjectUtils.isEmpty((Object)intvTask.getDynamicObject(type)) || HRStringUtils.isEmpty((String)intvTask.getDynamicObject(type).getString(property))) {
            return "";
        }
        return intvTask.getDynamicObject(type).get(property);
    }

    public long getStartTimeLong() {
        return this.startTimeLong;
    }

    public void setStartTimeLong(long startTimeLong) {
        this.startTimeLong = startTimeLong;
    }

    public String getFormAbstract() {
        return this.formAbstract;
    }

    public void setFormAbstract(String formAbstract) {
        this.formAbstract = formAbstract;
    }

    public String getIntvTitle() {
        return this.intvTitle;
    }

    public void setIntvTitle(String intvTitle) {
        this.intvTitle = intvTitle;
    }

    public String getIntvStartHourAndMinute() {
        return this.intvStartHourAndMinute;
    }

    public void setIntvStartHourAndMinute(String intvStartHourAndMinute) {
        this.intvStartHourAndMinute = intvStartHourAndMinute;
    }

    public String getIntvAddress() {
        return this.intvAddress;
    }

    public void setIntvAddress(String intvAddress) {
        this.intvAddress = intvAddress;
    }

    public String getIntvRoom() {
        return this.intvRoom;
    }

    public void setIntvRoom(String intvRoom) {
        this.intvRoom = intvRoom;
    }

    public String getCandidateName() {
        return this.candidateName;
    }

    public void setCandidateName(String candidateName) {
        this.candidateName = candidateName;
    }

    public String getIntvTaskStatus() {
        return this.intvTaskStatus;
    }

    public void setIntvTaskStatus(String intvTaskStatus) {
        this.intvTaskStatus = intvTaskStatus;
    }

    public String getInterviewMethodName() {
        return this.interviewMethodName;
    }

    public void setInterviewMethodName(String interviewMethodName) {
        this.interviewMethodName = interviewMethodName;
    }

    public Long getInterviewMethodId() {
        return this.interviewMethodId;
    }

    public void setInterviewMethodId(Long interviewMethodId) {
        this.interviewMethodId = interviewMethodId;
    }

    public List<String> getCandidates() {
        return this.candidates;
    }

    public void setCandidates(List<String> candidates) {
        this.candidates = candidates;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public long getEndTimeLong() {
        return this.endTimeLong;
    }

    public void setEndTimeLong(long endTimeLong) {
        this.endTimeLong = endTimeLong;
    }
}

