/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.common.enums.advert;

import java.util.Arrays;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.constants.ChannelConstants;
import org.apache.commons.lang3.ArrayUtils;

public enum ChannelFieldEnum {
    INTRECO(ChannelConstants.INTRECO_CHANNEL_ID, new String[]{"istop", "isurgent", "reward", "reqorg", "startdate", "enddate", "rewardruledesc", "rewardrule", "rewardpoint", "isreward", "rewardcurrency", "adminorgsdpt"}),
    ALL(-1L, ChannelFieldEnum.concatAll(INTRECO.getFields(), new String[][]{{"rewardamountflex"}}));

    private Long channelId;
    private String[] fields;

    private ChannelFieldEnum(Long channelId, String[] fields) {
        this.channelId = channelId;
        this.fields = fields;
    }

    public Long getChannelId() {
        return this.channelId;
    }

    public String[] getFields() {
        return this.fields;
    }

    public static String[] getFieldsByChannel(long channelId) {
        ChannelFieldEnum[] values;
        for (ChannelFieldEnum val : values = ChannelFieldEnum.values()) {
            if (val.channelId != channelId) continue;
            return val.fields;
        }
        return null;
    }

    public static boolean isAutoPubAndClose(long channelId) {
        Object[] fields = ChannelFieldEnum.getFieldsByChannel(channelId);
        return ArrayUtils.isNotEmpty((Object[])fields) && ArrayUtils.contains((Object[])fields, (Object)"startdate") && ArrayUtils.contains((Object[])fields, (Object)"enddate");
    }

    public static boolean isPublicForDetail(String fieldName) {
        return HRStringUtils.equals((String)fieldName, (String)"startdate") || HRStringUtils.equals((String)fieldName, (String)"enddate");
    }

    private static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }
}

