/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class ContextUrlUtil {
    private static final Log log = LogFactory.getLog(ContextUrlUtil.class);

    public static String getContextUrl() {
        String tenantCodeString = "{tenantCode}";
        String contextUrl = System.getProperty("domain.contextUrl");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{contextUrl})) {
            try {
                String decode = URLDecoder.decode(contextUrl, "utf-8");
                if (decode.contains(tenantCodeString)) {
                    return decode.replace(tenantCodeString, RequestContext.get().getTenantCode());
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error("getContextUrl error ", (Throwable)e);
            }
            log.info("url is {}", (Object)contextUrl);
            return contextUrl.endsWith("/") ? contextUrl.substring(0, contextUrl.length() - 1) : contextUrl;
        }
        log.warn(" mc domain.contextUrl is empty ,please configure");
        return "";
    }
}

