/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.common.util;

import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.field.ComboEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.common.utils.CacheUtils;
import org.apache.commons.lang3.ObjectUtils;

public class FormShowUtils {
    private static final Log LOGGER = LogFactory.getLog(FormShowUtils.class);

    public static void showSlideBill(IFormView view, String showFormId, Map<String, String> paramMap) {
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Map<String, Object> map = FormShowUtils.paramHandle(showFormId, paramMap);
        proxy.addAction("setSlideBillFormId", map);
        proxy.addAction("showSlideBill", map);
    }

    public static void showViewBill(IFormView view, String showFormId, Map<String, String> paramMap) {
        FormShowUtils.paramHandle(showFormId, paramMap);
        FormShowParameter showParameter = new FormShowParameter();
        OpenStyle openStyle = showParameter.getOpenStyle();
        showParameter.setFormId(showFormId);
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.Modal));
        view.showForm(showParameter);
    }

    private static Map<String, Object> paramHandle(String showFormId, Map<String, String> paramMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("formId", showFormId);
        if (MapUtils.isNotEmpty(paramMap)) {
            DistributeSessionlessCache cache = CacheUtils.getDistributeSessionlessCache();
            String count = (String)cache.get("count".concat(RequestContext.get().getGlobalSessionId()));
            if (HRStringUtils.isEmpty((String)count)) {
                count = String.valueOf(1);
            } else {
                int newCount = Integer.parseInt(count);
                count = String.valueOf(++newCount);
            }
            cache.put("count".concat(RequestContext.get().getGlobalSessionId()), (Object)count);
            String finalCount = count;
            paramMap.forEach((key, value) -> cache.put(key.concat(RequestContext.get().getGlobalSessionId()).concat(finalCount), value));
        }
        return map;
    }

    public static FormShowParameter setFormShow(Container flexPanel, String flexKey, String formId) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(flexKey);
        flexPanel.deleteControls(new String[]{flexKey});
        flexPanel.addControls(Collections.singletonList(flex.createControl()));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(flex.getKey());
        return showParameter;
    }

    public static FormShowParameter setFlexFormShow(Container flexPanel, String flexKey, String formId) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(flexKey);
        flex.setGrow(0);
        flexPanel.deleteControls(new String[]{flexKey});
        flexPanel.addControls(Collections.singletonList(flex.createControl()));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(flex.getKey());
        return showParameter;
    }

    public static FormShowParameter setFlexFormShow(Container flexPanel, String flexKey, String formId, int index) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(flexKey);
        flexPanel.deleteControls(new String[]{flexKey});
        flexPanel.addControls(Collections.singletonList(flex.createControl()));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(flex.getKey());
        showParameter.setCustomParam("index", (Object)index);
        return showParameter;
    }

    public static FormShowParameter setFlexFormShowInteRverAnswer(Container flexPanel, String flexKey, String formId, int index, Object group) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(flexKey);
        flexPanel.deleteControls(new String[]{flexKey});
        flexPanel.addControls(Collections.singletonList(flex.createControl()));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(flex.getKey());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("index", index);
        paramMap.put("group", group);
        showParameter.setCustomParams(paramMap);
        return showParameter;
    }

    public static void showPersonalCenter(String tabKey, String pageId, Map<String, Object> customParams, IFormView view) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setFormId("tsirm_personalcenter");
        if (ObjectUtils.isEmpty(customParams)) {
            customParams = new HashMap<String, Object>(16);
            customParams.put("activetab", tabKey);
        }
        fsp.setPageId(pageId);
        fsp.setCustomParams(customParams);
        view.showForm(fsp);
    }

    private FormShowUtils() {
    }

    public static Map<String, String> getComboValueMap(IFormView formView, String key) {
        LOGGER.info("start getComboValueMap");
        HashMap<String, String> comboPropValueMap = new HashMap<String, String>(16);
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        Map controlMetaState = clientViewProxy.getControlMetaState(key);
        if (!ObjectUtils.isEmpty((Object)controlMetaState) && controlMetaState.containsKey("st")) {
            Object metaState = controlMetaState.get("st");
            ArrayList viewStateList = (ArrayList)metaState;
            for (Object comboItem : viewStateList) {
                if (!(comboItem instanceof List)) continue;
                String value = null;
                String name = "";
                for (Object comboContent : (List)comboItem) {
                    if (comboContent instanceof String) {
                        value = (String)comboContent;
                        continue;
                    }
                    if (!(comboContent instanceof Map)) continue;
                    name = ((Map)comboContent).get(RequestContext.get().getLang().name());
                }
                if (!HRStringUtils.isNotEmpty(value)) continue;
                comboPropValueMap.put(value, name == null ? "" : name.toString());
            }
        } else {
            ComboEdit comboEdit = (ComboEdit)formView.getControl(key);
            List comboItems = ((ComboProp)comboEdit.getProperty()).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                comboPropValueMap.put(comboItem.getValue(), comboItem.getName().getLocaleValue());
            }
        }
        LOGGER.info("end getComboValueMap");
        return comboPropValueMap;
    }
}

