/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.common.util;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.common.entity.IntvFatherParam;
import kd.tsc.tsirm.common.entity.IntvGroupParam;
import kd.tsc.tsirm.common.entity.intv.IntvUnifyTimeParam;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class IntvBatchUtil {
    public static final String UNIFYINTVTIME = "unifyintvtime";
    public static final String UNIFYDURATION = "unifyduration";
    public static final String HALFTIME = "halftime";
    public static final String HALFBEGINTIME = "halfbegintime";
    public static final String HALFENDTIME = "halfendtime";
    public static final String UNIFYINTVER = "unifyintver";
    public static final String UNIFYINTVERHR = "unifyintverhr";
    public static final String UNIFYADMINDIVISIONID = "unifyadmindivisionid";
    public static final String UNIFYINTERVIEWADDRESS = "unifyinterviewaddress";
    public static final String UNIFYINTERVIEWROOM = "unifyinterviewroom";
    public static final String ADMINDIVISIONFIELD = "admindivision";
    public static final String INTERVIEWADDRESS = "interviewlocation";
    public static final String INTERVIEWROOM = "interviewroom";
    public static final int SECONDS_PER_MINUTE = 60;
    public static final String INTVDATETIME = "intvdatetime";
    public static final String INTVSTARTTIME = "intvstarttime";
    public static final String INTVENDTIME = "intvendtime";
    public static final String GROUPDURATION = "groupduration";
    public static final String GROUPNAME = "groupname";
    public static final String USERNAME = "username";
    public static final String CLICK_BUTTON_ASSIGN_DATA_FLAG = "clickButtonAssignDataFlag";
    public static final String UNIFYADDRESSDETAIL = "unifyaddressdetail";

    public static void assignData(IDataModel model, DynamicObject dynamicObject, int index, IntvGroupParam intvGroupParam, Date groupTrueDate) {
        if (!HRObjectUtils.isEmpty((Object)dynamicObject.getDynamicObjectCollection(UNIFYINTVER))) {
            model.setValue("intver", (Object)dynamicObject.getDynamicObjectCollection(UNIFYINTVER), index);
        } else {
            model.setValue("intver", null, index);
        }
        if (!HRObjectUtils.isEmpty((Object)dynamicObject.getDynamicObjectCollection(UNIFYINTVERHR))) {
            model.setValue("intverhr", (Object)dynamicObject.getDynamicObjectCollection(UNIFYINTVERHR), index);
        } else {
            model.setValue("intverhr", null, index);
        }
        if (HRStringUtils.isNotEmpty((String)dynamicObject.getString(UNIFYADMINDIVISIONID))) {
            model.setValue(ADMINDIVISIONFIELD, (Object)dynamicObject.getString(UNIFYADMINDIVISIONID), index);
        } else {
            model.setValue(ADMINDIVISIONFIELD, null, index);
        }
        if (HRStringUtils.isNotEmpty((String)dynamicObject.getString(UNIFYINTERVIEWADDRESS))) {
            model.setValue(INTERVIEWADDRESS, (Object)dynamicObject.getString(UNIFYINTERVIEWADDRESS), index);
        } else {
            model.setValue(INTERVIEWADDRESS, null, index);
        }
        if (HRStringUtils.isNotEmpty((String)dynamicObject.getString(UNIFYINTERVIEWROOM))) {
            model.setValue(INTERVIEWROOM, (Object)dynamicObject.getString(UNIFYINTERVIEWROOM), index);
        } else {
            model.setValue(INTERVIEWROOM, null, index);
        }
        if (!HRObjectUtils.isEmpty((Object)dynamicObject.getDate(UNIFYINTVTIME)) && !HRObjectUtils.isEmpty((Object)dynamicObject.getInt(UNIFYDURATION))) {
            model.setValue(INTVDATETIME, (Object)groupTrueDate, index);
        } else {
            model.setValue(INTVDATETIME, null, index);
        }
        if (HRStringUtils.isNotEmpty((String)dynamicObject.getString(UNIFYDURATION))) {
            model.setValue(GROUPDURATION, (Object)dynamicObject.getString(UNIFYDURATION), index);
        } else {
            model.setValue(GROUPDURATION, null, index);
        }
        if (dynamicObject.getDynamicObject(UNIFYADDRESSDETAIL) != null) {
            model.setValue("addressdetail", (Object)dynamicObject.getDynamicObject(UNIFYADDRESSDETAIL), index);
        } else {
            model.setValue("addressdetail", null, index);
        }
    }

    public static LocalDateTime getGroupDate(LocalDateTime currBeginTime, int duration, int halfBegin, int halfEnd, IntvUnifyTimeParam intvUnifyTimeParam) {
        if (Objects.isNull(currBeginTime)) {
            return null;
        }
        int halfSeconds = 86400 - (halfEnd - halfBegin);
        int durationSeconds = duration * 60;
        if (halfSeconds < durationSeconds) {
            boolean noArrange = intvUnifyTimeParam.isNoArrange();
            if (!noArrange) {
                IFormView view = intvUnifyTimeParam.getView();
                IFormView mainView = intvUnifyTimeParam.getView().getParentView();
                mainView.showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u5b89\u6392\u9762\u8bd5\u65f6\u95f4\uff0c\u9762\u8bd5\u5f00\u59cb\u65f6\u95f4\u7edf\u4e00\u8bbe\u7f6e\u4e3a{0}", (String)"IntvBatchUtil_0", (String)"tsc-tsirm-common", (Object[])new Object[]{currBeginTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"))}));
                view.sendFormAction(mainView);
                intvUnifyTimeParam.setNoArrange(true);
            }
            return currBeginTime;
        }
        LocalDateTime plusDurationTime = currBeginTime.plusMinutes(duration);
        int beginSeconds = DateUtils.getSecondsOfDay((LocalDateTime)currBeginTime);
        int endSeconds = DateUtils.getSecondsOfDay((LocalDateTime)plusDurationTime);
        if (endSeconds > halfBegin && endSeconds <= halfEnd || beginSeconds < halfEnd && beginSeconds > halfBegin || halfBegin > beginSeconds && halfBegin < endSeconds || halfEnd > beginSeconds && halfEnd < endSeconds) {
            currBeginTime = currBeginTime.withMinute(0).withSecond(0).withHour(0).plusSeconds(halfEnd);
        }
        return currBeginTime;
    }

    public static void assignFatherData(DynamicObject newGroup, DynamicObject dynamicObject, Date date, int index, IntvGroupParam intvGroupParam) {
        IntvFatherParam intvFatherParam = IntvBatchUtil.getIntvFatherParam(date, dynamicObject.getInt(UNIFYINTVTIME), dynamicObject.getInt(UNIFYDURATION) * 60, dynamicObject.getInt(HALFBEGINTIME), dynamicObject.getInt(HALFENDTIME), index, intvGroupParam);
        newGroup.set("intvdate", (Object)intvFatherParam.getfIntvdate());
        newGroup.set(INTVSTARTTIME, (Object)intvFatherParam.getfIntvStartTime());
        newGroup.set(INTVENDTIME, (Object)intvFatherParam.getfIntvEndTime());
    }

    public static Date getGroupIntvDate(Date intvDate, int unifyDuration, int halfBeginTime, int halfEndTime, int xNum, IntvGroupParam intvGroupParam) {
        Date startDate = IntvDateUtil.getStartDate(intvDate);
        int diffDateNum = Math.toIntExact((intvDate.getTime() - startDate.getTime()) / 1000L);
        int index = diffDateNum + unifyDuration * xNum;
        int yNum = intvGroupParam.getY();
        int jNum = halfEndTime + unifyDuration * (xNum - yNum);
        if (diffDateNum + unifyDuration >= halfEndTime || index + unifyDuration <= halfBeginTime) {
            intvGroupParam.setY(++yNum);
            return HRDateTimeUtils.addSecond((Date)startDate, (long)index);
        }
        return HRDateTimeUtils.addSecond((Date)startDate, (long)jNum);
    }

    public static IntvFatherParam getIntvFatherParam(Date intvDate, int beginDate, int unifyDuration, int halfBeginTime, int halfEndTime, int xNum, IntvGroupParam intvGroupParam) {
        int index = beginDate + unifyDuration * xNum;
        int yNum = intvGroupParam.getY();
        int jNum = halfEndTime + unifyDuration * (xNum - yNum);
        if (index + unifyDuration < halfBeginTime) {
            intvGroupParam.setY(++yNum);
            Date date = HRDateTimeUtils.addSecond((Date)intvDate, (long)index);
            return IntvBatchUtil.getIntvFatherParam(intvDate, unifyDuration, date);
        }
        Date date = HRDateTimeUtils.addSecond((Date)intvDate, (long)jNum);
        return IntvBatchUtil.getIntvFatherParam(intvDate, unifyDuration, date);
    }

    public static IntvFatherParam getIntvFatherParam(Date intvDate, int unifyDuration, Date date) {
        LocalDateTime now = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalTime of = LocalTime.from(now);
        int fIntvStartTime = of.toSecondOfDay();
        int fIntvEndTime = of.toSecondOfDay() + unifyDuration;
        return new IntvFatherParam(intvDate, fIntvStartTime, fIntvEndTime);
    }

    public static boolean isNameAndClick(String name, String clickButtonAssignDataFlag) {
        return HRStringUtils.isEmpty((String)clickButtonAssignDataFlag) && (name.equals("intver") || name.equals("addressdetail") || name.equals(ADMINDIVISIONFIELD) || name.equals(INTERVIEWADDRESS) || name.equals(INTERVIEWROOM) || name.equals(INTVDATETIME) || name.equals(GROUPDURATION) || name.equals("intverhr"));
    }
}

