/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.common.util;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbs.common.enums.DayOfWeekEnum;
import org.apache.commons.lang3.StringUtils;

public class IntvDateUtil {
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_DATE_PATTERN_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final String TIME_PATTERN_1 = "HH:mm";
    public static final Integer MAX_SECOND_OF_DAY = 86399;
    public static final Integer TIME_NUM = 60000;
    public static final String INTVDATE = "intvdate";
    public static final String INTVSTARTTIME = "intvstarttime";
    public static final String INTVENDTIME = "intvendtime";

    public static LocalDateTime getLocalDateTime(Date interviewDate, Long interviewTime) {
        LocalDate localDate = interviewDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().toLocalDate();
        if (interviewTime > (long)MAX_SECOND_OF_DAY.intValue()) {
            long num = interviewTime / (long)(MAX_SECOND_OF_DAY + 1);
            long interviewTimeWithToday = interviewTime % (long)(MAX_SECOND_OF_DAY + 1);
            LocalTime localTime = LocalTime.ofSecondOfDay(interviewTimeWithToday);
            return LocalDateTime.of(localDate.plusDays(num), localTime);
        }
        LocalTime localTime = LocalTime.ofSecondOfDay(interviewTime);
        return LocalDateTime.of(localDate, localTime);
    }

    public static long getLongFromLocalDateTime(LocalDateTime intvDateTimeStart) {
        return intvDateTimeStart.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static long getLocalDateTimeOfLong(Date interviewDate, Long interviewTime) {
        return IntvDateUtil.getLongFromLocalDateTime(IntvDateUtil.getLocalDateTime(interviewDate, interviewTime));
    }

    public static Date getIntvDateTime(Date interviewDate, Long interviewTime) {
        LocalDateTime localDateTime = IntvDateUtil.getLocalDateTime(interviewDate, interviewTime);
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Boolean intvTimeIsBeforeNow(Date interviewDate, Long interviewTime) {
        return IntvDateUtil.getLocalDateTime(interviewDate, interviewTime).isBefore(LocalDateTime.now());
    }

    public static String getIntvDate(Date interviewDate) {
        return IntvDateUtil.getIntvDate(interviewDate, DEFAULT_DATE_PATTERN);
    }

    public static String getIntvDate(Date interviewDate, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(interviewDate);
    }

    public static LocalDateTime parseDateTimeStr(String dateTime, String pattern) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalTime parseSecondTime(Long time) {
        return LocalTime.ofSecondOfDay(time);
    }

    public static String formatTime(Long time, String pattern) {
        return IntvDateUtil.parseSecondTime(time).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static Date parseDateStr(String strDate, String pattern) {
        LocalDateTime localDateTime = LocalDateTime.parse(strDate, DateTimeFormatter.ofPattern(pattern));
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Date getStartDate(Date fromDate) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(fromDate.toInstant(), ZoneId.systemDefault());
        LocalDate localDate = LocalDate.from(localDateTime);
        Instant instant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static int getDiffDateNum(Date startDate, Date endDate) {
        LocalDateTime localDateTimeStart = LocalDateTime.ofInstant(startDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime localDateTimeEnd = LocalDateTime.ofInstant(endDate.toInstant(), ZoneId.systemDefault());
        LocalDate localDateStart = LocalDate.from(localDateTimeStart);
        LocalDate localDateEnd = LocalDate.from(localDateTimeEnd);
        return localDateEnd.compareTo(localDateStart);
    }

    public static int getDiffDateTimeNum(Date startDate, Date endDate) {
        LocalDateTime localDateTimeStart = LocalDateTime.ofInstant(startDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime localDateTimeEnd = LocalDateTime.ofInstant(endDate.toInstant(), ZoneId.systemDefault());
        return localDateTimeEnd.compareTo(localDateTimeStart);
    }

    public static void switchDateTime(DynamicObject fGroup, DynamicObject newGroup) {
        Date intvDateTime = fGroup.getDate("intvdatetime");
        if (Objects.isNull(intvDateTime)) {
            newGroup.set(INTVDATE, null);
            newGroup.set(INTVSTARTTIME, (Object)0);
            newGroup.set(INTVENDTIME, (Object)fGroup.getInt("groupduration"));
            return;
        }
        Date startDate = IntvDateUtil.getStartDate(intvDateTime);
        long startTime = (intvDateTime.getTime() - startDate.getTime()) / 1000L;
        String groupDuration = fGroup.getString("groupduration");
        if (StringUtils.isEmpty((CharSequence)groupDuration)) {
            groupDuration = "0";
        }
        long endTime = startTime + Long.parseLong(groupDuration) * 60L;
        newGroup.set(INTVDATE, (Object)startDate);
        newGroup.set(INTVSTARTTIME, (Object)startTime);
        newGroup.set(INTVENDTIME, (Object)endTime);
    }

    public static void overturnDateTime(DynamicObject newGroup, DynamicObject fGroup) {
        Date intvDate = newGroup.getDate(INTVDATE);
        int intvStartTime = newGroup.getInt(INTVSTARTTIME);
        int intvEndTime = newGroup.getInt(INTVENDTIME);
        String groupDuration = String.valueOf((intvEndTime - intvStartTime) / 60);
        Date startTime = HRDateTimeUtils.addSecond((Date)intvDate, (long)intvStartTime);
        fGroup.set("groupduration", (Object)groupDuration);
        fGroup.set("intvdatetime", (Object)startTime);
    }

    public static String parseDayOfWeek(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        String dayOfWeek = localDateTime.getDayOfWeek().name();
        return DayOfWeekEnum.getName((String)dayOfWeek);
    }

    public static String getDate2Str(String format, Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static String stampToTime(String stamp, String format) {
        String sd = "";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sd = sdf.format(new Date(Long.parseLong(stamp)));
        return sd;
    }

    public static String msgIntvDate(Date intvDateTime, String groupDuration) {
        Date startDate = IntvDateUtil.getStartDate(intvDateTime);
        long startTime = (intvDateTime.getTime() - startDate.getTime()) / 1000L;
        if (StringUtils.isEmpty((CharSequence)groupDuration)) {
            groupDuration = "0";
        }
        long endTime = startTime + Long.parseLong(groupDuration) * 60L;
        LocalDate localDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (endTime > (long)MAX_SECOND_OF_DAY.intValue()) {
            endTime -= (long)MAX_SECOND_OF_DAY.intValue();
        }
        LocalTime localTimeStart = LocalTime.ofSecondOfDay(startTime);
        LocalTime localTimeEnd = LocalTime.ofSecondOfDay(endTime);
        String strDate = localDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
        String strStartTime = localTimeStart.format(DateTimeFormatter.ofPattern(TIME_PATTERN_1));
        String strEndTime = localTimeEnd.format(DateTimeFormatter.ofPattern(TIME_PATTERN_1));
        int value = localDate.getDayOfWeek().getValue();
        if (localTimeStart.isAfter(localTimeEnd)) {
            String strEndDate = localDate.plusDays(1L).format(DateTimeFormatter.ISO_LOCAL_DATE);
            return String.format(ResManager.loadKDString((String)"%1$s %2$s\uff08%3$s\uff09 - %4$s %5$s", (String)"IntvDateUtil_0", (String)"tsc-tsirm-common", (Object[])new Object[0]), strDate, strStartTime, IntvDateUtil.weekDayCh(value), strEndDate, strEndTime);
        }
        return String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09 %3$s-%4$s", (String)"IntvDateUtil_1", (String)"tsc-tsirm-common", (Object[])new Object[0]), strDate, IntvDateUtil.weekDayCh(value), strStartTime, strEndTime);
    }

    public static String weekDayCh(int value) {
        String result;
        switch (value) {
            case 1: {
                result = ResManager.loadKDString((String)"\u5468\u4e00", (String)"IntvDateUtil_2", (String)"tsc-tsirm-common", (Object[])new Object[0]);
                break;
            }
            case 2: {
                result = ResManager.loadKDString((String)"\u5468\u4e8c", (String)"IntvDateUtil_3", (String)"tsc-tsirm-common", (Object[])new Object[0]);
                break;
            }
            case 3: {
                result = ResManager.loadKDString((String)"\u5468\u4e09", (String)"IntvDateUtil_4", (String)"tsc-tsirm-common", (Object[])new Object[0]);
                break;
            }
            case 4: {
                result = ResManager.loadKDString((String)"\u5468\u56db", (String)"IntvDateUtil_5", (String)"tsc-tsirm-common", (Object[])new Object[0]);
                break;
            }
            case 5: {
                result = ResManager.loadKDString((String)"\u5468\u4e94", (String)"IntvDateUtil_6", (String)"tsc-tsirm-common", (Object[])new Object[0]);
                break;
            }
            case 6: {
                result = ResManager.loadKDString((String)"\u5468\u516d", (String)"IntvDateUtil_7", (String)"tsc-tsirm-common", (Object[])new Object[0]);
                break;
            }
            default: {
                result = ResManager.loadKDString((String)"\u5468\u65e5", (String)"IntvDateUtil_8", (String)"tsc-tsirm-common", (Object[])new Object[0]);
            }
        }
        return result;
    }
}

