/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections.MapUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class IntvMailUtils {
    private static final Log log = LogFactory.getLog(IntvMailUtils.class);

    private IntvMailUtils() {
    }

    public static String getContextUrl() {
        String tenantCodeString = "{tenantCode}";
        String contextUrl = System.getProperty("domain.contextUrl");
        if (null == contextUrl) {
            return "email";
        }
        try {
            String decode = URLDecoder.decode(contextUrl, "utf-8");
            log.info("url decode is {}", (Object)decode);
            if (decode.contains(tenantCodeString)) {
                log.info("url decode param is {}", (Object)RequestContext.get().getTenantCode());
                return decode.replace(tenantCodeString, RequestContext.get().getTenantCode());
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("getContextUrl error ", (Throwable)e);
        }
        log.info("url is {}", (Object)contextUrl);
        return contextUrl.endsWith("/") ? contextUrl.substring(0, contextUrl.length() - 1) : contextUrl;
    }

    public static String getListUrl(String formId, Map<String, String> params) {
        return IntvMailUtils.getListUrl(formId, "bos_list", params);
    }

    public static String getListUrl(String formId) {
        return IntvMailUtils.getListUrl(formId, "bos_list");
    }

    public static String getListUrl(String formId, String listType, Map<String, String> params) {
        StringBuilder urlParam = new StringBuilder();
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((key, val) -> urlParam.append('&').append((String)key).append('=').append((String)val));
        }
        return String.format("%s/index.html?type=list&formId=%s&billFormId=%s", IntvMailUtils.getContextUrl(), listType, formId) + urlParam;
    }

    public static String getListUrl(String formId, String listType) {
        return String.format("%s/index.html?type=list&formId=%s&billFormId=%s", IntvMailUtils.getContextUrl(), listType, formId);
    }

    public static String getFormDetailUrl(String formId, String pkId) {
        return String.format("%s/index.html?accountId=%s&formId=%s&pkId=%s", IntvMailUtils.getContextUrl(), RequestContext.get().getAccountId(), formId, pkId);
    }

    public static String getFormDetailUrl(String formId, Map<String, String> params) {
        StringBuilder urlParam = new StringBuilder();
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((key, val) -> urlParam.append('&').append((String)key).append('=').append((String)val));
        }
        return String.format("%s/index.html?accountId=%s&formId=%s%s", IntvMailUtils.getContextUrl(), RequestContext.get().getAccountId(), formId, urlParam);
    }

    public static Document getCommonHtml() {
        return Jsoup.parse((String)"<!DOCTYPE html><html><head><title></title><style>a:link,a:visited{text-decoration:none;color:#5582F3}body{margin:2px 0px;line-height:140%;overflow-wrap:break-word}.emphasis_black{color:#000;font-weight:bold}.emphasis_blue{color:#5582F3;font-weight:bold}.emphasis_red{color:red;font-weight:bold}a.replay_a{float:right;height:32px;line-height:32px;background:#5582F3;border-radius:2px;display:block;text-decoration:none;font-size:14px;outline:none;color:white;width:88px;text-align:center}.float_right{float:right}.tbl_candidate{text-align:left;border:1px solid#CCCCCC;font-size:12px;margin:18px auto;width:100%}.interview_table{margin-top:12px}.tbl_candidate tr td{width:12.5%;border-right:1px solid#CCCCCC}</style></head><body><div style=\"font-size: 14px;width: 90%;color:#333333;border-radius: 8px;overflow: hidden;box-shadow: 2px 5px 14px 5px rgba(0, 0, 0, 0.1);margin: auto;\"><div id=\"business_type\"style=\"height:54px;background: linear-gradient(225deg, #55E2EE 0%, #437FEC 100%);line-height: 54px;padding-left:30px;font-size: 18px;color: #fff;font-weight: bold;\"></div><div style=\"padding: 20px 30px;background: #fff\"><div id='header'></div><div id='main_content'></div><div id='footer'></div></div></div></body></html>");
    }
}

