/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.common.util;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsirm.common.entity.intv.ableintvtime.TimePeriod;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class TimePeriodCalcUtils {
    public static final Log log = LogFactory.getLog(TimePeriodCalcUtils.class);

    public static List<TimePeriod> getTimePeriodListIntersection(List<TimePeriod> timePeriodsAll) {
        ArrayList<TimePeriod> timePeriodsSubtractList = new ArrayList<TimePeriod>();
        if (timePeriodsAll.size() == 1) {
            timePeriodsSubtractList.addAll(timePeriodsAll);
        }
        for (int i = 0; i < timePeriodsAll.size(); ++i) {
            TimePeriod timePeriodsA = timePeriodsAll.get(i);
            timePeriodsA.setFlag(true);
            for (int m = 0; m < timePeriodsAll.size(); ++m) {
                TimePeriod timePeriodsB = timePeriodsAll.get(m);
                if (timePeriodsB.isFlag()) continue;
                TimePeriod timeIntersection = TimePeriodCalcUtils.getTimePeriodIntersection(timePeriodsA, timePeriodsB);
                TimePeriodCalcUtils.addTimeList(timePeriodsSubtractList, timeIntersection);
            }
        }
        return timePeriodsSubtractList;
    }

    public static List<TimePeriod> getTimePeriodListIntersection(List<TimePeriod> timePeriodsAs, List<TimePeriod> timePeriodsBs) {
        ArrayList<TimePeriod> timePeriodsSubtract = new ArrayList<TimePeriod>();
        for (int i = 0; i < timePeriodsAs.size(); ++i) {
            TimePeriod timePeriodsA = timePeriodsAs.get(i);
            for (int m = 0; m < timePeriodsBs.size(); ++m) {
                TimePeriod timePeriodsB = timePeriodsBs.get(m);
                TimePeriod timeIntersection = TimePeriodCalcUtils.getTimePeriodIntersection(timePeriodsA, timePeriodsB);
                TimePeriodCalcUtils.addTimeList(timePeriodsSubtract, timeIntersection);
            }
        }
        return timePeriodsSubtract;
    }

    public static List<TimePeriod> getTimePeriodListSubtract(List<TimePeriod> timePeriodsAs, List<TimePeriod> timePeriodsBs) {
        ArrayList<TimePeriod> timePeriodsSubtract = new ArrayList<TimePeriod>();
        if (timePeriodsBs.size() == 0) {
            return timePeriodsAs;
        }
        if (timePeriodsAs.size() == 0) {
            return timePeriodsSubtract;
        }
        timePeriodsAs = TimePeriodCalcUtils.unionTimePeriod(timePeriodsAs);
        timePeriodsBs = TimePeriodCalcUtils.unionTimePeriod(timePeriodsBs);
        for (int i = 0; i < timePeriodsAs.size(); ++i) {
            TimePeriod timePeriodsAi = timePeriodsAs.get(i);
            TimePeriodCalcUtils.addTimeList(timePeriodsSubtract, TimePeriodCalcUtils.getTimePeriodSubtract(timePeriodsAi, timePeriodsBs));
        }
        return timePeriodsSubtract;
    }

    public static List<TimePeriod> getTimePeriodSubtract(TimePeriod timePeriod, List<TimePeriod> timePeriodList) {
        ArrayList<TimePeriod> resTimePeriod = new ArrayList<TimePeriod>();
        ArrayList<TimePeriod> timePeriodListMem = new ArrayList<TimePeriod>(timePeriodList);
        timePeriodList.sort(Comparator.comparing(TimePeriod::getStartTime));
        ArrayList<TimePeriod> resTimePeriodRemove = new ArrayList<TimePeriod>();
        for (int m = 0; m < timePeriodList.size(); ++m) {
            int type = TimePeriodCalcUtils.checkTimePeriodIntersection(timePeriod, timePeriodList.get(m));
            TimePeriod timePeriodm = timePeriodList.get(m);
            if (type == 0) {
                resTimePeriodRemove.add(timePeriodList.get(m));
            }
            if (type == 1 || type == 2) {
                timePeriod = TimePeriodCalcUtils.getTimePeriodSubtract(timePeriod, timePeriodm).get(0);
                resTimePeriodRemove.add(timePeriodList.get(m));
            }
            if (type == 3 && (timePeriod.getStartTime().toInstant().equals(timePeriodm.getStartTime().toInstant()) || timePeriod.getEndTime().toInstant().equals(timePeriodm.getEndTime().toInstant()))) {
                timePeriod = TimePeriodCalcUtils.getTimePeriodSubtract(timePeriod, timePeriodm).get(0);
                resTimePeriodRemove.add(timePeriodList.get(m));
            }
            if (type != 4 && type != 5) continue;
            return null;
        }
        timePeriodListMem.removeAll(resTimePeriodRemove);
        if (timePeriodListMem.size() == 0) {
            resTimePeriod.add(timePeriod);
        } else {
            resTimePeriod.addAll(TimePeriodCalcUtils.getTimePeriodSubtractAFullB(timePeriod, timePeriodListMem));
        }
        return resTimePeriod;
    }

    public static List<TimePeriod> getTimePeriodSubtractAFullB(TimePeriod timePeriod, List<TimePeriod> timePeriodList) {
        ArrayList<TimePeriod> resTimePeriod = new ArrayList<TimePeriod>(timePeriodList.size() + 1);
        TimePeriod subTimePeriodFirst = new TimePeriod();
        subTimePeriodFirst.setStartTime(timePeriod.getStartTime());
        subTimePeriodFirst.setEndTime(timePeriodList.get(0).getStartTime());
        resTimePeriod.add(subTimePeriodFirst);
        for (int m = 0; m < timePeriodList.size() - 1; ++m) {
            TimePeriod subTimePeriod = new TimePeriod();
            subTimePeriod.setStartTime(timePeriodList.get(m).getEndTime());
            subTimePeriod.setEndTime(timePeriodList.get(m + 1).getStartTime());
            resTimePeriod.add(subTimePeriod);
        }
        TimePeriod subTimePeriodEnd = new TimePeriod();
        subTimePeriodEnd.setStartTime(timePeriodList.get(timePeriodList.size() - 1).getEndTime());
        subTimePeriodEnd.setEndTime(timePeriod.getEndTime());
        resTimePeriod.add(subTimePeriodEnd);
        return resTimePeriod;
    }

    public static List<TimePeriod> getTimePeriodListSum(List<TimePeriod> timeListYs) {
        ArrayList<TimePeriod> res = new ArrayList<TimePeriod>();
        List<TimePeriod> timeListZ = TimePeriodCalcUtils.getTimePeriodListIntersection(timeListYs);
        if (timeListZ.size() > 0) {
            res.addAll(timeListZ);
        } else {
            res.addAll(timeListYs);
        }
        return res;
    }

    public static List<TimePeriod> addTimeList(List<TimePeriod> timeList, TimePeriod time) {
        if (time != null) {
            timeList.add(time);
        }
        return timeList;
    }

    public static List<TimePeriod> addTimeList(List<TimePeriod> timeListA, List<TimePeriod> timeListB) {
        if (timeListB != null && timeListB.size() > 0) {
            timeListB.removeAll(timeListA);
            timeListA.addAll(timeListB);
        }
        return timeListA;
    }

    private static boolean checkTimeListHaveTime(List<TimePeriod> timeList, TimePeriod time) {
        boolean res = false;
        for (int i = 0; i < timeList.size(); ++i) {
            if (!timeList.get(i).equals(time)) continue;
            res = true;
            break;
        }
        return res;
    }

    public static List<TimePeriod> getTimePeriodSubtract(TimePeriod timePeriodsA, TimePeriod timePeriodsB) {
        ArrayList<TimePeriod> timePeriodsSubtract = new ArrayList<TimePeriod>();
        int intersection = TimePeriodCalcUtils.checkTimePeriodIntersection(timePeriodsA, timePeriodsB);
        if (intersection == -1 || intersection == 5 || intersection == 4) {
            timePeriodsSubtract = null;
        } else if (intersection == 0) {
            timePeriodsSubtract.add(timePeriodsA);
        } else if (intersection == 1) {
            TimePeriod subtractTime = new TimePeriod();
            subtractTime.setStartTime(timePeriodsB.getEndTime());
            subtractTime.setEndTime(timePeriodsA.getEndTime());
            timePeriodsSubtract.add(subtractTime);
        } else if (intersection == 2) {
            TimePeriod subtractTime = new TimePeriod();
            subtractTime.setStartTime(timePeriodsA.getStartTime());
            subtractTime.setEndTime(timePeriodsB.getStartTime());
            timePeriodsSubtract.add(subtractTime);
        } else if (intersection == 3) {
            if (!timePeriodsA.getStartTime().toInstant().equals(timePeriodsB.getStartTime().toInstant())) {
                TimePeriod subtractTimeOne = new TimePeriod();
                subtractTimeOne.setStartTime(timePeriodsA.getStartTime());
                subtractTimeOne.setEndTime(timePeriodsB.getStartTime());
                timePeriodsSubtract.add(subtractTimeOne);
            }
            if (!timePeriodsA.getEndTime().toInstant().equals(timePeriodsB.getEndTime().toInstant())) {
                TimePeriod subtractTimeTwo = new TimePeriod();
                subtractTimeTwo.setStartTime(timePeriodsB.getEndTime());
                subtractTimeTwo.setEndTime(timePeriodsA.getEndTime());
                timePeriodsSubtract.add(subtractTimeTwo);
            }
        }
        return timePeriodsSubtract;
    }

    public static TimePeriod getTimePeriodIntersection(TimePeriod timePeriodsA, TimePeriod timePeriodsB) {
        TimePeriod timePeriodsIntersection = null;
        boolean checkInterSection = TimePeriodCalcUtils.checkIsTimePeriodIntersection(timePeriodsA, timePeriodsB);
        if (checkInterSection) {
            Date sectionStartTime = TimePeriodCalcUtils.getMaxOrMinDate(1, timePeriodsA.getStartTime(), timePeriodsB.getStartTime());
            Date sectionEndTime = TimePeriodCalcUtils.getMaxOrMinDate(-1, timePeriodsA.getEndTime(), timePeriodsB.getEndTime());
            timePeriodsIntersection = new TimePeriod();
            timePeriodsIntersection.setStartTime(sectionStartTime);
            timePeriodsIntersection.setEndTime(sectionEndTime);
        }
        return timePeriodsIntersection;
    }

    public static Date getMaxOrMinDate(int getType, Date dateA, Date dateB) {
        Date resDate = new Date();
        if (getType == 1) {
            resDate = dateA.compareTo(dateB) >= 0 ? dateA : dateB;
        } else if (getType == -1) {
            resDate = dateA.compareTo(dateB) >= 0 ? dateB : dateA;
        }
        return resDate;
    }

    public static int checkTimePeriodIntersection(TimePeriod timePeriodsA, TimePeriod timePeriodsB) {
        boolean checkA = TimePeriodCalcUtils.checkTimePeriod(timePeriodsA);
        boolean checkB = TimePeriodCalcUtils.checkTimePeriod(timePeriodsB);
        if (!checkA || !checkB) {
            return -1;
        }
        boolean checkIntersection = TimePeriodCalcUtils.checkIsTimePeriodIntersection(timePeriodsA, timePeriodsB);
        if (!checkIntersection) {
            return 0;
        }
        Date aStartDate = timePeriodsA.getStartTime();
        Date aEndDate = timePeriodsA.getEndTime();
        Date bStartDate = timePeriodsB.getStartTime();
        Date bEndDate = timePeriodsB.getEndTime();
        if (aStartDate.compareTo(bStartDate) == 0 && aEndDate.compareTo(bEndDate) == 0) {
            return 5;
        }
        if (aStartDate.compareTo(bStartDate) <= 0 && aEndDate.compareTo(bEndDate) >= 0) {
            return 3;
        }
        if (bStartDate.compareTo(aStartDate) <= 0 && bEndDate.compareTo(aEndDate) >= 0) {
            return 4;
        }
        if (aStartDate.compareTo(bStartDate) > 0 && aStartDate.compareTo(bEndDate) < 0) {
            return 1;
        }
        if (bStartDate.compareTo(aStartDate) > 0 && bStartDate.compareTo(aEndDate) < 0) {
            return 2;
        }
        log.info("checkTimePeriodsIntersection not covered timePeriodsA :{},timePeriodsB {}", (Object)timePeriodsA.toString(), (Object)timePeriodsB.toString());
        return 6;
    }

    public static boolean checkIsTimePeriodIntersection(TimePeriod timePeriodsA, TimePeriod timePeriodsB) {
        boolean checkResult = false;
        boolean checkA = TimePeriodCalcUtils.checkTimePeriod(timePeriodsA);
        boolean checkB = TimePeriodCalcUtils.checkTimePeriod(timePeriodsB);
        if (!checkA || !checkB) {
            return false;
        }
        Date aStartDate = timePeriodsA.getStartTime();
        Date aEndDate = timePeriodsA.getEndTime();
        Date bStartDate = timePeriodsB.getStartTime();
        Date bEndDate = timePeriodsB.getEndTime();
        if (aStartDate.compareTo(bStartDate) == 0 && aEndDate.compareTo(bEndDate) == 0) {
            checkResult = true;
        }
        if (aStartDate.compareTo(bStartDate) > 0 && aStartDate.compareTo(bEndDate) < 0) {
            checkResult = true;
        }
        if (bStartDate.compareTo(aStartDate) > 0 && bStartDate.compareTo(aEndDate) < 0) {
            checkResult = true;
        }
        if (aStartDate.compareTo(bStartDate) <= 0 && aEndDate.compareTo(bEndDate) >= 0) {
            checkResult = true;
        }
        if (bStartDate.compareTo(aStartDate) <= 0 && bEndDate.compareTo(aEndDate) >= 0) {
            checkResult = true;
        }
        return checkResult;
    }

    public static boolean checkTimePeriod(TimePeriod timePeriods) {
        boolean checkResult = false;
        if (timePeriods == null) {
            return checkResult;
        }
        if (timePeriods.getStartTime() == null || timePeriods.getEndTime() == null) {
            return checkResult;
        }
        if (timePeriods.getEndTime().compareTo(timePeriods.getStartTime()) > 0) {
            checkResult = true;
        }
        return checkResult;
    }

    public static List<TimePeriod> unionTimePeriod(List<TimePeriod> paramList) {
        ArrayList<TimePeriod> unionPeriodList = new ArrayList<TimePeriod>();
        paramList.sort(Comparator.comparing(TimePeriod::getStartTime));
        TimePeriod timePeriod = null;
        boolean complate = true;
        for (TimePeriod ableInterviewTimePeriod : paramList) {
            if (complate && Objects.isNull(timePeriod)) {
                complate = false;
                timePeriod = ableInterviewTimePeriod;
                continue;
            }
            if (TimePeriodCalcUtils.hasIntersection(timePeriod, ableInterviewTimePeriod)) {
                timePeriod = TimePeriodCalcUtils.unionPeriod(timePeriod, ableInterviewTimePeriod);
                continue;
            }
            unionPeriodList.add(timePeriod);
            timePeriod = ableInterviewTimePeriod;
            complate = true;
        }
        if (!Objects.isNull(timePeriod)) {
            unionPeriodList.add(timePeriod);
        }
        return unionPeriodList;
    }

    public static List<TimePeriod> unionTimePeriod(List<TimePeriod> paramListA, List<TimePeriod> paramListB) {
        paramListA.addAll(paramListB);
        return TimePeriodCalcUtils.unionTimePeriod(paramListA);
    }

    public static TimePeriod unionPeriod(TimePeriod aPeriod, TimePeriod bPeriod) {
        LocalDateTime aBegin = DateUtils.getLocalDateTimeByDate((Date)aPeriod.getStartTime());
        LocalDateTime aEnd = DateUtils.getLocalDateTimeByDate((Date)aPeriod.getEndTime());
        LocalDateTime bBegin = DateUtils.getLocalDateTimeByDate((Date)bPeriod.getStartTime());
        LocalDateTime bEnd = DateUtils.getLocalDateTimeByDate((Date)bPeriod.getEndTime());
        TimePeriod timePeriod = new TimePeriod();
        timePeriod.setStartTime(DateUtils.getDateByLocalDateTime((LocalDateTime)TimePeriodCalcUtils.getMin(aBegin, bBegin)));
        timePeriod.setEndTime(DateUtils.getDateByLocalDateTime((LocalDateTime)TimePeriodCalcUtils.getMax(aEnd, bEnd)));
        return timePeriod;
    }

    public static boolean hasIntersection(TimePeriod aPeriod, TimePeriod bPeriod) {
        if (Objects.isNull(aPeriod) || Objects.isNull(bPeriod)) {
            return false;
        }
        LocalDateTime aBegin = DateUtils.getLocalDateTimeByDate((Date)aPeriod.getStartTime());
        LocalDateTime aEnd = DateUtils.getLocalDateTimeByDate((Date)aPeriod.getEndTime());
        LocalDateTime bBegin = DateUtils.getLocalDateTimeByDate((Date)bPeriod.getStartTime());
        LocalDateTime bEnd = DateUtils.getLocalDateTimeByDate((Date)bPeriod.getEndTime());
        return !(!aBegin.isBefore(bEnd) && !aBegin.equals(bEnd) || !aEnd.isAfter(bBegin) && !aEnd.equals(bBegin));
    }

    public static LocalDateTime getMax(LocalDateTime time1, LocalDateTime time2) {
        if (time1.isAfter(time2)) {
            return time1;
        }
        return time2;
    }

    public static LocalDateTime getMin(LocalDateTime time1, LocalDateTime time2) {
        if (time1.isBefore(time2)) {
            return time1;
        }
        return time2;
    }
}

