/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.mobile.intvsignin;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.intvsignin.IntvGroupCandidateHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvsignin.IntvMethodHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvsignin.IntvPositionHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvsignin.SignInStatusHelper;

public class CandidateInputInfoPlugin
extends AbstractFormPlugin {
    public static final String TELEPHONEFIELD = "telephonefield";
    public static final String SHOWPHONE = "showphone";
    public static final String RE_BUTTONAP = "rebuttonap";
    public static final String SIGNINPHONEFLEX = "signinphoneflex";
    public static final String SUCCESSFLEX = "successflex";
    public static final String FAILFLEX = "failflex";
    public static final String POSITIONNAME = "positionname";
    public static final String INTVTIME = "intvtime";
    public static final String INTVSITE = "intvsite";
    public static final String PHONEERROR = "phoneerror";
    public static final String PHONE_NULL = "";
    public static final String STR = "-";
    public static final String PHONE_RULE = "(\\+\\d{1,3}-)?\\s?1\\d{10}";

    public static String getVideoInterview() {
        return ResManager.loadKDString((String)"\u89c6\u9891\u9762\u8bd5", (String)"CandidateInputInfoPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
    }

    public static String getPhoneInterview() {
        return ResManager.loadKDString((String)"\u7535\u8bdd\u9762\u8bd5", (String)"CandidateInputInfoPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
    }

    public static String getInterview() {
        return ResManager.loadKDString((String)"\u73b0\u573a\u9762\u8bd5", (String)"CandidateInputInfoPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"buttonap", RE_BUTTONAP});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.getView().setVisible(Boolean.TRUE, new String[]{SIGNINPHONEFLEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{SUCCESSFLEX, FAILFLEX});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("buttonap".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String telephonefield = (String)dataEntity.get(TELEPHONEFIELD);
            if (HRStringUtils.isEmpty((String)telephonefield)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u624b\u673a\u53f7\"\u3002", (String)"CandidateInputInfoPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            StringBuilder sb = new StringBuilder(telephonefield);
            String finalPhone = null;
            if (sb.indexOf(STR) == -1) {
                StringBuilder insertString = sb.insert(3, STR);
                finalPhone = insertString.toString();
            } else {
                finalPhone = sb.toString();
            }
            boolean matches = Pattern.matches(PHONE_RULE, finalPhone);
            if (!matches) {
                Label phoneerror = (Label)this.getControl(PHONEERROR);
                phoneerror.setText(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef", (String)"CandidateInputInfoPlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            List appfileIdList = new IntvGroupCandidateHelper().selectAppfileIdList(finalPhone);
            DynamicObject[] candidate = new IntvGroupCandidateHelper().selectCandidate(appfileIdList);
            Long appfileId = new IntvGroupCandidateHelper().selectAppfileID(appfileIdList);
            int candidateFlag = new IntvMethodHelper().getCandidateFlag(appfileId);
            String intvMethod = new IntvMethodHelper().getIntvMethod(appfileId);
            if (candidate != null && candidate.length != 0 && candidateFlag != -1) {
                String position = new IntvPositionHelper().selectIntvPositionById(appfileId);
                this.signInSuccessful(appfileId, position, candidateFlag);
                this.rePosition(intvMethod, appfileId);
            } else {
                this.signInFail(telephonefield);
            }
        }
        if (RE_BUTTONAP.equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SIGNINPHONEFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{SUCCESSFLEX, FAILFLEX});
            Label phoneerror = (Label)this.getControl(PHONEERROR);
            phoneerror.setText(PHONE_NULL);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        Label phoneerror = (Label)this.getControl(PHONEERROR);
        phoneerror.setText(PHONE_NULL);
    }

    public void rePosition(String intvMethod, Long appfileId) {
        if (CandidateInputInfoPlugin.getVideoInterview().equals(intvMethod)) {
            Label lbPositionSite = (Label)this.getControl(INTVSITE);
            lbPositionSite.setText(new IntvMethodHelper().getCandatevedioaddress(appfileId));
        } else if (CandidateInputInfoPlugin.getPhoneInterview().equals(intvMethod)) {
            Label lbPositionSite = (Label)this.getControl(INTVSITE);
            lbPositionSite.setText(ResManager.loadKDString((String)"\u7535\u8bdd\u9762\u8bd5\uff0c\u65e0\u9762\u8bd5\u5730\u5740", (String)"CandidateInputInfoPlugin_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        } else if (CandidateInputInfoPlugin.getInterview().equals(intvMethod)) {
            Label lbPositionSite = (Label)this.getControl(INTVSITE);
            lbPositionSite.setText(new IntvMethodHelper().getAddress(appfileId));
        }
    }

    public void signInSuccessful(Long appfileId, String position, int candidateFlag) {
        new SignInStatusHelper().updateSignInStatus(appfileId, candidateFlag);
        this.getView().setVisible(Boolean.TRUE, new String[]{SUCCESSFLEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{SIGNINPHONEFLEX, FAILFLEX});
        Date intvTime = new IntvMethodHelper().getIntvTime(appfileId);
        String date2Str = HRInteDateTimeUtil.formatDate((String)"tsirm_appfiletask", (String)INTVTIME, (Date)intvTime);
        Label lbPositionName = (Label)this.getControl(POSITIONNAME);
        lbPositionName.setText(position);
        Label lbPositionTime = (Label)this.getControl(INTVTIME);
        lbPositionTime.setText(date2Str);
    }

    public void signInFail(String telephonefield) {
        this.getView().setVisible(Boolean.TRUE, new String[]{FAILFLEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{SIGNINPHONEFLEX, SUCCESSFLEX});
        Label lable3 = (Label)this.getView().getControl(SHOWPHONE);
        lable3.setText(telephonefield);
    }
}

