/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.service;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.util.CollectionUtils;

public class TalentPoolAsyncService {
    public static void pushAsyncTaskForRemoveTalentPool(AbstractFormPlugin formPlugin, String formId, List<Long> candidateIdList, List<Long> talentPoolIdList, List<Long> notExistsIds, Long allocatedTPId, List<String> rootIdList) {
        String taskClassTask = "kd.tsc.tsirm.business.domain.task.RemoveFromTalentPoolTask";
        String taskName = ResManager.loadKDString((String)"\u79fb\u9664\u4eba\u624d\u5e93\u4efb\u52a1", (String)"TalentPoolAsyncService_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        JobInfo jobInfo = TalentPoolAsyncService.builJobInfo(formId, candidateIdList, talentPoolIdList, notExistsIds, taskClassTask, taskName, allocatedTPId);
        jobInfo.getParams().put("rootIdList", rootIdList);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)formPlugin, "pushAsyncTaskForRemoveTalentPool");
        JobFormInfo jobFormInfo = TalentPoolAsyncService.buildJobFormInfo(jobInfo, closeCallBack, taskName);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formPlugin.getView());
    }

    public static void pushAsyncTaskForRestoreTalentPool(AbstractFormPlugin formPlugin, String formId, List<Long> candidateIdList, List<Long> talentPoolIdList, List<Long> notExistsIds, Long allocatedTPId) {
        String taskClassTask = "kd.tsc.tsirm.business.domain.task.RestoreToTalentPoolTask";
        String taskName = ResManager.loadKDString((String)"\u50a8\u5907\u5230\u4eba\u624d\u5e93\u4efb\u52a1", (String)"TalentPoolAsyncService_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        JobInfo jobInfo = TalentPoolAsyncService.builJobInfo(formId, candidateIdList, talentPoolIdList, notExistsIds, taskClassTask, taskName, allocatedTPId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)formPlugin, "pushAsyncTaskForRestoreTalentPool");
        JobFormInfo jobFormInfo = TalentPoolAsyncService.buildJobFormInfo(jobInfo, closeCallBack, taskName);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formPlugin.getView());
    }

    public static void pushAsyncTaskForSelectPosition(AbstractFormPlugin formPlugin, List<Long> candidateIdList, List<Long> positionIdList) {
        String taskClassName = "kd.tsc.tsirm.business.domain.task.RecommendToPositionTask";
        String taskName = ResManager.loadKDString((String)"\u63a8\u8350\u5230\u804c\u4f4d\u4efb\u52a1", (String)"TalentPoolAsyncService_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        JobInfo jobInfo = TalentPoolAsyncService.builJobInfo(candidateIdList, positionIdList, taskClassName, taskName);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)formPlugin, "pushAsyncTaskForSelectPosition");
        JobFormInfo jobFormInfo = TalentPoolAsyncService.buildJobFormInfo(jobInfo, closeCallBack, taskName);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formPlugin.getView());
    }

    private static JobInfo builJobInfo(String formId, List<Long> candidateIdList, List<Long> talentPoolIdList, List<Long> notExistsIds, String taskClassName, String taskName, Long allocatedTPId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("tsirm");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName(taskName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(taskClassName);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(6);
        if (CollectionUtils.isNotEmpty(candidateIdList)) {
            paramMap.put("candidateIdList", candidateIdList);
        }
        if (CollectionUtils.isNotEmpty(talentPoolIdList)) {
            paramMap.put("talentPoolList", talentPoolIdList);
        }
        if (CollectionUtils.isNotEmpty(notExistsIds)) {
            paramMap.put("notExistsIds", notExistsIds);
        }
        paramMap.put("allocatedTPId", String.valueOf(allocatedTPId));
        paramMap.put("formId", formId);
        jobInfo.setParams(paramMap);
        return jobInfo;
    }

    private static JobInfo builJobInfo(List<Long> candidateIdList, List<Long> positionIdList, String taskClassName, String taskName) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("tsirm");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName(taskName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(taskClassName);
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>(6);
        if (CollectionUtils.isNotEmpty(candidateIdList)) {
            paramMap.put("candidateIdList", candidateIdList);
        }
        if (CollectionUtils.isNotEmpty(positionIdList)) {
            paramMap.put("positionIdList", positionIdList);
        }
        jobInfo.setParams(paramMap);
        return jobInfo;
    }

    private static JobFormInfo buildJobFormInfo(JobInfo jobInfo, CloseCallBack closeCallBack, String caption) {
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(caption);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(Boolean.TRUE.booleanValue());
        jobFormInfo.setCanStop(Boolean.FALSE.booleanValue());
        jobFormInfo.setClickClassName("kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.department.DepartmentSyncTaskClick");
        return jobFormInfo;
    }
}

