/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.TalentPoolOperateRecordService;
import kd.tsc.tsirm.business.domain.talentpool.entity.TalentPoolFallMessage;
import kd.tsc.tsirm.business.domain.talentpool.helper.TalentPoolFunHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import org.apache.commons.collections.CollectionUtils;

public class TalentPoolService {
    private static final TalentPoolService TALENT_POOL_SERVICE = new TalentPoolService();

    public static TalentPoolService getInstance() {
        return TALENT_POOL_SERVICE;
    }

    public void dealRestoreTalentPoolResult(IFormView formView, OperationResult addOperationResult, int totalCount, List<Long> notExistsIds, DynamicObject[] addReserveDtArrays, List<Long> talentPoolIds, List<Long> candidateIds, Long allocatedTPId) {
        if (null == addReserveDtArrays) {
            addReserveDtArrays = TalentPoolFunHelper.queryReserve((String)"stdrsm.fullname,stdrsm.number,talentpool.name,talentpool.number", talentPoolIds, candidateIds);
        }
        int errorCount = addOperationResult.getValidateResult().errorSize();
        if (totalCount > 1) {
            if (errorCount > 0 || !notExistsIds.isEmpty()) {
                this.showReserveRecordMessage(formView, addReserveDtArrays, addOperationResult, talentPoolIds, notExistsIds, candidateIds);
            } else {
                TalentListFunService.showPageNotification((IFormView)formView, (boolean)true, (String)"savetalent");
            }
        } else if (errorCount > 0) {
            List allErrorOrValidateInfo = addOperationResult.getAllErrorOrValidateInfo();
            String message = ((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage();
            formView.showErrorNotification(message);
        } else {
            TalentListFunService.showPageNotification((IFormView)formView, (boolean)true, (String)"savetalent");
        }
        StandardResumeDataHelper.updateModifyTime(candidateIds);
        ArrayList<Long> unClassifiedCTalentPools = new ArrayList<Long>(1);
        unClassifiedCTalentPools.add(allocatedTPId);
        TalentListFunService.removeReserveRecord(unClassifiedCTalentPools, candidateIds);
        TalentPoolOperateRecordService.getInstance().reserveOpRecord(addReserveDtArrays, addOperationResult);
    }

    private void removeRecord(IFormView formView, List<Long> talentPoolIds, List<Long> candidateIds, int totalCount, List<Long> notExistsIds, Long allocatedTPId, int removeIgnoreNum, int removeSize) {
        int errorCount = totalCount - removeSize - removeIgnoreNum;
        if (totalCount > 1) {
            if (errorCount > 0) {
                this.removeShow(formView, removeSize, notExistsIds, candidateIds, totalCount, removeIgnoreNum);
            } else {
                TalentListFunService.showPageNotification((IFormView)formView, (boolean)true, (String)"removetalent");
            }
        } else {
            TalentListFunService.showPageNotification((IFormView)formView, (errorCount <= 0 ? 1 : 0) != 0, (String)"removetalent");
        }
        List unClassifiedCandidateIds = TalentPoolFunHelper.queryCandidateReserve(candidateIds);
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)unClassifiedCandidateIds)) {
            TalentListFunService.saveCandidate2UnClassFy((List)unClassifiedCandidateIds, (Long)allocatedTPId);
        }
    }

    public void restoreTalentPoolTaskCloseCallBack(IFormView view, ClosedCallBackEvent closedCallBackEvent) {
        Object taskInfoForRestore = ((Map)closedCallBackEvent.getReturnData()).get("taskinfo");
        if (null != taskInfoForRestore && HRStringUtils.isNotEmpty((String)taskInfoForRestore.toString())) {
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoForRestore.toString(), TaskInfo.class);
            Optional.ofNullable(taskInfo.getData()).ifPresent(data -> {
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
                String candidateIdListStr = (String)dataMap.get("candidateIdList");
                String talentPoolIdListStr = (String)dataMap.get("talentPoolIdList");
                String restoreResultStr = (String)dataMap.get("data");
                String notExistsIdsStr = (String)dataMap.get("notExistsIds");
                String allocatedTPIdStr = (String)dataMap.get("allocatedTPId");
                List candidateIdList = (List)SerializationUtils.fromJsonString((String)candidateIdListStr, ArrayList.class);
                List talentPoolIdList = (List)SerializationUtils.fromJsonString((String)talentPoolIdListStr, ArrayList.class);
                List notExistsIds = null == notExistsIdsStr ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)notExistsIdsStr, ArrayList.class);
                OperationResult restoreResult = (OperationResult)SerializationUtils.fromJsonString((String)restoreResultStr, OperationResult.class);
                long allocatedTPId = Long.parseLong(allocatedTPIdStr);
                int totalCount = talentPoolIdList.size() * candidateIdList.size();
                this.dealRestoreTalentPoolResult(view, restoreResult, totalCount, notExistsIds, null, talentPoolIdList, candidateIdList, allocatedTPId);
                this.updateCache(view, candidateIdList);
                view.updateView();
            });
        }
    }

    public void selectPositionTalentPoolTaskCloseCallBack(IFormView view, ClosedCallBackEvent closedCallBackEvent) {
        Object taskInfoStr = ((Map)closedCallBackEvent.getReturnData()).get("taskinfo");
        if (null != taskInfoStr && HRStringUtils.isNotEmpty((String)taskInfoStr.toString())) {
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr.toString(), TaskInfo.class);
            Optional.ofNullable(taskInfo.getData()).ifPresent(data -> {
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
                String selectPositionData = (String)dataMap.get("data");
                TalentPoolFallMessage talentPoolFallMessage = (TalentPoolFallMessage)SerializationUtils.fromJsonString((String)selectPositionData, TalentPoolFallMessage.class);
                if (talentPoolFallMessage.getFlag()) {
                    view.showSuccessNotification(talentPoolFallMessage.getTitleMsg());
                    return;
                }
                if (HRStringUtils.isEmpty((String)talentPoolFallMessage.getErrorMsgTotal())) {
                    view.showErrorNotification(talentPoolFallMessage.getTitleMsg());
                } else {
                    FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)talentPoolFallMessage.getTitleMsg(), (Object)talentPoolFallMessage.getErrorMsgTotal(), (boolean)false);
                    view.showForm(formShowParameter);
                }
                String candidateIdsWithRightsStr = view.getPageCache().get("candidateidswithrights");
                if (HRStringUtils.isEmpty((String)candidateIdsWithRightsStr)) {
                    return;
                }
                List candidateIds = TalentListFunService.stringToLongList((String)candidateIdsWithRightsStr);
                TalentPoolService.getInstance().updateCache(view, candidateIds);
                view.updateView();
            });
        }
    }

    public void removeTalentPoolTaskCloseCallBack(IFormView view, ClosedCallBackEvent closedCallBackEvent) {
        Object taskInfoForRestore = ((Map)closedCallBackEvent.getReturnData()).get("taskinfo");
        if (null != taskInfoForRestore && HRStringUtils.isNotEmpty((String)taskInfoForRestore.toString())) {
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoForRestore.toString(), TaskInfo.class);
            Optional.ofNullable(taskInfo.getData()).ifPresent(data -> {
                boolean batchResult;
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
                boolean bl = batchResult = dataMap.get("removetalent") != null && Boolean.parseBoolean((String)dataMap.get("removetalent"));
                if (!batchResult) {
                    TalentListFunService.showPageNotification((IFormView)view, (boolean)false, (String)"removetalent");
                    return;
                }
                String candidateIdListStr = (String)dataMap.get("candidateIdList");
                String talentPoolIdListStr = (String)dataMap.get("talentPoolIdList");
                String notExistsIdsStr = (String)dataMap.get("notExistsIds");
                Long allocatedTPIdStr = dataMap.get("allocatedTPId") == null ? TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED : Long.parseLong(TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED.toString());
                int removeIgnoreNum = dataMap.get("removeIgnoreNum") == null ? 0 : Integer.parseInt((String)dataMap.get("removeIgnoreNum"));
                int removeSize = dataMap.get("removeSize") == null ? 0 : Integer.parseInt((String)dataMap.get("removeSize"));
                List candidateIdList = (List)SerializationUtils.fromJsonString((String)candidateIdListStr, ArrayList.class);
                List talentPoolIdList = (List)SerializationUtils.fromJsonString((String)talentPoolIdListStr, ArrayList.class);
                List notExistsIds = null == notExistsIdsStr ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)notExistsIdsStr, ArrayList.class);
                int totalCount = candidateIdList.size() * talentPoolIdList.size();
                this.removeRecord(view, talentPoolIdList, candidateIdList, totalCount, notExistsIds, allocatedTPIdStr, removeIgnoreNum, removeSize);
                this.updateCache(view, candidateIdList);
                view.updateView();
            });
        }
    }

    private void showReserveRecordMessage(IFormView formView, DynamicObject[] reserveDtArrays, OperationResult operationResult, List<Long> talentPoolIds, List<Long> notExistsIds, List<Long> candidateIds) {
        Map returnMap = TalentListFunService.showReserveRecordMessageTalentPool((DynamicObject[])reserveDtArrays, (OperationResult)operationResult, talentPoolIds, notExistsIds, candidateIds);
        if (returnMap.isEmpty()) {
            return;
        }
        FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam(returnMap.get("titleMsg"), returnMap.get("errorMsgTotal"), (boolean)false);
        formView.showForm(formShowParameter);
    }

    private void removeShow(IFormView formView, int removeSize, List<Long> notExistsIds, List<Long> candidateIds, int totalCount, int removeIgnoreNum) {
        Map returnMap = TalentListFunService.showRemoveTalentPoolMessage((int)removeSize, notExistsIds, candidateIds, (int)totalCount, (int)removeIgnoreNum);
        if (returnMap.isEmpty()) {
            return;
        }
        FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam(returnMap.get("titleMsg"), returnMap.get("errorMsgTotal"), (boolean)false);
        formView.showForm(formShowParameter);
    }

    public void updateCache(IFormView formView, List<Long> candidateIds) {
        List stdList = TsrbsHelper.selectByFilter((String)"id,talentpool.fbasedataid", (QFilter[])new QFilter[]{new QFilter("id", "in", candidateIds)}, (String)"tsirm_stdrsm");
        Map currentReserveMap = (Map)SerializationUtils.deSerializeFromBase64((String)formView.getPageCache().get("currentNodeId"));
        if (CollectionUtils.isEmpty((Collection)stdList)) {
            return;
        }
        HashMap stdReserveMap = Maps.newHashMapWithExpectedSize((int)stdList.size());
        if (currentReserveMap == null) {
            currentReserveMap = Maps.newHashMapWithExpectedSize((int)stdList.size());
        }
        stdList.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getDynamicObjectCollection("talentpool"))).forEach((stdId, dynamicObjectCollection) -> stdReserveMap.put(stdId, dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList())));
        Map finalCurrentReserveMap = currentReserveMap;
        candidateIds.forEach(stdRsmId -> {
            List dbCurrentTalentPoolList = (List)stdReserveMap.get(stdRsmId);
            finalCurrentReserveMap.put(stdRsmId, dbCurrentTalentPoolList);
        });
        formView.getPageCache().put("currentNodeId", SerializationUtils.serializeToBase64((Object)finalCurrentReserveMap));
    }
}

