/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.genedatautil.GenerateCandidateJob;
import kd.tsc.tsirm.business.domain.genedatautil.GenerateDataJob;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;

public class DataGeneratingPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(DataGeneratingPlugin.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"TscDataGenerate");

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void click(EventObject evt) {
        String accountId = RequestContext.getOrCreate().getAccountId();
        ArrayList accountIdList = Lists.newArrayList((Object[])new String[]{"1743620526296796160", "1743651961875466240", "1744258971658618880", "1744868091503839232", "1757181178021939200", "1775519997548824576", "1793627883093100544", "1905741561468029952"});
        if (!accountIdList.contains(accountId)) {
            logger.info("accountId:{} cannot generate data", (Object)accountId);
            return;
        }
        int number = this.getModel().getDataEntity().getInt("number");
        int jobCount = this.getModel().getDataEntity().getInt("jobcount");
        String entityKey = this.getModel().getDataEntity().getString("entitykey");
        String positionStr = this.getModel().getDataEntity().getString("positionstr");
        String employeeIdStr = this.getModel().getDataEntity(true).getString("employeeid");
        if ("tsirm_position".equals(entityKey)) {
            this.generatePositionData(number, jobCount);
        } else if ("tsirm_appfile_viewm".equals(entityKey)) {
            this.generateCandidateData(number, jobCount, positionStr, employeeIdStr);
        } else if ("tsirm_appfile_view".equals(entityKey)) {
            ArrayList batchIds = new ArrayList(1000);
            ArrayList<Long> pidsTemp = new ArrayList<Long>(2000);
            for (int i = 0; i <= 600000; ++i) {
                if (i % 1000 == 0) {
                    pidsTemp = new ArrayList(2000);
                    batchIds.add(pidsTemp);
                }
                pidsTemp.add(1000000000000300000L + (long)i);
            }
            for (List list : batchIds) {
                try {
                    Map updateUsedCertCountMap = TSIRMCertCommonHelper.updateUsedCertCount((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm", (List)list);
                    logger.info("updateUsedCertCountMap:{}", (Object)updateUsedCertCountMap);
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception);
                }
            }
        }
    }

    private void generateCandidateData(int number, int jobCount, String positionIdStr, String employeeIdStr) {
        List<Object> emloyeeIdList = new ArrayList();
        if (!HRStringUtils.isBlank((CharSequence)employeeIdStr)) {
            emloyeeIdList = Stream.of(employeeIdStr.split(",")).map(Long::parseLong).collect(Collectors.toList());
        }
        String[] split = positionIdStr.split(",");
        int batchSize = number / jobCount;
        int length = split.length;
        for (int i = 0; i < jobCount; ++i) {
            try {
                int j = i % length;
                GenerateCandidateJob job = new GenerateCandidateJob(batchSize, split[j], emloyeeIdList);
                THREAD_POOL.execute((Runnable)job);
            }
            catch (Exception exception) {
                logger.error((Throwable)exception);
            }
            logger.info("i:{}", (Object)i);
        }
    }

    public void generatePositionData(int number, int jobCount) {
        int batchSize = number / jobCount;
        for (int i = 0; i < jobCount; ++i) {
            GenerateDataJob job = new GenerateDataJob(i * batchSize, (i + 1) * batchSize);
            THREAD_POOL.execute((Runnable)job);
        }
    }
}

