/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.advertising;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tsc.tsirm.business.domain.advert.service.AdvertApprovalHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.business.domain.intreco.service.IntrecoPageHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionHelper;
import kd.tsc.tsirm.formplugin.web.advertising.AdvertFormHelper;

public class AdvertDetailExBillList
extends HRCoreBaseBillList {
    public static final String ADVREFRESH = "advrefresh";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"editadvert", ADVREFRESH, "startadvert", "stopadvert", "modify", "advpreview", "waitpubmodify"});
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        Object positionId = this.getView().getFormShowParameter().getCustomParams().get("positionid");
        if (!Objects.isNull(positionId)) {
            Long positionIdLong = Long.valueOf(String.valueOf(positionId));
            String publishState = (String)this.getView().getFormShowParameter().getCustomParams().get("filterState");
            QFilter qFilter = new QFilter("position.id", "=", (Object)positionIdLong);
            if (publishState != null && HRStringUtils.equals((String)"isPublish", (String)publishState)) {
                qFilter.and(new QFilter("advertstatus", "=", (Object)"S"));
                setFilterEvent.setOrderBy("refreshtime DESC");
            }
            if (publishState != null && HRStringUtils.equals((String)"noPublish", (String)publishState)) {
                qFilter.and(new QFilter("advertstatus", "!=", (Object)"S"));
                setFilterEvent.setOrderBy("createtime DESC");
            }
            setFilterEvent.addCustomQFilter(qFilter);
        }
        setFilterEvent.addCustomQFilter(new QFilter("channel", "!=", (Object)1180L));
        super.setFilter(setFilterEvent);
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        DynamicObject rowData = evt.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if ("name".equals(fieldKey)) {
            long approvalId = rowData.getLong("approvalid");
            if (0L == approvalId) {
                evt.setFormatValue(null);
            } else {
                String name = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5e7f\u544a\u7533\u8bf7\u5355", (String)"AdvertTplExCommonHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), rowData.getString("name"));
                evt.setFormatValue((Object)name);
            }
        } else if ("reward".equals(fieldKey)) {
            int reward = rowData.getInt(fieldKey);
            if (reward > 0) {
                String rewardVal = String.format(Locale.ROOT, IntrecoPageHelper.getRewardTpl((DynamicObject)rowData), reward);
                evt.setFormatValue((Object)rewardVal);
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"rewardpoint")) {
            int point = rowData.getInt(fieldKey);
            if (point > 0) {
                evt.setFormatValue((Object)IntrecoPageHelper.getRewardPointTpl((DynamicObject)rowData));
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"issimple") && PositionHelper.isPositionSimpleView((IFormView)this.getView())) {
            evt.setFormatValue((Object)"1");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        Long pkId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        String fieldName = args.getFieldName();
        DynamicObject bill = AdvertDetailExDataHelper.getInstance().queryAdvertAuditDetail(pkId);
        if ("cardlistcolumnap6".equals(fieldName) || "fullname".equals(fieldName)) {
            args.setCancel(true);
            AdvertFormHelper.getInstance().openAdvertDetailPage(this.getView(), pkId);
            this.clearSelection();
        }
        if ("cardlistcolumnap7".equals(fieldName) && !HRObjectUtils.isEmpty((Object)bill)) {
            args.setCancel(true);
            long billNum = bill.getLong("approvalid");
            AdvertFormHelper.getInstance().openAdvertApprovalDetailPage(this.getView(), billNum, OperationStatus.VIEW, new CloseCallBack((IFormPlugin)this, "editadvert"));
            this.clearSelection();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        String key = source.getKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return;
        }
        Long id = (Long)selectedRows.getPrimaryKeyValues()[0];
        if ("advpreview".equals(key)) {
            AdvertBusinessHelper.previewAdvert((IFormView)this.getView(), (Long)id);
            this.clearSelection();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        AdvertApprovalHelper.solveApprovalCallBack((IFormView)this.getView(), (ClosedCallBackEvent)closedCallBackEvent);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            List<String> pageIds;
            String pageIdStr = parentView.getPageCache().get("advertCommonList");
            List list = pageIds = pageIdStr == null ? new ArrayList(3) : (List)JSONObject.parseObject((String)pageIdStr, List.class);
            if (!pageIds.contains(this.getView().getPageId())) {
                pageIds.add(this.getView().getPageId());
            }
            parentView.getPageCache().put("advertCommonList", JSONObject.toJSONString(pageIds));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("refreashadvert".equals(operateKey) || "editadvert".equals(operateKey)) {
            this.clearSelection();
            this.getView().updateView();
        } else if ("startadvert".equals(operateKey)) {
            this.clearSelection();
            this.afterEnable(afterDoOperationEventArgs);
            this.refreshTabChild();
        } else if ("stopadvert".equals(operateKey)) {
            this.refreshTabChild();
        } else if (HRStringUtils.equals((String)"waitpubmodify", (String)operateKey) || HRStringUtils.equals((String)"edit", (String)operateKey)) {
            this.afterModify(afterDoOperationEventArgs);
            this.clearSelection();
        }
    }

    private boolean refreshTabChild() {
        IFormView parentView = this.getView().getParentView();
        String advCommonListPageIds = parentView.getPageCache().get("advertCommonList");
        PositionDataHelper.setPubAdvNum((IFormView)parentView);
        this.getView().sendFormAction(parentView);
        if (HRStringUtils.isNotEmpty((String)advCommonListPageIds)) {
            List pageIds = (List)JSONObject.parseObject((String)advCommonListPageIds, List.class);
            this.getView().getPageCache().put("advertCommonList", null);
            for (String pageId : pageIds) {
                IFormView childrenView = this.getView().getView(pageId);
                childrenView.invokeOperation("refresh");
                this.getView().sendFormAction(childrenView);
            }
            return true;
        }
        return false;
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        evt.setCancel(true);
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        Long primaryKeyValue = (Long)currentListSelectedRow.getPrimaryKeyValue();
        AdvertFormHelper.getInstance().openAdvertDetailPage(this.getView(), primaryKeyValue);
    }

    private void afterEnable(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult.isShowMessage()) {
            return;
        }
        AdvertBusinessHelper.showEnableAdvTip((IFormView)this.getView(), (OperationResult)operationResult);
        this.getView().updateView();
    }

    private void afterModify(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (!operationResult.isSuccess()) {
            return;
        }
        long billId = Long.parseLong(operationResult.getMessage());
        if (billId == 0L) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows.isEmpty()) {
                return;
            }
            Long id = (Long)selectedRows.getPrimaryKeyValues()[0];
            AdvertFormHelper.getInstance().openAdvertDetailPage(this.getView(), id, null, OperationStatus.EDIT, new CloseCallBack((IFormPlugin)this, "editadvert"));
        } else {
            HashMap param = Maps.newHashMapWithExpectedSize((int)1);
            if (HRStringUtils.equals((String)args.getOperateKey(), (String)"waitpubmodify")) {
                param.put("waitpubmodify", "1");
            }
            AdvertFormHelper.getInstance().openAdvertApprovalDetailPage(this.getView(), billId, OperationStatus.EDIT, new CloseCallBack((IFormPlugin)this, "close_approval_detail"), param);
        }
    }
}

