/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.advertising;

import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import org.apache.commons.collections.MapUtils;

public class AdvertFormHelper {
    public static AdvertFormHelper getInstance() {
        return AdvertFormHelperHolder.INSTANCE;
    }

    public void openAdvertDetailPage(IFormView view, Long primaryKeyValue) {
        this.openAdvertDetailPage(view, primaryKeyValue, null, OperationStatus.VIEW);
    }

    public void openAdvertDetailPage(IFormView view, Long primaryKeyValue, Map<String, Object> param, OperationStatus status) {
        this.openAdvertDetailPage(view, primaryKeyValue, param, status, null);
    }

    public void openAdvertDetailPage(IFormView view, Long primaryKeyValue, Map<String, Object> param, OperationStatus status, CloseCallBack closeCallBack) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("tsirm_advertdetailex");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(status);
        showParameter.setPkId((Object)primaryKeyValue);
        if (MapUtils.isNotEmpty(param)) {
            showParameter.setCustomParams(param);
        }
        if (closeCallBack != null) {
            showParameter.setCloseCallBack(closeCallBack);
        }
        String prefix = ResManager.loadKDString((String)"\u5e7f\u544a", (String)"AdvertFormHelper_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        DynamicObject advert = AdvertDetailExDataHelper.getInstance().getAdvertListByIds(primaryKeyValue);
        showParameter.setCaption(prefix + "-" + advert.getString("fullname"));
        showParameter.setPageId(view.getPageId() + "tsirm_advertdetailex" + primaryKeyValue);
        view.showForm((FormShowParameter)showParameter);
    }

    public void openAdvertApprovalDetailPage(IFormView view, Long primaryKeyValue, OperationStatus status, CloseCallBack closeCallBack) {
        this.openAdvertApprovalDetailPage(view, primaryKeyValue, status, closeCallBack, null);
    }

    public void openAdvertApprovalDetailPage(IFormView view, Long primaryKeyValue, OperationStatus status, CloseCallBack closeCallBack, Map<String, Object> customParam) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tsirm_advertbill");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(status);
        showParameter.setPkId((Object)primaryKeyValue);
        String name = ResManager.loadKDString((String)"\u5e7f\u544a\u7533\u8bf7\u5355", (String)"AdvertFormHelper_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        showParameter.setCaption(name);
        if (closeCallBack != null) {
            showParameter.setCloseCallBack(closeCallBack);
        }
        if (null != customParam && !customParam.isEmpty()) {
            showParameter.setCustomParams(customParam);
        }
        showParameter.setPageId(view.getPageId() + "tsirm_advertbilltpl" + primaryKeyValue);
        view.showForm((FormShowParameter)showParameter);
    }

    public void openAdvertApprovalDetailPage(IFormView view, Long primaryKeyValue, OperationStatus status) {
        this.openAdvertApprovalDetailPage(view, primaryKeyValue, status, null);
    }

    public void openAdvertApprovalDetailPage(IFormView view, Long primaryKeyValue) {
        this.openAdvertApprovalDetailPage(view, primaryKeyValue, OperationStatus.VIEW);
    }

    public void openPositionDetailPage(IFormView view, DynamicObject advert) {
        DynamicObject position = advert.getDynamicObject("position");
        AppFileHelper.showPositionFormView((long)position.getLong("id"), (IFormView)view);
    }

    public void openAdvApprovalCardList(IFormView formView, Object advertId) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setFormId("bos_list");
        formShowParameter.setBillFormId("tsirm_advapprovaltab");
        formShowParameter.getOpenStyle().setTargetKey("tabadvertaudit");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.setCustomParam("advertId", advertId);
        formView.getPageCache().put("tabadvertaudit", formShowParameter.getPageId());
        formView.showForm((FormShowParameter)formShowParameter);
    }

    private static class AdvertFormHelperHolder {
        private static final AdvertFormHelper INSTANCE = new AdvertFormHelper();

        private AdvertFormHelperHolder() {
        }
    }
}

