/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.advertising;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExDataHelper;
import kd.tsc.tsirm.business.domain.position.service.permission.PositionPermService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AdvertisingFilterList
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(AdvertisingFilterList.class);
    private static final String PAGE_TSIRM_ADVERTTPLEXLISTA = "tsirm_adverttplexlista";
    private static final String PAGE_TSIRM_ADVERTTPLEXLISTB = "tsirm_adverttplexlistb";
    private static final String POSITION_FILTER_FIRST = "position_filter_first";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        ((IListColumn)listColumns.get(1)).setFixed(true);
        ((IListColumn)listColumns.get(2)).setFixed(true);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        this.setDefaultQFilter(setFilterEvent);
        Object positionId = this.getView().getFormShowParameter().getCustomParam("positionid");
        if (positionId != null && this.getView().getPageCache().get(POSITION_FILTER_FIRST) == null) {
            QFilter positionQFilter = new QFilter("position.id", "=", positionId);
            setFilterEvent.getQFilters().add(positionQFilter);
            this.getView().getPageCache().put(POSITION_FILTER_FIRST, "1");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        this.changeCommonFilterItem(commonFilterColumns);
        this.changeSchemeFilterColumn(args);
    }

    private void changeSchemeFilterColumn(FilterContainerInitArgs args) {
        List schemeFilterColumns = args.getSchemeFilterColumns();
        for (FilterColumn schemeFilterColumn : schemeFilterColumns) {
            String filterColumnFieldName = schemeFilterColumn.getFieldName();
            if (!"position.positionstatus".equals(filterColumnFieldName)) continue;
            List comboItems = ((SchemeFilterColumn)schemeFilterColumn).getComboItems();
            this.setRecruitPositionStatus(comboItems);
        }
    }

    private void changeCommonFilterItem(List<FilterColumn> commonFilterColumns) {
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            List comboItems = ((CommonFilterColumn)commonFilterColumn).getComboItems();
            switch (fieldName) {
                case "advertbuorg.name": {
                    List userAllPermOrgIds;
                    Object customParam = this.getView().getFormShowParameter().getCustomParam("createorg");
                    Long createOrgId = TSCRequestContext.getOrgId();
                    if (!Objects.isNull(customParam)) {
                        if (customParam instanceof Integer) {
                            createOrgId = Long.valueOf(String.valueOf(customParam));
                        } else if (customParam instanceof Long) {
                            createOrgId = (Long)customParam;
                        }
                    }
                    if (!(userAllPermOrgIds = AdvertTplExDataHelper.getAllPermOrgIds((String)"tsirm_position")).contains(createOrgId)) break;
                    commonFilterColumn.setDefaultValue(String.valueOf(createOrgId));
                    break;
                }
                case "adminorg.name": {
                    break;
                }
                case "position.positionstatus": {
                    this.setRecruitPositionStatus(comboItems);
                    break;
                }
                case "position.name": {
                    Object positionId = this.getView().getFormShowParameter().getCustomParam("positionid");
                    if (positionId == null) break;
                    commonFilterColumn.setDefaultValues(new Object[]{positionId.toString()});
                    break;
                }
                case "recruscene.number": {
                    ((CommonFilterColumn)commonFilterColumn).setMulti(false);
                    this.setRecruceneType(comboItems);
                    break;
                }
                case "advertstatus": {
                    String pubStatus = (String)this.getView().getFormShowParameter().getCustomParam(fieldName);
                    if (!HRStringUtils.isNotEmpty((String)pubStatus)) break;
                    String[] statuses = pubStatus.split(",");
                    ArrayList statusList = Lists.newArrayListWithExpectedSize((int)statuses.length);
                    statusList.addAll(Arrays.asList(statuses));
                    commonFilterColumn.setDefaultValues((List)statusList);
                    break;
                }
                case "enddate": 
                case "startdate": {
                    String startDate = (String)this.getView().getFormShowParameter().getCustomParam(fieldName);
                    if (!HRStringUtils.isNotEmpty((String)startDate)) break;
                    commonFilterColumn.setDefaultValue(startDate);
                    break;
                }
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        super.filterContainerBeforeF7Select(args);
        switch (fieldName = args.getFieldName()) {
            case "advertbuorg.name": 
            case "advertbuorg.id": {
                boolean isSuperMan = AdvertTplExDataHelper.getAdvertOrgPerm();
                if (isSuperMan) break;
                List allPermOrgIds = AdvertTplExDataHelper.getAllPermOrgIds((String)"tsirm_position");
                args.addCustomQFilter(new QFilter("id", "in", (Object)allPermOrgIds));
                break;
            }
            case "adminorg.name": 
            case "adminorg.id": {
                AuthorizedOrgResult authorizedOrgResult = PositionPermService.getInstance(null).getPositionHasPermAdminOrgs();
                if (authorizedOrgResult.isHasAllOrgPerm()) break;
                args.addCustomQFilter(new QFilter("id", "in", (Object)authorizedOrgResult.getHasPermOrgs()));
                break;
            }
            case "recruscene.number": {
                QFilter filterType = new QFilter("recruitmentcategory.fbasedataid", "in", (Object)1030L).and("enable", "=", (Object)"1");
                args.addCustomQFilter(filterType);
                break;
            }
        }
    }

    private void setRecruitPositionStatus(List<ComboItem> comboItems) {
        comboItems.removeIf(comboItem -> !HRStringUtils.equals((String)comboItem.getValue(), (String)"A") && !HRStringUtils.equals((String)comboItem.getValue(), (String)"C") && !HRStringUtils.equals((String)comboItem.getValue(), (String)"D") && !HRStringUtils.equals((String)comboItem.getValue(), (String)"G"));
    }

    private void setRecruceneType(List<ComboItem> comboItems) {
        List recRuceneIds = comboItems.stream().map(item -> Long.parseLong(item.getValue())).collect(Collectors.toList());
        List idList = AdvertBusinessHelper.removeRecRuceneId(recRuceneIds);
        comboItems.removeIf(comboItem -> !idList.contains(Long.parseLong(comboItem.getValue())));
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        evt.setCancel(true);
    }

    private void setDefaultQFilter(SetFilterEvent setFilterEvent) {
        QFilter defaultFilter = AdvertBusinessHelper.getAdvListDefaultFilter();
        String entityId = ((ListView)this.getView()).getBillFormId();
        if (HRStringUtils.equals((String)entityId, (String)PAGE_TSIRM_ADVERTTPLEXLISTA)) {
            defaultFilter = defaultFilter.and(new QFilter("channel", "not in", (Object)Lists.newArrayList((Object[])new Long[]{1160L, 1190L})));
        }
        setFilterEvent.addCustomQFilter(defaultFilter);
    }
}

