/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.advertising;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.ListRowClickEvent;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExDataHelper;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.business.license.VerifyCertTypeEnum;
import kd.tsc.tsirm.formplugin.service.AdvertService;
import kd.tsc.tsirm.formplugin.web.advertising.AdvertFormHelper;

public class AdvertisingList
extends HRDataBaseList {
    public static final String POSITION_NUMBER = "position_number";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"advertdisable"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Map verifyCert;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("startadvert".equals(operateKey) && !(verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm")).isEmpty() && verifyCert.containsKey("infoType")) {
            String infoType = (String)verifyCert.get("infoType");
            if (VerifyCertTypeEnum.FORBIDDEN.getValue().equals(infoType)) {
                this.getView().showErrorNotification((String)verifyCert.get("message"));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (!HRObjectUtils.isEmpty((Object)operationResult) && operationResult.isSuccess()) {
            AdvertService.getInstance().afterTopOrUrgent(operateKey, this.getView());
        }
        if (HRStringUtils.equals((String)"startadvert", (String)operateKey)) {
            AdvertBusinessHelper.showEnableAdvTip((IFormView)this.getView(), (OperationResult)operationResult);
        }
        if (!HRStringUtils.equals((String)"refresh", (String)operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getFieldName();
        Long primaryKeyValue = (Long)this.getFocusRowPkId();
        DynamicObject advertObj = AdvertTplExDataHelper.getInstance().queryAdvert(primaryKeyValue);
        if ("number".equals(fieldName)) {
            AdvertFormHelper.getInstance().openAdvertDetailPage(this.getView(), primaryKeyValue);
        } else if ("advbillno".equals(fieldName)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "close_approval_detail");
            AdvertFormHelper.getInstance().openAdvertApprovalDetailPage(this.getView(), advertObj.getLong("approvalid"), OperationStatus.VIEW, closeCallBack);
        } else if (POSITION_NUMBER.equals(fieldName)) {
            AdvertFormHelper.getInstance().openPositionDetailPage(this.getView(), advertObj);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Map verifyCert;
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        if ("startadvert".equals(operationKey) && !(verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm")).isEmpty() && verifyCert.containsKey("infoType")) {
            String infoType = (String)verifyCert.get("infoType");
            if (VerifyCertTypeEnum.WARNING.getValue().equals(infoType) || VerifyCertTypeEnum.EXCEED.getValue().equals(infoType)) {
                this.getView().showTipNotification((String)verifyCert.get("message"));
            }
        }
        if (this.notNeedControl(operationKey)) {
            return;
        }
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.size() > 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u4ee5\u9009\u62e920\u6761\u6570\u636e\u6267\u884c\u3002", (String)"AdvertisingList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        } else if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AdvertisingList_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private boolean notNeedControl(String operationKey) {
        return operationKey.equals("refresh") || "close".equals(operationKey) || operationKey.equals("stopadvertall") || operationKey.equals("refreshlist");
    }

    public void packageData(PackageDataEvent evt) {
        String approvalStatus;
        super.packageData(evt);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if ("refreshtime".equals(fieldKey)) {
            Date pubTime = evt.getRowData().getDate("pubtime");
            Date refreshTime = evt.getRowData().getDate("refreshtime");
            if (!Objects.isNull(refreshTime) && !Objects.isNull(pubTime) && refreshTime.equals(pubTime)) {
                evt.setFormatValue((Object)"");
            }
        } else if (("approvestatus".equals(fieldKey) || "advbillno".equals(fieldKey) || "approvalid".equals(fieldKey)) && HRStringUtils.equals((String)(approvalStatus = evt.getRowData().getString("approvestatus")), (String)"Z")) {
            evt.setFormatValue((Object)"");
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        evt.setCancel(true);
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        Long primaryKeyValue = (Long)currentListSelectedRow.getPrimaryKeyValue();
        AdvertFormHelper.getInstance().openAdvertDetailPage(this.getView(), primaryKeyValue);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (HRStringUtils.equals((String)actionId, (String)"close_approval_detail") && HRStringUtils.isNotEmpty((String)returnData)) {
            this.getView().invokeOperation("refresh");
            this.getView().activate();
            this.getView().showSuccessNotification(returnData);
        }
    }
}

