/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.advertising;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsrbs.common.utils.TscTreeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class StopAdvertListPlugin
extends AbstractTreeListPlugin {
    private final String MODULE = ((Object)((Object)this)).getClass().getName();
    private String TOOL_BAR = "toolbarap1";
    private AdvertBizService advertBizService = AdvertBizService.getInstance();
    private static String STOP_RIGHT = "2DVE/GVD6PEF";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"tblrefresh"});
    }

    public void initializeTree(EventObject evt) {
        super.initializeTree(evt);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        this.loadChannelNodeByParam(treeView, this.getTreeModel().getRoot());
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        String positionStatus = (String)this.getView().getFormShowParameter().getCustomParam("positionstatus");
        if (HRStringUtils.equals((String)positionStatus, (String)"D")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.TOOL_BAR});
            HashMap map = Maps.newHashMapWithExpectedSize((int)1);
            map.put("selcheckbox", Boolean.FALSE);
            this.getView().updateControlMetadata("gridview", (Map)map);
        }
    }

    private void loadChannelNodeByParam(TreeView treeView, TreeNode root) {
        Object customParam = this.getView().getFormShowParameter().getCustomParam("position");
        List positionIds = Lists.newArrayListWithCapacity((int)10);
        if (!Objects.isNull(customParam) && customParam instanceof Long) {
            positionIds.add((Long)customParam);
        } else {
            positionIds = (List)this.getView().getFormShowParameter().getCustomParam("position");
        }
        String selectProps = "id,channel";
        Map groupByChannel = this.advertBizService.getPubAdvertByPositionId(positionIds, selectProps);
        if (MapUtils.isEmpty((Map)groupByChannel)) {
            return;
        }
        List<DynamicObject> channels = this.assembleChannelListAndCache(groupByChannel);
        if (CollectionUtils.isNotEmpty(channels)) {
            for (DynamicObject channel : channels) {
                TreeNode treeNode = TscTreeUtils.getTreeNode((DynamicObject)channel, (String)root.getId());
                root.addChild(treeNode);
            }
            treeView.addNode(root);
            treeView.focusNode((TreeNode)root.getChildren().get(0));
            treeView.treeNodeClick(root.getId(), ((TreeNode)root.getChildren().get(0)).getId());
            this.getTreeModel().setRootVisable(false);
        }
    }

    private List<DynamicObject> assembleChannelListAndCache(Map<Long, List<DynamicObject>> groupByChannel) {
        ArrayList channels = Lists.newArrayListWithExpectedSize((int)groupByChannel.size());
        groupByChannel.forEach((channelId, advertList) -> {
            if (CollectionUtils.isNotEmpty((Collection)advertList)) {
                DynamicObject channel = ((DynamicObject)advertList.get(0)).getDynamicObject("channel");
                channels.add(channel);
                List advIds = advertList.stream().map(adv -> adv.getLong("id")).collect(Collectors.toList());
                String cacheKey = "cacheAdvStop_" + channelId;
                if (HRStringUtils.isEmpty((String)this.getPageCache().get(cacheKey))) {
                    this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(advIds));
                }
            }
        });
        Collections.sort(channels, (o1, o2) -> {
            long diff = o1.getLong("id") - o2.getLong("id");
            if (diff > 0L) {
                return 1;
            }
            if (diff == 0L) {
                return 0;
            }
            return -1;
        });
        return channels;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent event) {
        super.buildTreeListFilter(event);
        String nodeId = (String)event.getNodeId();
        String cache = this.getPageCache().get("cacheAdvStop_" + nodeId);
        List advertIds = Lists.newArrayList((Object[])new Long[]{0L});
        if (HRStringUtils.isNotEmpty((String)cache)) {
            advertIds = (List)SerializationUtils.fromJsonString((String)cache, List.class);
            String positionStatus = (String)this.getView().getFormShowParameter().getCustomParam("positionstatus");
            if (HRStringUtils.equals((String)positionStatus, (String)"D")) {
                this.selectChannelRows(advertIds);
            }
        }
        QFilter treeFilter = new QFilter("id", "in", (Object)advertIds);
        event.addQFilter(treeFilter);
    }

    private void selectChannelRows(List<Long> advertIds) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        for (Long advertId : advertIds) {
            ListSelectedRow row = new ListSelectedRow((Object)advertId);
            selectedRows.add((Object)row);
        }
        list.putSelectedRows(selectedRows);
    }

    public void initTreeToolbar(EventObject evt) {
        GroupProp groupProp = this.treeListView.getTreeModel().getGroupProp();
        if (!(groupProp instanceof ParentBasedataProp)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        OperationResult operationResult;
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"stopadvert") && this.validateOperationResult(operationResult = OperationServiceHelper.executeOperate((String)"stopright", (String)"tsirm_adverttplexlistb", (Object[])this.getSelectedRows().getPrimaryKeyValues(), (OperateOption)OperateOption.create()))) {
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)"stopadvertall")) {
            Map allCache = this.getPageCache().getAll();
            ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
            allCache.forEach((key, cacheIds) -> {
                if (key.startsWith("cacheAdvStop_")) {
                    this.setSelectAdvList((String)cacheIds, selectedRows);
                }
            });
            OperationResult operationResult2 = OperationServiceHelper.executeOperate((String)"stopright", (String)"tsirm_adverttplexlistb", (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)OperateOption.create());
            if (this.validateOperationResult(operationResult2)) {
                args.setCancel(true);
                return;
            }
            args.setListSelectedData(selectedRows);
        }
    }

    private boolean validateOperationResult(OperationResult operationResult) {
        ValidateResultCollection validateResult = operationResult.getValidateResult();
        if (null == validateResult || validateResult.isSuccess()) {
            return false;
        }
        this.getView().showOperationResult(operationResult);
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        return !CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"refresh")) {
            ((TreeView)this.getControl("treeview")).setRootVisible(false);
        }
    }

    private void setSelectAdvList(String advertListIdStr, ListSelectedRowCollection selectedRows) {
        List advertIds = (List)SerializationUtils.fromJsonString((String)advertListIdStr, List.class);
        advertIds.stream().forEach(advId -> {
            ListSelectedRow selectedRow = new ListSelectedRow();
            selectedRow.setSelected(true);
            selectedRow.setPrimaryKeyValue(advId);
            selectedRows.add((Object)selectedRow);
        });
    }
}

