/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.advertising.approval;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tsc.tsirm.business.domain.position.service.permission.PositionPermService;
import kd.tsc.tsirm.formplugin.web.advertising.AdvertFormHelper;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;

public class AdvertApprovalBillList
extends HRCoreBaseBillList {
    private static final Map<String, String> DATE_ENUM_MAP = Maps.newHashMap();
    public static final String VALUE = "68";

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        PositionPermService positionPermService = PositionPermService.getInstance(null);
        QFilter qFilter = positionPermService.getHavePermPositionQFilter();
        if (qFilter != null) {
            List hashPermPositionIds = positionPermService.listHavePermPosition(qFilter);
            setFilterEvent.addCustomQFilter(new QFilter("position.id", "in", (Object)hashPermPositionIds));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getFieldName();
        Long primaryKeyValue = (Long)this.getFocusRowPkId();
        if ("billno".equals(fieldName)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "close_approval_detail");
            AdvertFormHelper.getInstance().openAdvertApprovalDetailPage(this.getView(), primaryKeyValue, OperationStatus.VIEW, closeCallBack);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        ((IListColumn)listColumns.get(1)).setFixed(true);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        this.changeCommonFilterItem(commonFilterColumns);
        this.setCommonFilterColumnsDefaultValue(commonFilterColumns);
    }

    private void setCommonFilterColumnsDefaultValue(List<FilterColumn> commonFilterColumns) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String createTime = (String)formShowParameter.getCustomParam("createtime");
        if (HRStringUtils.isNotEmpty((String)createTime)) {
            for (FilterColumn filterColumn : commonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if ("createtime".equals(fieldName)) {
                    String defaultDeliverTime = DATE_ENUM_MAP.get(createTime);
                    if (!HRStringUtils.isNotEmpty((String)defaultDeliverTime)) continue;
                    filterColumn.setDefaultValues(new Object[]{DATE_ENUM_MAP.get(createTime)});
                    continue;
                }
                if (!"billstatus".equals(fieldName)) continue;
                filterColumn.setDefaultValues(new Object[]{"B", "G", "D"});
            }
        }
    }

    private void changeCommonFilterItem(List<FilterColumn> commonFilterColumns) {
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            List comboItems = ((CommonFilterColumn)commonFilterColumn).getComboItems();
            switch (fieldName) {
                case "billstatus": {
                    break;
                }
                case "createtime": {
                    comboItems.add(new ComboItem(null, VALUE));
                    break;
                }
            }
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        evt.setCancel(true);
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        Long primaryKeyValue = (Long)currentListSelectedRow.getPrimaryKeyValue();
        AdvertFormHelper.getInstance().openAdvertApprovalDetailPage(this.getView(), primaryKeyValue);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (HRStringUtils.equals((String)actionId, (String)"close_approval_detail") && HRStringUtils.isNotEmpty((String)returnData)) {
            this.getView().invokeOperation("refresh");
            this.getView().activate();
            this.getView().showSuccessNotification(returnData);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"advertlistdelete")) {
            this.getView().invokeOperation("refresh");
        }
    }

    static {
        DATE_ENUM_MAP.put(DatePeriodEnum.TODAY.getCode(), "13");
        DATE_ENUM_MAP.put(DatePeriodEnum.THIS_WEEK.getCode(), "10");
        DATE_ENUM_MAP.put(DatePeriodEnum.THIS_MONTH.getCode(), "63");
        DATE_ENUM_MAP.put(DatePeriodEnum.PAST_THREE_MONTH.getCode(), "24");
        DATE_ENUM_MAP.put(DatePeriodEnum.PAST_ONE_YEAR.getCode(), VALUE);
    }
}

