/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.advertising.approval;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.advert.service.AdvertApprovalDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertApprovalHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertPermHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertPublishHelper;
import kd.tsc.tsirm.business.domain.advert.service.state.ApprovalBillPageViewState;
import kd.tsc.tsirm.business.domain.advert.service.state.PageAdvertContext;
import kd.tsc.tsirm.business.domain.advert.service.state.StateChangeAdvertPage;
import kd.tsc.tsirm.business.domain.intreco.service.IntrecoPageHelper;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AdvertApprovalDetailPlugin
extends HRDataBaseEdit {
    private static final String MODULE = AdvertApprovalDetailPlugin.class.getName();
    private static final String[] UN_CHANGED_PROPS = new String[]{"posnumber", "isaudit"};
    private static AdvertPermHelper advertPermHelper = AdvertPermHelper.getInstance();
    private static final String ABANDON = "abandon";

    public void preOpenForm(PreOpenFormEventArgs event) {
        super.preOpenForm(event);
        Object pkId = ((BillShowParameter)event.getFormShowParameter()).getPkId();
        boolean exist = AdvertApprovalHelper.existById((Object)pkId);
        if (!exist) {
            event.setCancel(true);
            event.setCancelMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5e7f\u544a\u5ba1\u6279\u5355\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)(MODULE + "_1"), (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"closeap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (HRStringUtils.equals((String)key, (String)"closeap")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipsflex"});
        }
    }

    public void afterBindData(EventObject event) {
        this.changePageStatus();
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.initPosnumber();
        AdvertApprovalHelper.loadPublishAdvPage((IFormView)this.getView());
        this.getModel().setDataChanged(false);
    }

    private void initPosnumber() {
        DynamicObject approval = this.getModel().getDataEntity(true);
        DynamicObject position = approval.getDynamicObject("position");
        if (!HRObjectUtils.isEmpty((Object)position)) {
            this.getModel().setValue("posnumber", (Object)("\uff08" + position.getString("number") + "\uff09"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("edit".equals(operateKey)) {
            this.beforeEdit(args);
        } else if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"submit")) {
            this.beforeSubmit(args);
        } else if (HRStringUtils.equals((String)operateKey, (String)"advertdelete")) {
            this.beforeDel(args);
        } else if (HRStringUtils.equals((String)operateKey, (String)ABANDON) && HRStringUtils.isBlank((CharSequence)this.getView().getPageCache().get(ABANDON))) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5355\u636e\u5e9f\u5f03\u540e\u4e0d\u80fd\u6062\u590d\uff0c\u786e\u8ba4\u5e9f\u5f03\u5417\uff1f", (String)"AdverApprovalDetailPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ABANDON, (IFormPlugin)this));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operationKey = evt.getOperationKey();
        if ("edit".equals(operationKey)) {
            boolean lock = IntrecoPageHelper.isTakeViewLock((IFormView)this.getView(), (String)"modify");
            if (!lock) {
                evt.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)operationKey, (String)"close")) {
            this.showAllPageChangeTip(evt);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int resultValue = messageBoxClosedEvent.getResult().getValue();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (resultValue == MessageBoxResult.Yes.getValue() && StringUtils.equals((CharSequence)"datachange", (CharSequence)callBackId)) {
            this.getView().invokeOperation("close");
        }
        if (resultValue == MessageBoxResult.Yes.getValue() && StringUtils.equals((CharSequence)ABANDON, (CharSequence)callBackId)) {
            this.getView().getPageCache().put(ABANDON, "1");
            Object pkIdObject = this.getModel().getDataEntity().getPkValue();
            DynamicObject dynamicObject = TsrbsHelper.selectById((Long)Long.parseLong(pkIdObject.toString()), (String)this.getView().getEntityId());
            if (null == dynamicObject) {
                this.getView().getPageCache().remove(ABANDON);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"AdvertApprovalDetailPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            String billStatus = dynamicObject.getString("billstatus");
            if (!"G".equals(billStatus)) {
                this.getView().getPageCache().remove(ABANDON);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"AdvertApprovalDetailPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().invokeOperation(ABANDON);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"unsubmit")) {
            this.afterSubmitOrUn(args);
        } else if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            this.getView().updateView("billstatus");
            this.getView().updateView();
        } else if (HRStringUtils.equals((String)operateKey, (String)"advertdelete")) {
            this.afterDel(args);
        } else if ("edit".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.changeViewStatus(OperationStatus.EDIT);
        } else if (HRStringUtils.equals((String)operateKey, (String)ABANDON) && args.getOperationResult().isSuccess()) {
            this.getView().getPageCache().remove(ABANDON);
            this.getView().updateView();
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        event.setSkipNoField(true);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String unChangedProp : UN_CHANGED_PROPS) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)unChangedProp);
            if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) continue;
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
        this.getModel().updateCache();
    }

    private void changeViewStatus(OperationStatus operationStatus) {
        this.getView().setStatus(operationStatus);
        this.getView().cacheFormShowParameter();
        this.getView().invokeOperation("refresh");
    }

    private void showAllPageChangeTip(BeforeItemClickEvent evt) {
        IFormView publishView = AdvertPublishHelper.getPageFromCache((IFormView)this.getView(), (String)"cachePublicPageId");
        if (publishView.getModel().getDataChanged()) {
            AdvertBusinessHelper.showCustomConfirm((String)publishView.getModel().getChangeDesc(), (AbstractFormPlugin)this, (IFormView)this.getView());
            evt.setCancel(true);
            return;
        }
        Map allCache = publishView.getPageCache().getAll();
        for (Map.Entry entry : allCache.entrySet()) {
            IFormView channelView;
            if (!((String)entry.getKey()).startsWith("cache_channel_page_id_") || !(channelView = this.getView().getView((String)entry.getValue())).getModel().getDataChanged()) continue;
            AdvertBusinessHelper.showCustomConfirm((String)channelView.getModel().getChangeDesc(), (AbstractFormPlugin)this, (IFormView)this.getView());
            evt.setCancel(true);
            return;
        }
    }

    private void changePageStatus() {
        ApprovalBillPageViewState viewState = new ApprovalBillPageViewState();
        PageAdvertContext pageAdvertContext = new PageAdvertContext((StateChangeAdvertPage)viewState, this.getView());
        pageAdvertContext.changePageByState();
    }

    private void beforeDel(BeforeDoOperationEventArgs args) {
        DynamicObject approval = this.getModel().getDataEntity(true);
        DynamicObject approvalRet = AdvertApprovalDataHelper.getInstance().loadApprovalData(Long.valueOf(approval.getLong("id")));
        if (approvalRet == null) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)(MODULE + "_2"), (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
    }

    private void beforeSubmit(BeforeDoOperationEventArgs args) {
        if (!this.validateSaveOrEdite(args)) {
            this.getView().invokeOperation("refresh");
            return;
        }
        boolean b = AdvertApprovalHelper.assembleApprovalSnapByPage((IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
        if (!b) {
            return;
        }
        DynamicObject approval = this.getModel().getDataEntity(true);
        AdvertDetailExDataHelper.getInstance().saveAdvertModifyUser(approval);
    }

    private void beforeEdit(BeforeDoOperationEventArgs args) {
        DynamicObject approval = this.getModel().getDataEntity(true);
        Pair result = AdvertBusinessHelper.checkPositionAudit((DynamicObject)approval);
        if (!((Boolean)result.getLeft()).booleanValue()) {
            this.getView().showErrorNotification((String)result.getRight());
            args.setCancel(true);
            return;
        }
        this.validateSaveOrEdite(args);
    }

    private boolean validateSaveOrEdite(BeforeDoOperationEventArgs args) {
        Object pkIdObject = this.getModel().getDataEntity().getPkValue();
        DynamicObject dynamicObject = TsrbsHelper.selectById((Long)Long.parseLong(pkIdObject.toString()), (String)this.getView().getEntityId());
        String message = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"AdvertApprovalDetailPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        if (null == dynamicObject) {
            this.getView().showTipNotification(message);
            args.setCancel(true);
            return false;
        }
        String billStatus = dynamicObject.getString("billstatus");
        if (!"G".equals(billStatus) && !"A".equals(billStatus)) {
            this.getView().showTipNotification(message);
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private void afterDel(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (operationResult.isSuccess()) {
            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)(MODULE + "_3"), (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        this.getView().showErrorNotification(operationResult.getMessage());
    }

    private void afterSubmitOrUn(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        InteractionContext context = operationResult.getInteractionContext();
        if (null != context && HRStringUtils.equals((String)((String)context.getCustShowParameter().get("id")), (String)"0")) {
            this.getView().returnDataToParent((Object)operationResult.getMessage());
            this.getView().close();
            return;
        }
        if (operationResult.isSuccess() || HRStringUtils.equals((String)operationResult.getSponsor(), (String)"cancel")) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.getPageCache().put("datachange", "1");
            }
            this.changeViewStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
            if (HRStringUtils.equals((String)operationResult.getSponsor(), (String)"cancel")) {
                this.getView().showSuccessNotification(operationResult.getMessage());
            }
        }
    }
}

