/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.advertising.channel;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.cert.CertService;
import kd.tsc.tsirm.business.domain.pc.helper.EmpDeliveryHelper;
import kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService;
import kd.tsc.tsirm.common.util.FormShowUtils;
import kd.tsc.tsrbd.common.utils.PageUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ApplyPositionEdit
extends HRCoreBaseBillEdit {
    public static final String BAR_DELIV = "bar_deliv";

    public void afterBindData(EventObject e) {
        this.handleButtonVisible();
    }

    private void handleButtonVisible() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"viewappprgs", BAR_DELIV});
        DynamicObject[] empCVDys = PersonalCenterService.getInstance().getEmpCVs(Long.valueOf(RequestContext.get().getCurrUserId()));
        Long advertId = this.getModel().getDataEntity().getLong("id");
        DynamicObject latestDeliveryRecordDy = EmpDeliveryHelper.getLatestDeliveryRecordByAdvertId(Arrays.stream(empCVDys).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList()), (Long)advertId);
        if (ObjectUtils.isEmpty((Object)latestDeliveryRecordDy)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewappprgs"});
            if (!AdvertBusinessHelper.isAdvertCanDelivery((Long)advertId)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_DELIV});
            }
        } else {
            DynamicObject appFileDy = latestDeliveryRecordDy.getDynamicObject("appfile");
            if (AppFileHelper.isCanDeliveryAppFile((DynamicObject)appFileDy)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewappprgs"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_DELIV});
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BAR_DELIV.equals(itemKey)) {
            String state;
            this.checkAdvertState(evt);
            boolean cancel = evt.isCancel();
            if (!cancel && "FAIL".equals(state = CertService.getInstance().getVerifyCertResult(Long.valueOf(RequestContext.get().getCurrUserId())))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4f60\u7684\u8d26\u53f7\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u201c%S\u201d\u3002", (String)"HomePageApplyPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), CertService.getInstance().getCertTips()));
                evt.setCancel(true);
            }
        }
    }

    private void checkAdvertState(BeforeItemClickEvent evt) {
        Long advertId = this.getModel().getDataEntity().getLong("id");
        if (!AdvertBusinessHelper.isAdvertCanDelivery((Long)advertId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u804c\u4f4d\u5df2\u4e0b\u7ebf\u3002", (String)"ApplyPositionEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            this.getView().invokeOperation("refresh");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BAR_DELIV.equals(itemKey)) {
            this.openApplyPage();
        } else if ("viewappprgs".equals(itemKey)) {
            this.openApplyListPage();
        }
    }

    private void openApplyListPage() {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        long advertId = this.getModel().getDataEntity().getLong("id");
        customParams.put("advertId", advertId);
        customParams.put("activetab", "tabpageap1");
        String pageId = PageUtils.getPageId((String)String.valueOf(advertId), (String)"tsirm", (String)"tsirm_personalcenter", (String)this.getView().getFormShowParameter().getRootPageId());
        FormShowUtils.showPersonalCenter((String)"tabpageap1", (String)pageId, customParams, (IFormView)this.getView());
    }

    private void openApplyPage() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("tsirm_empcv_list");
        fsp.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u5e94\u8058", (String)"ApplyPositionEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.NonModal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsirm_empcv_list"));
        fsp.setCustomParam("positionId", (Object)this.getModel().getDataEntity().getLong("position.id"));
        fsp.setCustomParam("advertId", (Object)this.getModel().getDataEntity().getLong("id"));
        fsp.setCustomParam("advertName", (Object)this.getView().getModel().getDataEntity().getString("title_name"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("tsirm_empcv_list".equals(actionId) && "deliveryCV".equals(returnData)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

