/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.advertising.channel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsirm.business.domain.advert.service.AdvertApprovalHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertConfigHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertPublishHelper;
import kd.tsc.tsirm.business.domain.advert.service.state.ChannelDetailViewState;
import kd.tsc.tsirm.business.domain.advert.service.state.PageAdvertContext;
import kd.tsc.tsirm.business.domain.advert.service.state.StateChangeAdvertPage;
import kd.tsc.tsirm.business.domain.intreco.service.IntrecoPageHelper;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.business.license.VerifyCertTypeEnum;
import kd.tsc.tsirm.formplugin.service.AdvertService;
import kd.tsc.tsirm.formplugin.web.advertising.AdvertFormHelper;
import kd.tsc.tsrbd.business.application.external.auth.BizHRCSDataPermissionService;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ChannelAdvDetailPlugin
extends HRCoreBaseBillEdit
implements TabSelectListener,
BeforeF7SelectListener {
    private static final String MODULE = ChannelAdvDetailPlugin.class.getName();

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Toolbar scoreToolBar = (Toolbar)this.getView().getControl("tbmain");
        scoreToolBar.addItemClickListener((ItemClickListener)this);
        Tab appTabs = (Tab)this.getView().getControl("tabap");
        appTabs.addTabSelectListener((TabSelectListener)this);
        BasedataEdit recRuscene = (BasedataEdit)this.getControl("recruscene");
        recRuscene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit workaddr = (BasedataEdit)this.getControl("workaddr");
        workaddr.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Vector control = (Vector)this.getControl("vectorap");
        control.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        Object status;
        super.preOpenForm(e);
        BillShowParameter formShowParameter = (BillShowParameter)e.getFormShowParameter();
        if ("wftask".equals(formShowParameter.getAppId())) {
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_advertdetailex", (String)"47150e89000000ac");
            if (!hasPerm) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u62db\u8058\u5e7f\u544a\u201d\u7684\u201c\u67e5\u8be2\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ChannelAdvDetailPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            Object pkId = formShowParameter.getCustomParam("pkId");
            if (null == pkId) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u62db\u8058\u5e7f\u544a\u201d\u7684\u201c\u67e5\u8be2\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ChannelAdvDetailPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean hasDataPerm = this.getPermissionQFilter(Long.parseLong(pkId.toString()));
            if (!hasDataPerm) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u62db\u8058\u5e7f\u544a\u201d\u7684\u201c\u67e5\u8be2\u201d\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ChannelAdvDetailPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            formShowParameter.setAppId("tsirm");
            formShowParameter.setBillStatus(BillOperationStatus.VIEW);
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        if ("VIEW".equals(status = formShowParameter.getCustomParam("status"))) {
            formShowParameter.setStatus(OperationStatus.VIEW);
            String advertName = (String)formShowParameter.getCustomParam("caption");
            if (HRStringUtils.isBlank((CharSequence)advertName)) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_advertdetailex");
                Object pkId = formShowParameter.getCustomParam("pkId");
                if (null == pkId) {
                    return;
                }
                DynamicObject dynamicObject = serviceHelper.queryOne("name", (Object)Long.parseLong(pkId.toString()));
                if (null == dynamicObject) {
                    return;
                }
                advertName = dynamicObject.getString("name");
            }
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5e7f\u544a\u8be6\u60c5-{0}", (String)"ChannelAdvDetailPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{advertName}));
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.getModel().beginInit();
        this.renderHeadData();
        DynamicObject position = (DynamicObject)this.getModel().getValue("position");
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("from");
        if (HRStringUtils.isNotEmpty((String)customParam)) {
            this.getView().showTipNotification(customParam);
        }
        this.getModel().setDataChanged(false);
        AdvertPublishHelper.setPosOrgAndBu((IFormView)this.getView(), (DynamicObject)position);
        this.getModel().endInit();
    }

    private void renderHeadData() {
        long rewardPoint;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        OrmLocaleValue advName = (OrmLocaleValue)dataEntity.get("fullname");
        this.getModel().setValue("title_name", (Object)advName);
        DynamicObject channel = dataEntity.getDynamicObject("channel");
        this.getModel().setValue("channel_text", channel.get("name"));
        this.getModel().setValue("warntext", (Object)String.format(ResManager.loadKDString((String)"%s\u6e20\u9053\u5df2\u7981\u7528\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6e20\u9053\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ChannelAdvDetailPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), channel.getString("name")));
        boolean channelStatus = channel.getBoolean("enable");
        this.getView().setVisible(Boolean.valueOf(!channelStatus), new String[]{"channeldisableflex"});
        long reward = dataEntity.getLong("reward");
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"currencysign"});
        if (reward > 0L) {
            String formatVal = IntrecoPageHelper.getRewardTpl((DynamicObject)dataEntity);
            Label rewardLabel = (Label)this.getControl("title_reward");
            rewardLabel.setText(String.format(formatVal, reward));
            DynamicObject currency = this.getModel().getDataEntity().getDynamicObject("rewardcurrency");
            this.getView().setVisible(Boolean.TRUE, new String[]{"currencysign"});
            Label label = (Label)this.getControl("currencysign");
            label.setText(currency.getString("sign"));
        }
        if ((rewardPoint = dataEntity.getLong("rewardpoint")) > 0L) {
            String rewardPointText = IntrecoPageHelper.getRewardPointTpl((DynamicObject)dataEntity);
            Label rewardPointLabel = (Label)this.getControl("title_rewardpoint");
            rewardPointLabel.setText(rewardPointText);
        }
        DynamicObject position = (DynamicObject)this.getModel().getValue("position");
        String positionName = position.getString("name") + "\uff08" + position.getString("number") + "\uff09";
        this.getModel().setValue("position_name", (Object)positionName);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        ChannelDetailViewState pageViewState = new ChannelDetailViewState();
        PageAdvertContext pageAdvertContext = new PageAdvertContext((StateChangeAdvertPage)pageViewState, this.getView());
        pageAdvertContext.changePageByState();
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean validResult;
        Map verifyCert;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        DynamicObject advert = this.getModel().getDataEntity(true);
        if ("startadvert".equals(operateKey) && !(verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm")).isEmpty() && verifyCert.containsKey("infoType")) {
            String infoType = (String)verifyCert.get("infoType");
            if (VerifyCertTypeEnum.FORBIDDEN.getValue().equals(infoType)) {
                this.getView().showErrorNotification((String)verifyCert.get("message"));
                args.setCancel(true);
            }
        }
        if (HRStringUtils.equals((String)operateKey, (String)"advpreview")) {
            AdvertBusinessHelper.previewAdvert((IFormView)this.getView(), (Long)advert.getLong("id"));
        } else if (HRStringUtils.equals((String)operateKey, (String)"savewithnoaudit") && !(validResult = AdvertPublishHelper.validateOperator((IFormView)this.getView()))) {
            args.setCancel(true);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Map verifyCert;
        String operationKey = evt.getOperationKey();
        if ("startadvert".equals(operationKey) && !(verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm")).isEmpty() && verifyCert.containsKey("infoType")) {
            String infoType = (String)verifyCert.get("infoType");
            if (VerifyCertTypeEnum.WARNING.getValue().equals(infoType) || VerifyCertTypeEnum.EXCEED.getValue().equals(infoType)) {
                this.getView().showTipNotification((String)verifyCert.get("message"));
            }
        }
        if (HRStringUtils.equals((String)operationKey, (String)"edit") || HRStringUtils.equals((String)operationKey, (String)"waitpubmodify")) {
            boolean lock;
            DynamicObject advert = this.getModel().getDataEntity(true);
            if (!AdvertConfigHelper.needAuditByChannel((DynamicObject)advert).booleanValue() && !(lock = IntrecoPageHelper.isTakeViewLock((IFormView)this.getView(), (String)"modify"))) {
                evt.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)operationKey, (String)"close") && this.getModel().getDataChanged() && IntrecoPageHelper.getPageStatus((IFormView)this.getView()).getValue() == OperationStatus.VIEW.getValue()) {
            AdvertBusinessHelper.showCustomConfirm((String)this.getModel().getChangeDesc(), (AbstractFormPlugin)this, (IFormView)this.getView());
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int resultValue = messageBoxClosedEvent.getResult().getValue();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (resultValue == MessageBoxResult.Yes.getValue() && StringUtils.equals((CharSequence)"datachange", (CharSequence)callBackId)) {
            this.getView().invokeOperation("close");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (HRStringUtils.equals((String)operateKey, (String)"stopadvert") || HRStringUtils.equals((String)operateKey, (String)"refreashadvert")) {
            IFormView parentView;
            this.getView().invokeOperation("refresh");
            if (operationResult.isSuccess() && (parentView = this.getView().getParentView()) != null) {
                parentView.getPageCache().put("datachange", "1");
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"savewithnoaudit")) {
            this.afterSaveWithNoAudit(operationResult);
        } else if (HRStringUtils.equals((String)operateKey, (String)"refresh")) {
            this.afterRefresh();
        } else if (HRStringUtils.equals((String)operateKey, (String)"startadvert")) {
            this.afterEnable(operationResult);
        } else if (HRStringUtils.equals((String)operateKey, (String)"waitpubmodify")) {
            this.afterModify(operationResult);
        } else if (HRStringUtils.equals((String)operateKey, (String)"edit")) {
            this.afterApplicationModify(operationResult);
        } else {
            ArrayList topOrUrgentOpKeyList = Lists.newArrayList((Object[])new String[]{"top", "untop", "urgent", "unurgent"});
            if (topOrUrgentOpKeyList.contains(operateKey)) {
                if (operationResult.isSuccess() && CollectionUtils.isEmpty((Collection)operationResult.getAllErrorOrValidateInfo())) {
                    AdvertService.getInstance().afterTopOrUrgent(operateKey, this.getView());
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        String cardListPageId = this.getPageCache().get("tabadvertaudit");
        if (HRStringUtils.equals((String)tabKey, (String)"tabadvertaudit") && HRStringUtils.isEmpty((String)cardListPageId)) {
            AdvertFormHelper.getInstance().openAdvApprovalCardList(this.getView(), this.getModel().getValue("id"));
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String name = evt.getProperty().getName();
        ChangeData changeData = evt.getChangeSet()[0];
        AdvertBusinessHelper.isRewardSwitch((String)name, (ChangeData)changeData, (IFormView)this.getView());
        AdvertPublishHelper.salaryTypePropertyChange((String)name, (IFormView)this.getView());
        AdvertPublishHelper.currencyPropertyChange((String)name, (IFormView)this.getView());
        AdvertPublishHelper.otherPropertyChange((String)name, (IFormView)this.getView());
        AdvertPublishHelper.rangeDatePropertyChange((String)name, (IFormView)this.getView());
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject createOrg = this.getModel().getDataEntity().getDynamicObject("advertbuorg");
        AdvertPublishHelper.initAdvertF7Element((ListShowParameter)formShowParameter, (String)property, (DynamicObject)createOrg);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        AdvertApprovalHelper.solveApprovalCallBack((IFormView)this.getView(), (ClosedCallBackEvent)closedCallBackEvent);
    }

    private void afterSaveWithNoAudit(OperationResult operationResult) {
        if (operationResult.isSuccess() || HRStringUtils.equals((String)operationResult.getSponsor(), (String)"cancel")) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            this.getView().showSuccessNotification(operationResult.getMessage());
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.getPageCache().put("datachange", "1");
            }
            this.getView().invokeOperation("refresh");
            if (null == operationResult.getInteractionContext()) {
                return;
            }
            Map param = operationResult.getInteractionContext().getCustShowParameter();
            if (MapUtils.isNotEmpty((Map)param) && HRStringUtils.isNotEmpty((String)((String)param.get("id")))) {
                String billId = (String)param.get("id");
                HashMap approvalParam = Maps.newHashMapWithExpectedSize((int)1);
                approvalParam.put("from", ResManager.loadKDString((String)"\u53d1\u8d77\u5ba1\u6279\u3002", (String)(MODULE + "_0"), (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                AdvertFormHelper.getInstance().openAdvertApprovalDetailPage(this.getView(), Long.valueOf(billId), OperationStatus.VIEW, null, approvalParam);
            }
        }
    }

    private void afterEnable(OperationResult operationResult) {
        if (operationResult.isShowMessage()) {
            return;
        }
        AdvertBusinessHelper.showEnableAdvTip((IFormView)this.getView(), (OperationResult)operationResult);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.getPageCache().put("datachange", "1");
        }
        this.getView().invokeOperation("refresh");
    }

    private void afterModify(OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            return;
        }
        long billId = Long.parseLong(operationResult.getMessage());
        if (billId == 0L) {
            AdvertPublishHelper.changePageForEdit((IFormView)this.getView());
        } else {
            HashMap param = Maps.newHashMapWithExpectedSize((int)1);
            param.put("waitpubmodify", "1");
            AdvertFormHelper.getInstance().openAdvertApprovalDetailPage(this.getView(), billId, OperationStatus.EDIT, new CloseCallBack((IFormPlugin)this, "close_approval_detail"), param);
        }
    }

    private void afterRefresh() {
        String cardListPageId = this.getPageCache().get("tabadvertaudit");
        if (HRStringUtils.isEmpty((String)cardListPageId)) {
            return;
        }
        IFormView cardListPageView = this.getView().getView(cardListPageId);
        cardListPageView.invokeOperation("refresh");
        this.getView().sendFormAction(cardListPageView);
    }

    private void afterApplicationModify(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            long billId = Long.parseLong(operationResult.getMessage());
            if (billId == 0L) {
                AdvertPublishHelper.changePageForEdit((IFormView)this.getView());
            } else {
                AdvertFormHelper.getInstance().openAdvertApprovalDetailPage(this.getView(), billId, OperationStatus.EDIT, new CloseCallBack((IFormPlugin)this, "close_approval_detail"));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("vectorap".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"channeldisableflex"});
        }
    }

    private boolean getPermissionQFilter(Long id) {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (superUser) {
            return true;
        }
        QFilter dataRuleFilter = BizHRCSDataPermissionService.getDataRule((Long)currUserId, (String)"tsirm", (String)"tsirm_advertdetailex", (String)"47150e89000000ac", null);
        QFilter idQFilter = new QFilter("id", "=", (Object)id);
        DynamicObject[] advertListByFilter = AdvertDetailExDataHelper.getInstance().getAdvertListByFilter(new QFilter[]{dataRuleFilter, idQFilter}, "");
        return advertListByFilter != null && advertListByFilter.length > 0;
    }
}

