/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.advertising.channel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.advert.service.AdvertApprovalHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertPublishHelper;
import kd.tsc.tsirm.business.domain.advert.service.state.ChannelPageViewState;
import kd.tsc.tsirm.business.domain.advert.service.state.PageAdvertContext;
import kd.tsc.tsirm.business.domain.advert.service.state.StateChangeAdvertPage;
import kd.tsc.tsirm.business.domain.advert.service.valid.FieldValidHelper;
import kd.tsc.tsirm.business.domain.intreco.service.IntrecoPageHelper;
import kd.tsc.tsirm.common.enums.advert.ChannelFieldEnum;
import kd.tsc.tsrbd.business.domain.channel.service.RecruchnlnmService;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;

public class ChannelAdvertFlexEdit
extends HRDataBaseEdit {
    private static final String[] OPT_UP_ARR = new String[]{"uptext", "upicon"};
    private static final String[] OPT_DOWN_ARR = new String[]{"downtext", "downicon"};
    private static final String[] OPT_ALL_ARR = (String[])ArrayUtils.addAll((Object[])OPT_UP_ARR, (Object[])OPT_DOWN_ARR);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(OPT_ALL_ARR);
        this.addClickListeners(new String[]{"delchannel"});
    }

    public void afterCreateNewData(EventObject evt) {
        FormShowParameter param = this.getView().getFormShowParameter();
        this.setReqOrg(param);
        this.setAdminOrgs(param);
        this.setRewardRule(param);
        this.setApprovalData(param);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        ChannelPageViewState pageViewState = new ChannelPageViewState();
        PageAdvertContext pageAdvertContext = new PageAdvertContext((StateChangeAdvertPage)pageViewState, this.getView());
        pageAdvertContext.changePageByState();
    }

    private void setApprovalData(FormShowParameter param) {
        DynamicObject advSnap;
        Long channelId = Long.parseLong((String)param.getCustomParam("channel"));
        DynamicObject approval = (DynamicObject)IntrecoPageHelper.getPageCache((String)"advertApprovalCacheId", (IPageCache)this.getView().getParentView().getPageCache());
        if (!HRObjectUtils.isEmpty((Object)approval) && !HRObjectUtils.isEmpty((Object)(advSnap = AdvertApprovalHelper.getAdvByChannelSnap((DynamicObject)approval, (Long)channelId)))) {
            this.setSnapDataToPage(advSnap, channelId);
        }
        this.getModel().setValue("channel", (Object)channelId);
        DynamicObject channel = RecruchnlnmService.getChannelById((Long)channelId);
        this.getModel().setValue("channelname", (Object)channel.getString("name"));
    }

    private void setRewardRule(FormShowParameter param) {
        JSONObject rewardRule = (JSONObject)param.getCustomParam("rewardruleresult");
        this.getModel().setValue("isreward", param.getCustomParam("isreward"));
    }

    private void setReqOrg(FormShowParameter param) {
        JSONObject reqOrg = (JSONObject)param.getCustomParam("reqorg");
        if (MapUtils.isNotEmpty((Map)reqOrg)) {
            HashMap orgMap = (HashMap)JSON.parseObject((String)reqOrg.toJSONString(), HashMap.class);
            LocaleString localeString = LocaleString.fromMap((Map)orgMap);
            this.getModel().setValue("reqorg", (Object)localeString);
        }
    }

    private void setAdminOrgs(FormShowParameter param) {
        JSONArray adminOrgs = (JSONArray)param.getCustomParam("adminorgsdpt");
        if (!Objects.isNull(adminOrgs) && !adminOrgs.isEmpty()) {
            ArrayList objects = Lists.newArrayListWithCapacity((int)adminOrgs.size());
            for (Object org : adminOrgs) {
                Long adminOrg = ((JSONObject)((JSONObject)org).get((Object)"fbasedataid")).getLong("id");
                objects.add(adminOrg);
            }
            this.getModel().setValue("adminorgsdpt", (Object)objects.toArray(new Object[]{0}));
        }
    }

    private void setSnapDataToPage(DynamicObject advSnap, Long channelId) {
        Object[] fieldsByChannel = ChannelFieldEnum.getFieldsByChannel((long)channelId);
        if (ArrayUtils.isEmpty((Object[])fieldsByChannel)) {
            return;
        }
        IDataModel model = this.getView().getModel();
        for (Object field : fieldsByChannel) {
            model.setValue((String)field, advSnap.get((String)field));
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String name = evt.getProperty().getName();
        ChangeData changeData = evt.getChangeSet()[0];
        this.isCheckChannelSwitch(name, changeData);
        AdvertBusinessHelper.isRewardSwitch((String)name, (ChangeData)changeData, (IFormView)this.getView());
        FieldValidHelper helper = new FieldValidHelper(this.getView());
        if (StringUtils.equals((CharSequence)name, (CharSequence)"reward")) {
            helper.validFieldNumber(name);
        }
        AdvertPublishHelper.rangeDatePropertyChange((String)name, (IFormView)this.getView());
    }

    private void isCheckChannelSwitch(String name, ChangeData changeData) {
        if (StringUtils.equals((CharSequence)name, (CharSequence)"selectedchannel")) {
            FormShowParameter param = this.getView().getFormShowParameter();
            Long channelId = Long.parseLong((String)param.getCustomParam("channel"));
            DynamicObject channel = RecruchnlnmService.getChannelById((Long)channelId);
            Boolean isShow = (Boolean)changeData.getNewValue();
            if (isShow.booleanValue()) {
                AdvertPublishHelper.addSelectChannel((DynamicObject)channel, (IFormView)this.getView());
                this.getView().getParentView().getPageCache().put("cache_channel_page_id_" + channelId, this.getView().getPageId());
            } else {
                DynamicObject parentAdvert = this.getView().getParentView().getModel().getDataEntity(true);
                DynamicObjectCollection selectChannels = parentAdvert.getDynamicObjectCollection("selectpubchannel");
                AdvertPublishHelper.deleteSelectChannel((DynamicObjectCollection)selectChannels, Collections.singletonList(channel.getLong("id")));
                parentAdvert.set("selectpubchannel", (Object)selectChannels);
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().getParentView().getPageCache().remove("cache_channel_page_id_" + channelId);
            }
        }
    }

    public void click(EventObject evt) {
        Control sControl = (Control)evt.getSource();
        String key = sControl.getKey();
        if ("delchannel".equals(key)) {
            this.getModel().setValue("selectedchannel", (Object)false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
        }
    }
}

