/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.appfile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.form.AppFileFormHelper;
import kd.tsc.tsirm.business.domain.appfile.form.AppFileTabHelper;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileOfferHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsirm.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tsirm.common.constants.appfile.AppFileTabEnum;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tsrbs.common.utils.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileEdit
extends HRDataBaseEdit {
    private static final String KEY_REDELIVERYNUM = "redeliverynum";
    private static final String KEY_REDELIVERYNUMTXT = "redeliverynumtxt";
    public static final String KEY_TABORIGINRSM = "taboriginrsm";
    private static final String KEY_ORIGINRESFLEX = "originresflex";
    private static final String KEY_FLEXAPPRSM = "flexapprsm";
    private static final String KEY_REPEATDELIVERFLEX = "flexpanelap15";
    private static final String KEY_OTHERAPPFLEX = "tabotherapp";
    private static final String KEY_APPRES_PAGE = "apprespageid";
    private static final String KEY_TABOFFER = "taboffer";
    private static final String KEY_TABHIRE = "tabhire";
    private static final String KEY_OPRECORD = "taboprecord";
    private Boolean isInProcess = Boolean.FALSE;
    private String fileStatus = null;
    private OperationStatus subViewStatus = OperationStatus.VIEW;
    private static final List<String> HIDE_OP_A = ImmutableList.of((Object)AppFileOperateEnum.ARCHIVE.getCtrlKey(), (Object)AppFileOperateEnum.RECOVER.getCtrlKey());
    private static final List<String> HIDE_OP_B = ImmutableList.of((Object)AppFileOperateEnum.CHANGESTAGE.getCtrlKey(), (Object)AppFileOperateEnum.ELIMINATE.getCtrlKey(), (Object)AppFileOperateEnum.LOCK.getCtrlKey(), (Object)AppFileOperateEnum.UNLOCK.getCtrlKey(), (Object)AppFileOperateEnum.FILTER.getCtrlKey(), (Object)AppFileOperateEnum.ARRANGEANINTERVIEW.getCtrlKey(), (Object)AppFileOperateEnum.HIREAPPROVAL.getCtrlKey(), (Object)AppFileOperateEnum.ARCHIVE.getCtrlKey());
    private static final List<String> HIDE_OP_C = ImmutableList.of((Object)AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), (Object)AppFileOperateEnum.ELIMINATE.getCtrlKey(), (Object)AppFileOperateEnum.RECOVER.getCtrlKey(), (Object)AppFileOperateEnum.FILTER.getCtrlKey(), (Object)AppFileOperateEnum.ARRANGEANINTERVIEW.getCtrlKey(), (Object)AppFileOperateEnum.HIREAPPROVAL.getCtrlKey());
    private static final List<String> HIDE_OP_D = ImmutableList.of((Object)AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), (Object)AppFileOperateEnum.CHANGESTAGE.getCtrlKey(), (Object)AppFileOperateEnum.ELIMINATE.getCtrlKey(), (Object)AppFileOperateEnum.RECOVER.getCtrlKey(), (Object)AppFileOperateEnum.FILTER.getCtrlKey(), (Object)AppFileOperateEnum.ARRANGEANINTERVIEW.getCtrlKey(), (Object)AppFileOperateEnum.HIREAPPROVAL.getCtrlKey(), (Object)AppFileOperateEnum.ARCHIVE.getCtrlKey());
    private static final List<String> HIDE_OP_E = ImmutableList.of((Object)AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), (Object)AppFileOperateEnum.CHANGESTAGE.getCtrlKey(), (Object)AppFileOperateEnum.ELIMINATE.getCtrlKey(), (Object)AppFileOperateEnum.RECOVER.getCtrlKey(), (Object)AppFileOperateEnum.FILTER.getCtrlKey(), (Object)AppFileOperateEnum.ARRANGEANINTERVIEW.getCtrlKey(), (Object)AppFileOperateEnum.HIREAPPROVAL.getCtrlKey(), (Object)AppFileOperateEnum.ARCHIVE.getCtrlKey());
    private static final List<String> HIDE_OP_F = ImmutableList.of((Object)AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), (Object)AppFileOperateEnum.CHANGESTAGE.getCtrlKey(), (Object)AppFileOperateEnum.ELIMINATE.getCtrlKey(), (Object)AppFileOperateEnum.RECOVER.getCtrlKey(), (Object)AppFileOperateEnum.LOCK.getCtrlKey(), (Object)AppFileOperateEnum.UNLOCK.getCtrlKey(), (Object)AppFileOperateEnum.FILTER.getCtrlKey(), (Object)AppFileOperateEnum.ARRANGEANINTERVIEW.getCtrlKey(), (Object)AppFileOperateEnum.HIREAPPROVAL.getCtrlKey(), (Object)AppFileOperateEnum.ARCHIVE.getCtrlKey(), (Object)AppFileOperateEnum.SENDMSG.getCtrlKey(), (Object)AppFileOperateEnum.REGMARK.getCtrlKey(), (Object[])new String[0]);
    private static final List<String> HIDE_OP_G = ImmutableList.of((Object)AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), (Object)AppFileOperateEnum.CHANGESTAGE.getCtrlKey(), (Object)AppFileOperateEnum.ELIMINATE.getCtrlKey(), (Object)AppFileOperateEnum.RECOVER.getCtrlKey(), (Object)AppFileOperateEnum.LOCK.getCtrlKey(), (Object)AppFileOperateEnum.UNLOCK.getCtrlKey(), (Object)AppFileOperateEnum.FILTER.getCtrlKey(), (Object)AppFileOperateEnum.ARRANGEANINTERVIEW.getCtrlKey(), (Object)AppFileOperateEnum.HIREAPPROVAL.getCtrlKey(), (Object)AppFileOperateEnum.ARCHIVE.getCtrlKey(), (Object)AppFileOperateEnum.SENDMSG.getCtrlKey(), (Object)AppFileOperateEnum.REGMARK.getCtrlKey(), (Object[])new String[0]);
    private static final Map<String, List<String>> HIDE_OP_MAP = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
        {
            this.put(AppFileConstants.APP_FILE_STATUS_IN, HIDE_OP_A);
            this.put(AppFileConstants.APP_FILE_STATUS_OUT, HIDE_OP_B);
            this.put(AppFileConstants.APP_FILE_STATUS_TBEMP, HIDE_OP_C);
            this.put(AppFileConstants.APP_FILE_STATUS_EMPED, HIDE_OP_D);
            this.put(AppFileConstants.APP_FILE_STATUS_ENDEMP, HIDE_OP_E);
            this.put(AppFileConstants.APP_FILE_STATUS_INVALID, HIDE_OP_F);
            this.put(AppFileConstants.APP_FILE_STATUS_EXPIRED, HIDE_OP_G);
        }
    });

    public void preOpenForm(PreOpenFormEventArgs args) {
        String name;
        DynamicObject appFile;
        Long pkId;
        BillShowParameter showParameter = (BillShowParameter)args.getFormShowParameter();
        if (showParameter.getPkId() == null && showParameter.getCustomParam("id") != null) {
            pkId = Long.valueOf((String)showParameter.getCustomParam("id"));
            showParameter.setPkId((Object)pkId);
        }
        if (showParameter.getPkId() != null && (appFile = AppFileDataHelper.queryAppFileById((Object)(pkId = Long.valueOf(showParameter.getPkId().toString())))) != null && HRStringUtils.isNotEmpty((String)(name = appFile.getString("name")))) {
            if (name.length() > 8) {
                name = name.substring(0, 8) + "...";
            }
            showParameter.setCaption(String.format(Locale.ROOT, AppFileResManagerHelper.getAppFileTabName(), name));
        }
    }

    public void registerListener(EventObject evt) {
    }

    public void beforeBindData(EventObject evt) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.fileStatus = dataEntity.getString("filestatus");
        this.isInProcess = AppFileHelper.isInProcess((String)this.fileStatus);
        String parentKey = (String)this.getView().getFormShowParameter().getCustomParam("parent_key");
        if (parentKey != null) {
            this.getView().getPageCache().put("parent_key", parentKey);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"othertab"});
        } else {
            this.getView().getPageCache().put("parent_key", this.getView().getParentView().getFormShowParameter().getFormId());
        }
        if (this.isInProcess.booleanValue()) {
            Object isOnlyView = this.getView().getFormShowParameter().getCustomParam("isOnlyView");
            if (null != isOnlyView) {
                this.subViewStatus = OperationStatus.VIEW;
                this.getView().getPageCache().put("parent_key", "tsrbs_commrec");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"othertab"});
            } else {
                this.subViewStatus = this.getView().getFormShowParameter().getStatus();
            }
            Object isEdit = this.getView().getFormShowParameter().getCustomParam("isEdit");
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)isEdit)) {
                this.subViewStatus = OperationStatus.EDIT;
            }
        }
        this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void afterBindData(EventObject evt) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.initPanel(dataEntity);
        this.showOtherPageMsg();
        this.initTab();
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        String rsmViewPageId = this.getPageCache().get(KEY_APPRES_PAGE);
        IFormView rsmView = this.getView().getView(rsmViewPageId);
        if (null != rsmView) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("tsirm_srrsm", (IFormPlugin)this);
            if (!RsmHelper.showDataChangeForm((IFormView)rsmView, (IFormView)this.getView(), (ConfirmCallBackListener)confirmCallBackListener)) {
                this.getPageCache().remove(KEY_APPRES_PAGE);
                this.getView().close();
            } else {
                evt.setCancel(true);
            }
        }
        evt.setSkipNoField(true);
        evt.setCheckDataChange(false);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "tsirm_srrsm": {
                this.getPageCache().remove(KEY_APPRES_PAGE);
                this.getView().close();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            switch (callBackId) {
                case "tsirm_srrsm": {
                    this.getPageCache().remove(KEY_APPRES_PAGE);
                    this.getView().close();
                    break;
                }
            }
        }
    }

    private void showOtherPageMsg() {
        String successMsg = (String)this.getView().getFormShowParameter().getCustomParam("successMsg");
        if (HRStringUtils.isNotEmpty((String)successMsg)) {
            if (SrRsmKDString.addNewSuccessBlackList().equals(successMsg)) {
                this.getView().showTipNotification(successMsg);
            } else {
                this.getView().showSuccessNotification(successMsg);
            }
            this.getView().getFormShowParameter().getCustomParams().remove("successMsg");
            this.getView().cacheFormShowParameter();
        }
    }

    private void initPanel(DynamicObject dataEntity) {
        HashSet hideCtrlKey = Sets.newHashSetWithExpectedSize((int)4);
        AppFileFormHelper.showAppFileHeaderForm((IFormView)this.getView(), (long)dataEntity.getLong("id"), (String)"flex_head", null);
        this.handleShowAddOfferBtn(dataEntity, hideCtrlKey);
        this.showProcessOp(hideCtrlKey);
        AppFileHelper.checkAppFilePermAndSetVisible((IFormView)this.getView(), (Set)hideCtrlKey);
        long procId = dataEntity.getLong("recruproc.id");
        long stgId = ObjectUtils.getLongValOfObject((Object)dataEntity.get("recrustg"));
        Pair operationVisibleTuple = Pair.of((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        AppFileListHelper.handleOperateVisible((long)procId, (long)stgId, (Pair)operationVisibleTuple);
        this.getView().setVisible(Boolean.FALSE, ((Collection)operationVisibleTuple.getRight()).toArray(new String[0]));
    }

    private void showProcessOp(Set<String> hideCtrlKey) {
        List<String> hideOps = HIDE_OP_MAP.get(this.fileStatus);
        if (hideOps != null) {
            this.getView().setVisible(Boolean.valueOf(false), hideOps.toArray(new String[0]));
            hideCtrlKey.addAll(hideOps);
        }
    }

    private void handleShowAddOfferBtn(DynamicObject dataEntity, Set<String> hideCtrlKey) {
        Long appFileOrgId = dataEntity.getLong("createorg.id");
        if (AppFileOfferHelper.validateInOfferStage((DynamicObject)dataEntity) && AppFileOfferHelper.validateOfferStatus((DynamicObject)dataEntity) && this.isInProcess.booleanValue() && AppFileOfferHelper.hasAddOfferRight((Long)appFileOrgId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.BARADDOFFER.getCtrlKey()});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.BARADDOFFER.getCtrlKey()});
            hideCtrlKey.add(AppFileOperateEnum.BARADDOFFER.getCtrlKey());
        }
    }

    private void initTab() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long appFileId = dataEntity.getLong("id");
        DynamicObject appRes = dataEntity.getDynamicObject("appres");
        if (appRes != null) {
            AppFileTabHelper.showAppResPage((String)KEY_FLEXAPPRSM, (String)KEY_APPRES_PAGE, (AbstractFormPlugin)this, (DynamicObject)appRes, (OperationStatus)this.subViewStatus);
        }
        AppFileTabHelper.showExamWrittenTab((Long)appFileId, (String)"tabexamwritten", (IFormView)this.getView(), (OperationStatus)this.subViewStatus);
        AppFileTabHelper.showExaminationTab((Long)appFileId, (String)"tabexamination", (IFormView)this.getView(), (OperationStatus)this.subViewStatus);
        AppFileTabHelper.initOtherTab((String)KEY_OTHERAPPFLEX, (DynamicObject)dataEntity, (IFormView)this.getView());
        AppFileTabHelper.initAssessTab((String)"tabevalinfo", (String)"panel_interview", (String)"panel_filterfeedback", (Long)appFileId, (IFormView)this.getView(), (OperationStatus)this.subViewStatus);
        AppFileTabHelper.initHireTab((String)KEY_TABHIRE, (DynamicObject)dataEntity, (IFormView)this.getView(), (OperationStatus)this.subViewStatus);
        AppFileTabHelper.initOpRecordTab((String)KEY_OPRECORD, (DynamicObject)dataEntity, (IFormView)this.getView());
        if (HRStringUtils.equals((String)this.getPageCache().get("parent_key"), (String)"wf_msg_center")) {
            AppFileTabHelper.activeTab((IFormView)this.getView(), (AppFileTabEnum)AppFileTabEnum.EVL_INFO);
        } else {
            AppFileTabHelper.activeTab((IFormView)this.getView(), (AppFileTabEnum)AppFileTabEnum.CHL_RSM);
        }
        this.getPageCache().put("isFirstEnter", "0");
    }
}

