/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.appfile;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sdk.tsc.tsirm.extpoint.appfile.IChangeStageStatusService;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.ChangeStageStatusHelper;
import kd.tsc.tsirm.common.entity.appfile.ProcessStaStatus;
import org.apache.commons.lang3.StringUtils;

public class ChangeStageStatusPlugin
extends HRDynamicFormBasePlugin {
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult.isSuccess()) {
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
            this.getView().close();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption operateOption = OperateOption.create();
        List appFileIdList = (List)this.getView().getFormShowParameter().getCustomParam("appFileIdList");
        String appFileIdStr = SerializationUtils.toJsonString((Object)appFileIdList);
        operateOption.setVariableValue("appFileIdList", appFileIdStr);
        formOperate.setOption(operateOption);
    }

    public void beforeBindData(EventObject evt) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"recruitmentstatus", "reason"});
        this.loadProcessSSR(this.getProcessId());
    }

    private void loadProcessSSR(long processId) {
        IPageCache pageCache = this.getPageCache();
        ProcessStaStatus proStageStatus = new ProcessStaStatus();
        proStageStatus.setProcessId(processId);
        DynamicObjectCollection stageColl = ChangeStageStatusHelper.queryProcessEntryStage((long)processId);
        if (stageColl.isEmpty()) {
            return;
        }
        LinkedHashMap<String, String> stageMap = new LinkedHashMap<String, String>(stageColl.size());
        LinkedHashMap statusMap = new LinkedHashMap(stageColl.size());
        ArrayList<String> filterStageList = new ArrayList<String>(8);
        ArrayList<String> filterStatusList = new ArrayList<String>(8);
        this.filterStage(filterStageList);
        for (DynamicObject stage : stageColl) {
            String stageId;
            DynamicObject stageObj = stage.getDynamicObject("rqmtstg");
            if (stageObj == null || filterStageList.contains(stageId = stageObj.getString("id"))) continue;
            stageMap.put(stageObj.getString("id"), stageObj.getString("name"));
            DynamicObjectCollection statusColl = stage.getDynamicObjectCollection("subentryentity");
            if (statusColl.isEmpty()) continue;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(statusColl.size());
            for (DynamicObject status : statusColl) {
                String statdKey;
                this.filterStatus(filterStatusList, stageId);
                DynamicObject statusObj = status.getDynamicObject("jobstatus");
                if (null == statusObj || filterStatusList.contains(statdKey = statusObj.getString("id"))) continue;
                map.put(statdKey, statusObj.getString("name"));
            }
            statusMap.put(stageObj.getString("id"), map);
        }
        proStageStatus.setStageMap(stageMap);
        proStageStatus.setStatusMap(statusMap);
        String key = "PROCESS-" + this.getView().getPageId();
        pageCache.put(key, SerializationUtils.toJsonString((Object)proStageStatus));
    }

    private ProcessStaStatus getProcessStaStatus() {
        String key = "PROCESS-" + this.getView().getPageId();
        String value = this.getPageCache().get(key);
        return (ProcessStaStatus)SerializationUtils.fromJsonString((String)value, ProcessStaStatus.class);
    }

    private void filterStage(List<String> list) {
        HRPluginProxy proxy = HRPlugInProxyFactory.create(null, IChangeStageStatusService.class, (String)"kd.sdk.tsc.tsirm.extpoint.appfile.IChangeStageStatusService", null);
        proxy.callReplaceIfPresent(plugin -> {
            if (plugin != null) {
                JSONArray jsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("appFileIdList");
                List collect = Arrays.stream(jsonArray.toArray()).map(String::valueOf).collect(Collectors.toList());
                list.addAll(plugin.filterStage(collect));
            }
            return null;
        });
    }

    private void filterStatus(List<String> list, String stageId) {
        HRPluginProxy proxy = HRPlugInProxyFactory.create(null, IChangeStageStatusService.class, (String)"kd.sdk.tsc.tsirm.extpoint.appfile.IChangeStageStatusService", null);
        proxy.callReplaceIfPresent(plugin -> {
            if (plugin != null) {
                JSONArray jsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("appFileIdList");
                List collect = Arrays.stream(jsonArray.toArray()).map(String::valueOf).collect(Collectors.toList());
                list.addAll(plugin.filterStatus(collect, stageId));
            }
            return null;
        });
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String property = evt.getProperty().getName();
        String newValue = (String)evt.getChangeSet()[0].getNewValue();
        String oldValue = (String)evt.getChangeSet()[0].getOldValue();
        if (HRStringUtils.equals((String)"recruitmentstage", (String)property)) {
            this.handlerChangedStage(newValue, oldValue);
        } else if (HRStringUtils.equals((String)"recruitmentstatus", (String)property)) {
            this.handlerChangedStatus(newValue, oldValue);
        }
    }

    private void handlerChangedStatus(String newValue, String oldValue) {
        if (null != newValue) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"reason"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"reason"});
        }
        if (!HRStringUtils.equals((String)newValue, (String)oldValue)) {
            this.getView().getModel().setValue("reason", (Object)"");
            if (StringUtils.isNotBlank((CharSequence)newValue)) {
                this.setReason(Long.parseLong(newValue));
            }
        }
    }

    private void handlerChangedStage(String newValue, String oldValue) {
        if (null != newValue) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"recruitmentstatus"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"recruitmentstatus", "reason"});
        }
        if (!HRStringUtils.equals((String)newValue, (String)oldValue)) {
            this.getView().getModel().setValue("recruitmentstatus", (Object)"");
            this.getView().getModel().setValue("reason", (Object)"");
            if (StringUtils.isNotBlank((CharSequence)newValue)) {
                this.setStatus(Long.parseLong(newValue));
            }
        }
    }

    public void afterBindData(EventObject evt) {
        this.setStage();
    }

    private void setStage() {
        ComboEdit stageComboEdit = (ComboEdit)this.getControl("recruitmentstage");
        ProcessStaStatus pss = this.getProcessStaStatus();
        Map map = pss.getStageMap();
        ArrayList comboItemList = new ArrayList(map.size());
        map.forEach((key, value) -> {
            ComboItem item = new ComboItem();
            item.setValue(key);
            item.setCaption(new LocaleString(value));
            comboItemList.add(item);
        });
        stageComboEdit.setComboItems(comboItemList);
    }

    private void setStatus(long stageId) {
        ComboEdit statusComboEdit = (ComboEdit)this.getControl("recruitmentstatus");
        ProcessStaStatus pss = this.getProcessStaStatus();
        Map map = pss.getStatusMap();
        ArrayList comboItemList = new ArrayList(8);
        map.forEach((key, value) -> {
            if (String.valueOf(stageId).equals(key)) {
                value.forEach((statusKey, statusValue) -> {
                    ComboItem item = new ComboItem();
                    item.setValue(statusKey);
                    item.setCaption(new LocaleString(statusValue));
                    comboItemList.add(item);
                });
            }
        });
        statusComboEdit.setComboItems(comboItemList);
    }

    private void setReason(long statusId) {
        DynamicObjectCollection reasonCollection = ChangeStageStatusHelper.queryReasonCollection((long)statusId);
        ComboEdit stageComboEdit = (ComboEdit)this.getControl("reason");
        stageComboEdit.setComboItems(this.getComboItemList(reasonCollection, "reasonnumber"));
    }

    private List<ComboItem> getComboItemList(DynamicObjectCollection collection, String objKey) {
        if (collection == null || collection.isEmpty()) {
            return new ArrayList<ComboItem>(0);
        }
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(collection.size());
        for (DynamicObject entryObj : collection) {
            ComboItem item = new ComboItem();
            DynamicObject stageObj = entryObj.getDynamicObject(objKey);
            if (stageObj == null) continue;
            item.setValue(stageObj.getString("id"));
            item.setCaption(new LocaleString(stageObj.getString("name")));
            comboItemList.add(item);
        }
        return comboItemList;
    }

    private long getProcessId() {
        List appFileIdList = (List)this.getView().getFormShowParameter().getCustomParam("appFileIdList");
        DynamicObject appFile = AppFileHelper.queryOne((long)((Long)appFileIdList.get(0)), (String)"recruproc.id");
        return appFile.getLong("recruproc.id");
    }

    public void registerListener(EventObject evt) {
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void click(EventObject evt) {
        this.getView().invokeOperation("donothing");
    }
}

